/*
 * Decompiled with CFR 0.152.
 */
package phero.mods.advancedreactors.tileentity;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;
import phero.mods.advancedreactors.AdvancedReactors;
import phero.mods.advancedreactors.tileentity.TileEntityNuclearReactor;
import phero.mods.advancedreactors.tileentity.TileEntityReactorChamberSteam;
import phero.mods.advancedreactors.util.Config;

public class TileEntityNuclearReactorSteam
extends TileEntityNuclearReactor
implements IFluidHandler {
    private static final float STEAM_PER_EU = 3.2f;
    protected FluidTank steamTank = new FluidTank(1000);

    public float sendEnergy(float send) {
        if (send <= 0.0f) {
            return 0.0f;
        }
        float steamFactor = (float)AdvancedReactors.energyGeneratorNuclear * 3.2f;
        int steamProduced = (int)Math.floor(send * steamFactor);
        Map<IFluidHandler, ForgeDirection> tanks = this.getAdjacentTanks();
        int numSideTanks = tanks.size();
        if (numSideTanks > 0) {
            int steamOut = steamProduced / numSideTanks;
            for (IFluidHandler side : tanks.keySet()) {
                steamProduced -= side.fill(tanks.get(side), FluidRegistry.getFluidStack((String)Config.steamReactorOutput, (int)steamOut), true);
            }
        }
        return (int)Math.floor((float)steamProduced / steamFactor);
    }

    private Map<IFluidHandler, ForgeDirection> getAdjacentTanks() {
        HashMap<IFluidHandler, ForgeDirection> tanks = new HashMap<IFluidHandler, ForgeDirection>();
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            int chamberX = this.field_70329_l + direction.offsetX;
            int chamberY = this.field_70330_m + direction.offsetY;
            int chamberZ = this.field_70327_n + direction.offsetZ;
            TileEntity target = this.field_70331_k.func_72796_p(chamberX, chamberY, chamberZ);
            if (target == null) continue;
            if (target instanceof TileEntityNuclearReactorSteam) {
                // empty if block
            }
            if (target instanceof TileEntityReactorChamberSteam) {
                tanks.putAll(((TileEntityReactorChamberSteam)target).getAdjacentTanks());
                continue;
            }
            if (!(target instanceof IFluidHandler) || !((IFluidHandler)target).canFill(direction.getOpposite(), FluidRegistry.getFluid((String)Config.steamReactorOutput))) continue;
            tanks.put((IFluidHandler)target, direction.getOpposite());
        }
        return tanks;
    }

    @Override
    public void func_70316_g() {
        this.sendEnergy(this.output);
        super.func_70316_g();
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{new FluidTankInfo((IFluidTank)this.steamTank)};
    }
}

