/*
 * Decompiled with CFR 0.152.
 */
package phero.mods.advancedreactors;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.reactor.IC2Reactor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import phero.mods.advancedreactors.bcIntegration.BCSubmodule;
import phero.mods.advancedreactors.cgIntegration.CGSubmodule;
import phero.mods.advancedreactors.gtIntegration.GTSubmodule;
import phero.mods.advancedreactors.proxy.CommonProxy;
import phero.mods.advancedreactors.tileentity.TileEntityGenerator;
import phero.mods.advancedreactors.tileentity.TileEntityNuclearReactor;
import phero.mods.advancedreactors.tileentity.TileEntityNuclearReactorElectric;
import phero.mods.advancedreactors.tileentity.TileEntityNuclearReactorSteam;
import phero.mods.advancedreactors.tileentity.TileEntityReactorChamberElectric;
import phero.mods.advancedreactors.tileentity.TileEntityReactorChamberSteam;
import phero.mods.advancedreactors.util.Config;
import phero.mods.advancedreactors.util.CreativeTabAdvancedReactors;
import phero.mods.advancedreactors.util.LocalizationHandler;
import phero.mods.advancedreactors.util.ModItems;

@Mod(name="Advanced Reactors", modid="AdvancedReactors", version="1.0.5-exp", acceptedMinecraftVersions="[1.6,1.7)", dependencies="required-after:IC2")
@NetworkMod(clientSideRequired=true, serverSideRequired=false)
public class AdvancedReactors {
    @Mod.Instance(value="AdvancedReactors")
    public static AdvancedReactors instance;
    @SidedProxy(clientSide="phero.mods.advancedreactors.proxy.ClientProxy", serverSide="phero.mods.advancedreactors.proxy.CommonProxy")
    public static CommonProxy proxy;
    public static CreativeTabAdvancedReactors tabAR;
    public static Logger logger;
    public static int energyGeneratorNuclear;
    public static float explosionPowerReactorMax;
    public static boolean enableSteamReactor;
    private static Class ExplosionIC2;
    private static Constructor explosionConstructor;
    private static Method explosionMethodExplode;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        LocalizationHandler.loadLanguages();
        Config.load(event.getSuggestedConfigurationFile());
        proxy.registerRenderers();
        proxy.registerSoundHandler();
        NetworkRegistry.instance().registerGuiHandler((Object)instance, (IGuiHandler)proxy);
        ModItems.init();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        this.findImportantIC2Fields();
        GameRegistry.registerTileEntity(TileEntityGenerator.class, (String)"TileGenerator");
        if (enableSteamReactor) {
            GameRegistry.registerTileEntity(TileEntityNuclearReactorSteam.class, (String)"TileNuclearReactor");
            GameRegistry.registerTileEntity(TileEntityReactorChamberSteam.class, (String)"TileReactorChamber");
        } else {
            GameRegistry.registerTileEntity(TileEntityNuclearReactorElectric.class, (String)"TileNuclearReactor");
            GameRegistry.registerTileEntity(TileEntityReactorChamberElectric.class, (String)"TileReactorChamber");
        }
        ModItems.initRecipes();
        if (Loader.isModLoaded((String)"gregtech_addon") || Loader.isModLoaded((String)"GregTech_Addon")) {
            GTSubmodule.init();
        }
        if (Loader.isModLoaded((String)"BuildCraft|Transport")) {
            BCSubmodule.init();
        }
        if (Loader.isModLoaded((String)"craftguide")) {
            CGSubmodule.init();
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
    }

    public static String getModId() {
        return "AdvancedReactors";
    }

    @SideOnly(value=Side.CLIENT)
    public static ItemStack getCreativeTabIcon() {
        return new ItemStack(ModItems.blockReactorChamber, 1, 1);
    }

    public static boolean explodeReactor(TileEntityNuclearReactor reactor, float explosionPower) {
        if (ExplosionIC2 == null || explosionConstructor == null || explosionMethodExplode == null) {
            logger.log(Level.WARNING, "IC2.core.ExplosionIC2 is unavailable - cannot explode reactor");
            return false;
        }
        try {
            Object[] args = new Object[]{reactor.field_70331_k, null, (double)reactor.field_70329_l, (double)reactor.field_70330_m, (double)reactor.field_70327_n, Float.valueOf(explosionPower), Float.valueOf(0.01f), Boolean.TRUE};
            Object explosion = explosionConstructor.newInstance(args);
            explosionMethodExplode.invoke(explosion, new Object[0]);
            return true;
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Tried to explode reactor " + reactor.toString() + ", but could not operate ExplosionIC2");
            return false;
        }
    }

    private void findImportantIC2Fields() {
        Class<?> IC2 = null;
        try {
            IC2 = Class.forName("ic2.core.IC2");
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.SEVERE, "Failed to locate class IC2 - this is probably a very big error");
            return;
        }
        try {
            ExplosionIC2 = Class.forName("ic2.core.ExplosionIC2");
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.WARNING, "Failed to locate class ExplosionIC2");
            ExplosionIC2 = null;
        }
        if (ExplosionIC2 != null) {
            try {
                explosionConstructor = ExplosionIC2.getConstructor(World.class, Entity.class, Double.TYPE, Double.TYPE, Double.TYPE, Float.TYPE, Float.TYPE, Boolean.TYPE);
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, "Failed to locate ExplosionIC2 constructor");
            }
            try {
                explosionMethodExplode = ExplosionIC2.getDeclaredMethod("doExplosion", new Class[0]);
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, "Failed to locate ExplosionIC2 explode method");
            }
        }
        try {
            enableSteamReactor = IC2.getField("enableSteamReactor").getBoolean(null);
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Failed to load ic2.core.IC2.enableSteamReactor - Steam Reactors will be unavailable");
            enableSteamReactor = false;
        }
        try {
            energyGeneratorNuclear = IC2Reactor.getEUOutput();
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Failed to load ic2.core.IC2.energyGeneratorNuclear - The default value of 5 will be used");
            energyGeneratorNuclear = 5;
        }
        try {
            explosionPowerReactorMax = IC2.getField("explosionPowerReactorMax").getFloat(null);
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Failed to load ic2.core.IC2.explosionPowerReactorMax - The default value of 45.0 will be used");
            explosionPowerReactorMax = 45.0f;
        }
    }

    static {
        tabAR = new CreativeTabAdvancedReactors();
        logger = null;
        energyGeneratorNuclear = 5;
        explosionPowerReactorMax = 45.0f;
        enableSteamReactor = false;
        ExplosionIC2 = null;
        explosionConstructor = null;
        explosionMethodExplode = null;
    }
}

