/*
 * Decompiled with CFR 0.152.
 */
package phero.mods.advancedreactors.tileentity;

import ic2.api.info.Info;
import ic2.api.reactor.IReactor;
import ic2.api.reactor.IReactorComponent;
import ic2.api.tile.IWrenchable;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import phero.mods.advancedreactors.AdvancedReactors;
import phero.mods.advancedreactors.blocks.ReactorType;
import phero.mods.advancedreactors.tileentity.TileEntityGenerator;
import phero.mods.advancedreactors.tileentity.TileEntityReactorChamber;
import phero.mods.advancedreactors.util.ModItems;
import phero.mods.advancedreactors.util.SlotReactor;

public abstract class TileEntityNuclearReactor
extends TileEntityGenerator
implements ISidedInventory,
IReactor,
IWrenchable {
    private static Random randomizer = new Random();
    public static final ForgeDirection[] horizDirections = new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.EAST, ForgeDirection.SOUTH, ForgeDirection.WEST};
    public static final ForgeDirection[] vertDirections = new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.DOWN};
    protected List<TileEntity> chambers = new ArrayList<TileEntity>();
    protected float output = 0.0f;
    private int updateTicker;
    private int heat = 0;
    private int maxHeat;
    private ItemStack[] inventory = new ItemStack[MAX_ROWS * MAX_COLUMNS];
    private short rows;
    private short columns;
    private float destructivePower = 1.0f;
    private String mySoundId = "";
    public static final short[] DEFAULT_ROWS = new short[]{3, 4, 5};
    public static final short[] DEFAULT_COLUMNS = new short[]{3, 4, 5};
    public static final short MAX_ROWS = (short)(DEFAULT_ROWS[2] + 2);
    public static final short MAX_COLUMNS = (short)(DEFAULT_COLUMNS[2] + 6);
    public static final int HEAT_EFFECT_RANGE = 7;
    public static final int TICK_RATE = 20;

    public TileEntityNuclearReactor() {
        this.updateTicker = randomizer.nextInt(20);
        this.reCalcReactorMaxHeat();
    }

    @Override
    public void func_70313_j() {
        this.stopReactor();
        super.func_70313_j();
    }

    private void stopReactor() {
        if (this.mySoundId != "") {
            AdvancedReactors.proxy.stopSound(this.mySoundId);
        }
        this.mySoundId = "";
    }

    public short getReactorInvWidth() {
        return this.columns;
    }

    public short getReactorInvHeight() {
        return this.rows;
    }

    public short getReactorSize() {
        return (short)(this.rows * this.columns);
    }

    public short reCalcReactorInvHeight() {
        int meta = 0;
        if (this.field_70331_k != null) {
            meta = this.func_70322_n();
        }
        short r = DEFAULT_ROWS[meta];
        if (this.field_70331_k == null) {
            return r;
        }
        for (ForgeDirection direction : vertDirections) {
            int chamberX = this.field_70329_l + direction.offsetX;
            int chamberY = this.field_70330_m + direction.offsetY;
            int chamberZ = this.field_70327_n + direction.offsetZ;
            TileEntity target = this.field_70331_k.func_72796_p(chamberX, chamberY, chamberZ);
            if (target == null || !(target instanceof TileEntityReactorChamber)) continue;
            r = (short)(r + 1);
            this.chambers.add(target);
        }
        return r;
    }

    private short reCalcReactorInvWidth() {
        int meta = 0;
        if (this.field_70331_k != null) {
            meta = this.func_70322_n();
        }
        short c = DEFAULT_COLUMNS[meta];
        if (this.field_70331_k == null) {
            return c;
        }
        for (ForgeDirection direction : horizDirections) {
            int chamberX = this.field_70329_l + direction.offsetX;
            int chamberY = this.field_70330_m + direction.offsetY;
            int chamberZ = this.field_70327_n + direction.offsetZ;
            TileEntity target = this.field_70331_k.func_72796_p(chamberX, chamberY, chamberZ);
            if (target == null || !(target instanceof TileEntityReactorChamber)) continue;
            c = (short)(c + 1);
            this.chambers.add(target);
        }
        return c;
    }

    public int reCalcReactorMaxHeat() {
        if (this.field_70331_k == null) {
            return ReactorType.getMaxHeatForMeta(0);
        }
        this.maxHeat = ReactorType.getMaxHeatForMeta(this.func_70322_n());
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            int chamberX = this.field_70329_l + direction.offsetX;
            int chamberY = this.field_70330_m + direction.offsetY;
            int chamberZ = this.field_70327_n + direction.offsetZ;
            TileEntity target = this.field_70331_k.func_72796_p(chamberX, chamberY, chamberZ);
            if (target == null || !(target instanceof TileEntityReactorChamber)) continue;
            this.maxHeat += ((TileEntityReactorChamber)target).getReactorBonusHeat();
        }
        return this.maxHeat;
    }

    public ItemStack getReactorComponentAt(int x, int y) {
        if (x >= 0 && x < this.columns && y >= 0 && y < this.rows) {
            return this.inventory[x + y * MAX_COLUMNS];
        }
        return null;
    }

    public void updateReactorCore() {
        this.chambers.clear();
        this.reCalcReactorMaxHeat();
        this.rows = this.reCalcReactorInvHeight();
        this.columns = this.reCalcReactorInvWidth();
        float scatter = 0.8f;
        for (int invY = 0; invY < MAX_ROWS; ++invY) {
            for (int invX = 0; invX < MAX_COLUMNS; ++invX) {
                ItemStack item;
                if (invY < this.rows && invX < this.columns || (item = this.getItemAtGridCoord(invX, invY)) == null || item.field_77994_a <= 0) continue;
                float rx = (randomizer.nextFloat() - 0.5f) * scatter + 0.5f;
                float ry = (randomizer.nextFloat() - 0.5f) * scatter + 0.5f;
                float rz = (randomizer.nextFloat() - 0.5f) * scatter + 0.5f;
                EntityItem entityItem = new EntityItem(this.field_70331_k, (double)((float)this.field_70329_l + rx), (double)((float)this.field_70330_m + ry), (double)((float)this.field_70327_n + rz), new ItemStack(item.field_77993_c, item.field_77994_a, item.func_77960_j()));
                if (item.func_77942_o()) {
                    entityItem.func_92059_d().func_77982_d((NBTTagCompound)item.func_77978_p().func_74737_b());
                }
                float factor = 0.05f;
                entityItem.field_70159_w = randomizer.nextGaussian() * (double)factor;
                entityItem.field_70181_x = randomizer.nextGaussian() * (double)factor + (double)0.2f;
                entityItem.field_70179_y = randomizer.nextGaussian() * (double)factor;
                this.field_70331_k.func_72838_d((Entity)entityItem);
                item.field_77994_a = 0;
                this.setItemAtGridCoord(invX, invY, null);
            }
        }
        this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    @Override
    public void func_70307_a(NBTTagCompound tagCompound) {
        super.func_70307_a(tagCompound);
        this.heat = tagCompound.func_74762_e("heat");
        this.output = tagCompound.func_74765_d("output");
        this.rows = tagCompound.func_74765_d("rows");
        this.columns = tagCompound.func_74765_d("columns");
        NBTTagList tagList = tagCompound.func_74761_m("Items");
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = (NBTTagCompound)tagList.func_74743_b(i);
            byte slot = tag.func_74771_c("Slot");
            if (slot < 0 || slot >= this.inventory.length) continue;
            this.inventory[slot] = ItemStack.func_77949_a((NBTTagCompound)tag);
        }
        this.reCalcReactorMaxHeat();
    }

    @Override
    public void func_70310_b(NBTTagCompound tagCompound) {
        super.func_70310_b(tagCompound);
        tagCompound.func_74768_a("heat", this.heat);
        tagCompound.func_74777_a("output", (short)this.output);
        tagCompound.func_74777_a("rows", this.rows);
        tagCompound.func_74777_a("columns", this.columns);
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < this.inventory.length; ++i) {
            ItemStack stack = this.inventory[i];
            if (stack == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("Slot", (byte)i);
            stack.func_77955_b(tag);
            itemList.func_74742_a((NBTBase)tag);
        }
        tagCompound.func_74782_a("Items", (NBTBase)itemList);
    }

    public Packet func_70319_e() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        this.func_70310_b(nbtTag);
        return new Packet132TileEntityData(this.field_70329_l, this.field_70330_m, this.field_70327_n, 1, nbtTag);
    }

    public void onDataPacket(INetworkManager net, Packet132TileEntityData packet) {
        this.func_70307_a(packet.field_73331_e);
    }

    public void func_70316_g() {
        super.func_70316_g();
        if (this.columns == 0 || this.rows == 0) {
            this.chambers.clear();
            this.rows = this.reCalcReactorInvWidth();
            this.columns = this.reCalcReactorInvHeight();
        }
        if (++this.updateTicker % 20 != 0) {
            return;
        }
        this.updateTicker = 0;
        this.output = 0.0f;
        if (this.field_70331_k.func_72873_a(this.field_70329_l, this.field_70330_m, this.field_70327_n, 2)) {
            this.destructivePower = 1.0f;
            this.maxHeat = this.reCalcReactorMaxHeat();
            this.processChambers();
            if (this.calculateHeatEffects()) {
                return;
            }
            this.setActive(this.output > 0.0f);
            this.func_70296_d();
        }
        if (this.output > 0.0f && this.mySoundId == "") {
            this.mySoundId = AdvancedReactors.proxy.playSound(this.field_70329_l, this.field_70330_m, this.field_70327_n, "Reactor", 1.0f, true);
        } else if (this.output == 0.0f) {
            this.stopReactor();
        }
        this.field_70331_k.func_72902_n(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public void processChambers() {
        IReactorComponent comp;
        ItemStack component;
        int x;
        int y;
        for (y = 0; y < this.rows; ++y) {
            for (x = 0; x < this.columns; ++x) {
                component = this.getItemAtGridCoord(x, y);
                if (component == null || !(component.func_77973_b() instanceof IReactorComponent)) continue;
                comp = (IReactorComponent)component.func_77973_b();
                comp.processChamber(this, component, x, y, true);
            }
        }
        for (y = 0; y < this.rows; ++y) {
            for (x = 0; x < this.columns; ++x) {
                component = this.getItemAtGridCoord(x, y);
                if (component == null || !(component.func_77973_b() instanceof IReactorComponent)) continue;
                comp = (IReactorComponent)component.func_77973_b();
                comp.processChamber(this, component, x, y, false);
            }
        }
        if (this.active) {
            for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                int chamberX = this.field_70329_l + direction.offsetX;
                int chamberY = this.field_70330_m + direction.offsetY;
                int chamberZ = this.field_70327_n + direction.offsetZ;
                TileEntity target = this.field_70331_k.func_72796_p(chamberX, chamberY, chamberZ);
                if (target == null || !(target instanceof TileEntityReactorChamber)) continue;
                ((TileEntityReactorChamber)target).processChamber(this);
            }
        }
    }

    public boolean calculateHeatEffects() {
        ChunkCoordinates coord;
        if (this.field_70331_k.field_72995_K || this.heat < 2500 || AdvancedReactors.explosionPowerReactorMax <= 0.0f) {
            return false;
        }
        float power = (float)this.heat / (float)this.maxHeat;
        if (power >= 1.0f) {
            this.explode();
            return true;
        }
        if (power >= 0.7f) {
            List list1 = this.field_70331_k.func_72872_a(EntityLiving.class, AxisAlignedBB.func_72330_a((double)(this.field_70329_l - 3), (double)(this.field_70330_m - 3), (double)(this.field_70327_n - 3), (double)(this.field_70329_l + 4), (double)(this.field_70330_m + 4), (double)(this.field_70327_n + 4)));
            for (int l = 0; l < list1.size(); ++l) {
                Entity ent = (Entity)list1.get(l);
                ent.func_70097_a(Info.DMG_RADIATION, (float)((int)((float)this.field_70331_k.field_73012_v.nextInt(4) * this.destructivePower)));
                ent.func_70015_d((int)(10.0f * (power - 0.6f)));
            }
        }
        if ((coord = this.getRandomCoordInHeatEffectRange()) != null) {
            int x = coord.field_71574_a;
            int y = coord.field_71572_b;
            int z = coord.field_71573_c;
            int id = this.field_70331_k.func_72798_a(x, y, z);
            if (this.field_70331_k.func_72799_c(x, y, z)) {
                if (power > 0.5f) {
                    this.spawnFireAt(x, y, z);
                }
            } else if (id == Block.field_71978_w.field_71990_ca) {
                if (power > 0.85f && this.field_70331_k.field_73012_v.nextInt(4) == 0) {
                    this.field_70331_k.func_72832_d(x, y, z, Block.field_71981_t.field_71990_ca, 0, 7);
                }
            } else if (id == Block.field_71939_E.field_71990_ca) {
                if (power > 0.6f) {
                    this.field_70331_k.func_72832_d(x, y, z, Block.field_71946_M.field_71990_ca, 0, 7);
                }
            } else if (id == Block.field_71946_M.field_71990_ca) {
                if (power > 0.4f) {
                    if (this.field_70331_k.field_73012_v.nextInt(3) == 0) {
                        this.field_70331_k.func_72832_d(x, y, z, Block.field_71944_C.field_71990_ca, 15, 7);
                    } else {
                        this.field_70331_k.func_72832_d(x, y, z, 0, 0, 7);
                    }
                }
            } else {
                Material mat = Block.field_71973_m[id].field_72018_cp;
                if (mat == Material.field_76246_e || mat == Material.field_76256_h || mat == Material.field_76248_c || mat == Material.field_76267_y) {
                    if (power > 0.85f && this.field_70331_k.field_73012_v.nextInt(4) == 0) {
                        this.field_70331_k.func_72832_d(x, y, z, Block.field_71944_C.field_71990_ca, 10, 7);
                    }
                } else if (mat == Material.field_76244_g || mat == Material.field_76260_u || mat == Material.field_76259_v || mat == Material.field_76258_w) {
                    if (power > 0.3f) {
                        this.field_70331_k.func_72832_d(x, y, z, 0, 0, 7);
                    }
                } else if (mat == Material.field_76245_d || mat == Material.field_76257_i || mat == Material.field_76253_m || mat == Material.field_76254_j || mat == Material.field_76268_x) {
                    if (power > 0.5f) {
                        this.field_70331_k.func_72832_d(x, y, z, Block.field_72067_ar.field_71990_ca, 0, 7);
                    }
                } else if (mat == Material.field_76247_b && power > 0.3f) {
                    this.field_70331_k.func_72832_d(x, y, z, Block.field_71979_v.field_71990_ca, 0, 7);
                }
            }
        }
        return false;
    }

    public ChunkCoordinates getRandomCoordInHeatEffectRange() {
        ChunkCoordinates c = new ChunkCoordinates((int)((double)((float)this.field_70329_l + 0.5f + (float)this.field_70331_k.field_73012_v.nextInt(7)) - 3.5), (int)((double)((float)this.field_70330_m + 0.5f + (float)this.field_70331_k.field_73012_v.nextInt(7)) - 3.5), (int)((double)((float)this.field_70327_n + 0.5f + (float)this.field_70331_k.field_73012_v.nextInt(7)) - 3.5));
        if (c.field_71574_a == this.field_70329_l && c.field_71572_b == this.field_70330_m && c.field_71573_c == this.field_70327_n) {
            return null;
        }
        return c;
    }

    public void setItemAtGridCoord(int x, int y, ItemStack stack) {
        if (x >= 0 && x < MAX_COLUMNS && y >= 0 && y < MAX_ROWS) {
            this.func_70299_a(x + y * MAX_COLUMNS, stack);
        }
    }

    public ItemStack getItemAtGridCoord(int x, int y) {
        if (x >= 0 && x < MAX_COLUMNS && y >= 0 && y < MAX_ROWS) {
            return this.func_70301_a(x + y * MAX_COLUMNS);
        }
        return null;
    }

    public boolean spawnFireAt(int x, int y, int z) {
        if (this.field_70331_k.func_72797_t(x, y - 1, z) || this.canNeighborBurn(this.field_70331_k, x, y, z)) {
            return this.field_70331_k.func_72832_d(x, y, z, Block.field_72067_ar.field_71990_ca, 0, 7);
        }
        return false;
    }

    private boolean canNeighborBurn(World worldObj, int x, int y, int z) {
        return this.canBlockCatchFire((IBlockAccess)worldObj, x + 1, y, z, ForgeDirection.WEST) || this.canBlockCatchFire((IBlockAccess)worldObj, x - 1, y, z, ForgeDirection.EAST) || this.canBlockCatchFire((IBlockAccess)worldObj, x, y - 1, z, ForgeDirection.UP) || this.canBlockCatchFire((IBlockAccess)worldObj, x, y + 1, z, ForgeDirection.DOWN) || this.canBlockCatchFire((IBlockAccess)worldObj, x, y, z - 1, ForgeDirection.SOUTH) || this.canBlockCatchFire((IBlockAccess)worldObj, x, y, z + 1, ForgeDirection.NORTH);
    }

    public boolean canBlockCatchFire(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        Block block = Block.field_71973_m[world.func_72798_a(x, y, z)];
        if (block != null) {
            return block.isFlammable(world, x, y, z, world.func_72805_g(x, y, z), face);
        }
        return false;
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int index) {
        if (index >= 0 && index < this.inventory.length) {
            return this.inventory[index];
        }
        return null;
    }

    public void func_70299_a(int index, ItemStack itemStack) {
        this.inventory[index] = itemStack;
        if (itemStack == null) {
            return;
        }
        int sizeLimit = this.func_70297_j_();
        if (itemStack.field_77994_a > sizeLimit) {
            itemStack.field_77994_a = sizeLimit;
        }
    }

    public ItemStack func_70298_a(int index, int amount) {
        ItemStack stack = this.func_70301_a(index);
        if (stack != null) {
            if (stack.field_77994_a <= amount) {
                this.func_70299_a(index, null);
            } else {
                stack = stack.func_77979_a(amount);
                if (stack.field_77994_a == 0) {
                    this.func_70299_a(index, null);
                }
            }
        }
        return stack;
    }

    public ItemStack func_70304_b(int index) {
        ItemStack stack = this.func_70301_a(index);
        if (stack != null) {
            this.func_70299_a(index, null);
        }
        return stack;
    }

    public String func_70303_b() {
        return "container.nuclearreactor";
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n) == this && player.func_70092_e((double)this.field_70329_l + 0.5, (double)this.field_70330_m + 0.5, (double)this.field_70327_n + 0.5) < 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public int[] func_94128_d(int side) {
        int[] ret = new int[this.inventory.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = i;
        }
        return ret;
    }

    public boolean func_102007_a(int index, ItemStack itemStack, int side) {
        return this.func_94041_b(index, itemStack);
    }

    public boolean func_102008_b(int index, ItemStack itemStack, int side) {
        return true;
    }

    @Override
    public ChunkCoordinates getPosition() {
        return new ChunkCoordinates(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    @Override
    public World getWorld() {
        return this.field_70331_k;
    }

    @Override
    public int getHeat() {
        return this.heat;
    }

    @Override
    public void setHeat(int heat) {
        this.heat = heat;
    }

    @Override
    public int addHeat(int amount) {
        this.heat += amount;
        return this.heat;
    }

    @Override
    public int getMaxHeat() {
        return this.maxHeat;
    }

    public float getHeatRatio() {
        return (float)this.heat / (float)this.maxHeat;
    }

    @Override
    public void setMaxHeat(int newMaxHeat) {
        this.maxHeat = newMaxHeat;
    }

    @Override
    public float getHeatEffectModifier() {
        return this.destructivePower;
    }

    @Override
    public void setHeatEffectModifier(float newHEM) {
        this.destructivePower = newHEM;
    }

    @Override
    public float getReactorEnergyOutput() {
        return this.output;
    }

    @Override
    public float addOutput(float energy) {
        return this.output += energy;
    }

    @Override
    public ItemStack getItemAt(int x, int y) {
        return this.getReactorComponentAt(x, y);
    }

    @Override
    public void setItemAt(int x, int y, ItemStack item) {
        this.setItemAtGridCoord(x, y, item);
    }

    @Override
    public void explode() {
        float explosionPower = 10.0f;
        float explosionScale = ReactorType.getExplosionScaleForMeta(this.func_70322_n());
        for (int y = 0; y < this.rows; ++y) {
            for (int x = 0; x < this.columns; ++x) {
                ItemStack stack = this.getItemAtGridCoord(x, y);
                if (stack != null && stack.func_77973_b() instanceof IReactorComponent) {
                    float power = ((IReactorComponent)stack.func_77973_b()).influenceExplosion(this, stack);
                    if (power > 0.0f && power < 1.0f) {
                        explosionScale *= power;
                    } else {
                        explosionPower += power;
                    }
                }
                this.setItemAtGridCoord(x, y, null);
            }
        }
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            int chamberX = this.field_70329_l + direction.offsetX;
            int chamberY = this.field_70330_m + direction.offsetY;
            int chamberZ = this.field_70327_n + direction.offsetZ;
            TileEntity target = this.field_70331_k.func_72796_p(chamberX, chamberY, chamberZ);
            if (target == null || !(target instanceof TileEntityReactorChamber)) continue;
            explosionScale *= ((TileEntityReactorChamber)target).influenceExplosion();
        }
        if ((explosionPower *= this.destructivePower * explosionScale) > AdvancedReactors.explosionPowerReactorMax) {
            explosionPower = AdvancedReactors.explosionPowerReactorMax;
        }
        AdvancedReactors.logger.info("Advanced Reactor at (" + this.field_70329_l + "," + this.field_70330_m + "," + this.field_70327_n + ")[dim " + this.field_70331_k.field_73011_w.field_76574_g + "] exploded (explosion power " + explosionPower + ")");
        this.field_70331_k.func_72832_d(this.field_70329_l, this.field_70330_m, this.field_70327_n, 0, 0, 7);
        AdvancedReactors.explodeReactor(this, explosionPower);
    }

    @Override
    public int getTickRate() {
        return 20;
    }

    @Override
    public boolean produceEnergy() {
        return this.field_70331_k.func_72864_z(this.field_70329_l, this.field_70330_m, this.field_70327_n) && AdvancedReactors.energyGeneratorNuclear != 0;
    }

    @Override
    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return false;
    }

    @Override
    public short getFacing() {
        return 0;
    }

    @Override
    public void setFacing(short facing) {
    }

    @Override
    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return true;
    }

    @Override
    public float getWrenchDropRate() {
        return 0.8f;
    }

    @Override
    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return new ItemStack(ModItems.blockReactor, 1, this.func_70322_n());
    }

    public boolean func_94042_c() {
        return false;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return i % MAX_COLUMNS < this.columns && i / MAX_COLUMNS < this.rows && SlotReactor.testForValidItem(itemstack, this.func_70322_n());
    }
}

