/*
 * Decompiled with CFR 0.152.
 */
package phero.mods.advancedreactors.blocks;

public enum ReactorType {
    TIER1("nuclearReactor1", 10000, 1.0f, 3, 3),
    TIER2("nuclearReactor2", 12000, 0.85f, 4, 4),
    TIER3("nuclearReactor3", 20000, 0.6f, 5, 5);

    public String blockName;
    public int maxHeat;
    public float explosionScale;
    public int defaultRows;
    public int defaultColumns;

    private ReactorType(String blockName, int maxHeat, float explosionScale, int rows, int columns) {
        this.blockName = blockName;
        this.maxHeat = maxHeat;
        this.explosionScale = explosionScale;
        this.defaultRows = rows;
        this.defaultColumns = columns;
    }

    public static int getMaxHeatForMeta(int meta) {
        if (meta < 0 || meta >= ReactorType.values().length) {
            return 0;
        }
        return ReactorType.values()[meta].maxHeat;
    }

    public static float getExplosionScaleForMeta(int meta) {
        if (meta < 0 || meta >= ReactorType.values().length) {
            return 0.0f;
        }
        return ReactorType.values()[meta].explosionScale;
    }

    public static int getDefaultRowsForMeta(int meta) {
        if (meta < 0 || meta >= ReactorType.values().length) {
            return 0;
        }
        return ReactorType.values()[meta].defaultRows;
    }

    public static int getDefaultColumnsForMeta(int meta) {
        if (meta < 0 || meta >= ReactorType.values().length) {
            return 0;
        }
        return ReactorType.values()[meta].defaultColumns;
    }

    public static String getNameForMeta(int meta) {
        if (meta < 0 || meta >= ReactorType.values().length) {
            return "";
        }
        return ReactorType.values()[meta].blockName;
    }
}

