/*
 * Decompiled with CFR 0.152.
 */
package phero.mods.advancedreactors.tileentity;

import ic2.api.reactor.IReactor;
import ic2.api.reactor.IReactorChamber;
import ic2.api.tile.IWrenchable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import phero.mods.advancedreactors.blocks.ReactorChamberType;
import phero.mods.advancedreactors.tileentity.TileEntityGenerator;
import phero.mods.advancedreactors.tileentity.TileEntityNuclearReactor;
import phero.mods.advancedreactors.util.ModItems;

public abstract class TileEntityReactorChamber
extends TileEntityGenerator
implements IReactorChamber,
ISidedInventory,
IWrenchable {
    public static final int ENDERCHAMBER_VENT = 32;
    public static final int ANGELICCHAMBER_VENT = 4;
    public static final float LYCANTHROPICCHAMBER_BONUS = 0.1f;
    public static final float ANGELICCHAMBER_BONUS = 0.05f;
    protected boolean initialized = false;

    public short getReactorBonusHeat() {
        return ReactorChamberType.getHeatBonusForMeta(this.func_70322_n());
    }

    public void processChamber(IReactor reactor) {
        int rHeat = reactor.getHeat();
        int meta = this.func_70322_n();
        switch (meta) {
            case 4: {
                if ((rHeat -= 32) < 0) {
                    rHeat = 0;
                }
                reactor.setHeat(rHeat);
                break;
            }
            case 5: {
                if (!((float)this.field_70331_k.func_72853_d() < 0.01f)) break;
                reactor.addOutput(0.1f * reactor.getReactorEnergyOutput());
                break;
            }
            case 6: {
                if ((rHeat -= 4) < 0) {
                    rHeat = 0;
                }
                reactor.setHeat(rHeat);
                if (!this.field_70331_k.func_72937_j(this.field_70329_l, this.field_70330_m + 1, this.field_70327_n) || !(this.field_70331_k.func_72971_b(0.0f) > 0.8f)) break;
                reactor.addOutput(0.05f * reactor.getReactorEnergyOutput());
            }
        }
    }

    public final boolean canUpdate() {
        return true;
    }

    public boolean enableUpdateEntity() {
        return false;
    }

    public float influenceExplosion() {
        return 1.0f - ReactorChamberType.getBlastResistBonusForMeta(this.func_70322_n());
    }

    public int func_70302_i_() {
        TileEntityNuclearReactor reactor = (TileEntityNuclearReactor)this.getReactor();
        if (reactor != null) {
            return reactor.func_70302_i_();
        }
        return 0;
    }

    public ItemStack func_70301_a(int index) {
        TileEntityNuclearReactor reactor = (TileEntityNuclearReactor)this.getReactor();
        if (reactor != null) {
            return reactor.func_70301_a(index);
        }
        return null;
    }

    public ItemStack func_70298_a(int index, int amount) {
        TileEntityNuclearReactor reactor = (TileEntityNuclearReactor)this.getReactor();
        if (reactor != null) {
            return reactor.func_70298_a(index, amount);
        }
        return null;
    }

    public ItemStack func_70304_b(int index) {
        TileEntityNuclearReactor reactor = (TileEntityNuclearReactor)this.getReactor();
        if (reactor != null) {
            return reactor.func_70301_a(index);
        }
        return null;
    }

    public void func_70299_a(int index, ItemStack itemStack) {
        TileEntityNuclearReactor reactor = (TileEntityNuclearReactor)this.getReactor();
        if (reactor != null) {
            reactor.func_70299_a(index, itemStack);
        }
    }

    public String func_70303_b() {
        TileEntityNuclearReactor reactor = (TileEntityNuclearReactor)this.getReactor();
        if (reactor != null) {
            return reactor.func_70303_b();
        }
        return null;
    }

    public boolean func_94042_c() {
        TileEntityNuclearReactor reactor = (TileEntityNuclearReactor)this.getReactor();
        if (reactor != null) {
            return reactor.func_94042_c();
        }
        return false;
    }

    public boolean func_94041_b(int index, ItemStack itemstack) {
        TileEntityNuclearReactor reactor = (TileEntityNuclearReactor)this.getReactor();
        if (reactor != null) {
            return reactor.func_94041_b(index, itemstack);
        }
        return false;
    }

    public int func_70297_j_() {
        TileEntityNuclearReactor reactor = (TileEntityNuclearReactor)this.getReactor();
        if (reactor != null) {
            return reactor.func_70297_j_();
        }
        return 0;
    }

    public void func_70296_d() {
    }

    public boolean func_70300_a(EntityPlayer player) {
        TileEntityNuclearReactor reactor = (TileEntityNuclearReactor)this.getReactor();
        if (reactor != null) {
            return reactor.func_70300_a(player);
        }
        return false;
    }

    public void func_70295_k_() {
        TileEntityNuclearReactor reactor = (TileEntityNuclearReactor)this.getReactor();
        if (reactor != null) {
            reactor.func_70295_k_();
        }
    }

    public void func_70305_f() {
        TileEntityNuclearReactor reactor = (TileEntityNuclearReactor)this.getReactor();
        if (reactor != null) {
            reactor.func_70305_f();
        }
    }

    public int[] func_94128_d(int side) {
        TileEntityNuclearReactor reactor = (TileEntityNuclearReactor)this.getReactor();
        if (reactor != null) {
            return reactor.func_94128_d(side);
        }
        return new int[0];
    }

    public boolean func_102007_a(int index, ItemStack itemstack, int side) {
        TileEntityNuclearReactor reactor = (TileEntityNuclearReactor)this.getReactor();
        if (reactor != null) {
            return reactor.func_102007_a(index, itemstack, side);
        }
        return false;
    }

    public boolean func_102008_b(int index, ItemStack itemstack, int side) {
        TileEntityNuclearReactor reactor = (TileEntityNuclearReactor)this.getReactor();
        if (reactor != null) {
            return reactor.func_102008_b(index, itemstack, side);
        }
        return false;
    }

    @Override
    public IReactor getReactor() {
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            int reactorX = this.field_70329_l + direction.offsetX;
            int reactorY = this.field_70330_m + direction.offsetY;
            int reactorZ = this.field_70327_n + direction.offsetZ;
            TileEntity target = this.field_70331_k.func_72796_p(reactorX, reactorY, reactorZ);
            if (!(target instanceof TileEntityNuclearReactor)) continue;
            return (IReactor)target;
        }
        return null;
    }

    @Override
    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return false;
    }

    @Override
    public short getFacing() {
        return 0;
    }

    @Override
    public void setFacing(short facing) {
    }

    @Override
    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return true;
    }

    @Override
    public float getWrenchDropRate() {
        return 0.8f;
    }

    @Override
    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return new ItemStack(ModItems.blockReactorChamber, 1, this.func_70322_n());
    }
}

