/*
 * Decompiled with CFR 0.152.
 */
package phero.mods.advancedreactors.tileentity;

import ic2.api.reactor.IReactor;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;
import phero.mods.advancedreactors.AdvancedReactors;
import phero.mods.advancedreactors.tileentity.TileEntityNuclearReactorSteam;
import phero.mods.advancedreactors.tileentity.TileEntityReactorChamber;
import phero.mods.advancedreactors.util.Config;

public class TileEntityReactorChamberSteam
extends TileEntityReactorChamber
implements IFluidHandler {
    private static final float STEAM_PER_EU = 3.2f;
    protected FluidTank steamTank = new FluidTank(1000);

    public void func_70316_g() {
        if (!this.initialized && !this.field_70331_k.field_72995_K) {
            TileEntityNuclearReactorSteam reactor = (TileEntityNuclearReactorSteam)this.getReactor();
            if (reactor != null) {
                reactor.updateReactorCore();
            }
            this.initialized = true;
        }
        super.func_70316_g();
    }

    @Override
    public void func_70313_j() {
        TileEntityNuclearReactorSteam reactor;
        if (!this.field_70331_k.field_72995_K && (reactor = (TileEntityNuclearReactorSteam)this.getReactor()) != null) {
            reactor.updateReactorCore();
        }
        super.func_70313_j();
    }

    public float sendEnergy(float send) {
        if (send <= 0.0f) {
            return 0.0f;
        }
        float steamFactor = (float)AdvancedReactors.energyGeneratorNuclear * 3.2f;
        int steamProduced = (int)Math.floor(send * steamFactor);
        int numSideTanks = 0;
        IFluidHandler[] side = new IFluidHandler[6];
        ForgeDirection[] sideDir = new ForgeDirection[6];
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            int chamberX = this.field_70329_l + direction.offsetX;
            int chamberY = this.field_70330_m + direction.offsetY;
            int chamberZ = this.field_70327_n + direction.offsetZ;
            TileEntity target = this.field_70331_k.func_72796_p(chamberX, chamberY, chamberZ);
            if (target == null || !(target instanceof IFluidHandler) || !((IFluidHandler)target).canFill(direction.getOpposite(), FluidRegistry.getFluid((String)Config.steamReactorOutput))) continue;
            side[numSideTanks] = (IFluidHandler)target;
            sideDir[numSideTanks] = direction;
            ++numSideTanks;
        }
        if (numSideTanks > 0) {
            int steamOut = steamProduced / numSideTanks;
            for (int i = 0; i < numSideTanks; ++i) {
                steamProduced -= side[i].fill(sideDir[i].getOpposite(), FluidRegistry.getFluidStack((String)Config.steamReactorOutput, (int)steamOut), true);
            }
        }
        return (int)Math.floor((float)steamProduced / steamFactor);
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        int chamberX = this.field_70329_l + from.offsetX;
        int chamberY = this.field_70330_m + from.offsetY;
        int chamberZ = this.field_70327_n + from.offsetZ;
        TileEntity target = this.field_70331_k.func_72796_p(chamberX, chamberY, chamberZ);
        IReactor myReactor = this.getReactor();
        return target instanceof TileEntityNuclearReactorSteam && myReactor == (IReactor)target;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{new FluidTankInfo((IFluidTank)this.steamTank)};
    }

    public Map<IFluidHandler, ForgeDirection> getAdjacentTanks() {
        HashMap<IFluidHandler, ForgeDirection> tanks = new HashMap<IFluidHandler, ForgeDirection>();
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            int chamberX = this.field_70329_l + direction.offsetX;
            int chamberY = this.field_70330_m + direction.offsetY;
            int chamberZ = this.field_70327_n + direction.offsetZ;
            TileEntity target = this.field_70331_k.func_72796_p(chamberX, chamberY, chamberZ);
            if (target == null || target instanceof TileEntityNuclearReactorSteam || target instanceof TileEntityReactorChamberSteam || !(target instanceof IFluidHandler) || !((IFluidHandler)target).canFill(direction.getOpposite(), FluidRegistry.getFluid((String)Config.steamReactorOutput))) continue;
            tanks.put((IFluidHandler)target, direction.getOpposite());
        }
        return tanks;
    }
}

