/*
 * Decompiled with CFR 0.152.
 */
package phero.mods.advancedreactors.util;

import cpw.mods.fml.client.FMLClientHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundManager;
import net.minecraft.client.audio.SoundPoolEntry;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.EntityLivingBase;
import net.minecraftforge.client.event.sound.SoundLoadEvent;
import phero.mods.advancedreactors.AdvancedReactors;
import phero.mods.advancedreactors.util.Config;

public class SoundHelper {
    private static int sndID = 0;
    public static final String SOUND_PREFIX = "advancedreactors:";
    public static final String[] soundFiles = new String[]{"Reactor.ogg"};

    public static void loadSound(SoundLoadEvent event) {
        for (String soundFile : soundFiles) {
            try {
                event.manager.func_77372_a(SOUND_PREFIX + soundFile);
                event.manager.field_77379_b.func_77458_a(SOUND_PREFIX + soundFile.substring(0, soundFile.length() - 4));
            }
            catch (RuntimeException ex) {
                AdvancedReactors.logger.warning("Failed loading sound file: " + soundFile);
            }
        }
    }

    public static String playSound(float x, float y, float z, String soundName, float volume, boolean looping) {
        EntityLivingBase player;
        if (!Config.enableSounds) {
            return "";
        }
        GameSettings settings = FMLClientHandler.instance().getClient().field_71474_y;
        if (settings != null && settings.field_74340_b < 0.01f || volume <= 0.01f) {
            return null;
        }
        float range = 16.0f;
        if (volume > 1.0f) {
            range *= volume;
        }
        if ((player = FMLClientHandler.instance().getClient().field_71451_h) == null || player.func_70092_e((double)x, (double)y, (double)z) > (double)(range * range)) {
            return null;
        }
        SoundManager sndManager = Minecraft.func_71410_x().field_71416_A;
        SoundPoolEntry sound = sndManager.field_77379_b.func_77458_a(SOUND_PREFIX + soundName);
        if (sound != null) {
            sndID = (sndID + 1) % 64;
            String soundId = "advReactors.reactor." + sndID;
            sndManager.field_77381_a.newSource(volume > 1.0f, soundId, sound.func_110457_b(), sound.func_110458_a(), looping, x, y, z, 2, range);
            sndManager.field_77381_a.setPitch(soundId, 1.0f);
            sndManager.field_77381_a.setVolume(soundId, volume * settings.field_74340_b);
            sndManager.field_77381_a.play(soundId);
            return soundId;
        }
        return null;
    }

    public static boolean isPlaying(String soundId) {
        return Minecraft.func_71410_x().field_71416_A.field_77381_a.playing(soundId);
    }

    public static void stopSound(String soundId) {
        if (soundId == null || soundId == "") {
            AdvancedReactors.logger.info("Tried to stop a null sound - ignoring");
        } else {
            Minecraft.func_71410_x().field_71416_A.field_77381_a.stop(soundId);
            Minecraft.func_71410_x().field_71416_A.field_77381_a.removeSource(soundId);
        }
    }
}

