package rawdev.core;
import sun.awt.windows.*;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import sun.misc.Unsafe;
@SuppressWarnings("all")

public class UnsafeImp
{
	
	private static final sun.misc.Unsafe WRAPPED;
	
	static {
		try {
			Class unsafe = Class.forName("sun.misc.Unsafe");
			Constructor instance = unsafe.getDeclaredConstructors()[0];
			instance.setAccessible(true);
			WRAPPED = (Unsafe) instance.newInstance();
		} catch (Throwable e) {
			throw new RuntimeException("UnsafeImp failed to initialize");
		}
	}
	
	/**
	 * special note: this code developed for minecraft forge
	 */
	
	//FIXME Must search all superclasses
	//Must clearly state, that call versus class type is automatic static field search
	static public Object Read_Object(Object Owner,String Name) throws Throwable
	{
		Field  f = Owner instanceof Class ? ((Class) Owner).getDeclaredField(Name) : Owner.getClass().getDeclaredField(Name);
		Object o =(f.getModifiers() & 8) != 0 ? WRAPPED.staticFieldBase(f) : Owner;
		
		if ((f.getModifiers() & 8) != 0)
			return WRAPPED.getObject(o,WRAPPED.staticFieldOffset(f));
			return WRAPPED.getObject(o,WRAPPED.objectFieldOffset(f));
	}
	
	static private Field Fetch_Field(Object Owner, String... Names)
	{
		//return first field with given name or null
		
		Class clz = (Class) ((Owner instanceof Class) ? Owner : Owner.getClass());
		
		for(;;)
		{
			Field[] fl = clz.getDeclaredFields();
			for (Field OUT : fl){
				for (String INS : Names){
					if (!OUT.getName().equals(INS))
						continue;
					return OUT;
				}
			}
			clz = clz.getSuperclass();
			if (clz == null)
				break;
		}
		return null;
	}
	
	static public void ftfl0(Object Owner,Object Value, String... Names)
	{
		if (Owner == null || Names == null)
			return;
		
		boolean sstatic = false;
		Class 	ssource = null;
		Field   sreturn = null;
		
		if (Owner instanceof Class)
		{
			sstatic = true;
			ssource = (Class) Owner;
		}else
		{
			ssource = Owner.getClass();
		}
		
		EXIT:
		for(;;)
		{
			Field[] fa = ssource.getDeclaredFields();
			for (Field a : fa){
				for (String b : Names){
					if (!a.getName().equals(b))
						continue;
					sreturn = a;
					break EXIT;
				}
			}
			ssource = ssource.getSuperclass();
			if (ssource == null)
				break;
		}
		
		if (sreturn == null)
			return;
		
		
		if ((sreturn.getModifiers() & 8) == 0 && sstatic)
			return;
		
		
		if ((sreturn.getModifiers() & 8) != 0)
			WRAPPED.putObject(WRAPPED.staticFieldBase(sreturn),WRAPPED.staticFieldOffset(sreturn),Value);
			WRAPPED.putObject(Owner,WRAPPED.objectFieldOffset(sreturn),Value);
	}
	
	static public void Write_Object(Object Owner,String Name,Object Value) throws Throwable
	{
		Field  f = Owner instanceof Class ? ((Class) Owner).getDeclaredField(Name) : Owner.getClass().getDeclaredField(Name);
		Object o =(f.getModifiers() & 8) != 0 ? WRAPPED.staticFieldBase(f) : Owner;
		
		if ((f.getModifiers() & 8) != 0)
			WRAPPED.putObject(o,WRAPPED.staticFieldOffset(f),Value);
		
		if ((f.getModifiers() & 8) == 0)
			WRAPPED.putObject(o,WRAPPED.objectFieldOffset(f),Value);

	}
	
	
	public static void main(String[] args) throws UnsupportedFlavorException, IOException, NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
		
		WClipboard clipboard =  (WClipboard) Toolkit.getDefaultToolkit().getSystemClipboard();
		
		Method m1 = clipboard.getClass().getDeclaredMethod("getClipboardData", long.class);
		Method m2 = clipboard.getClass().getDeclaredMethod("getClipboardFormats", null);
		
		m1.setAccessible(true);
		m2.setAccessible(true);
		
		clipboard.openClipboard(null);
		
		long[] test2 = (long[]) m2.invoke(clipboard, null);
		
		//for (long b : test2)
			//System.out.println(b);
		
		byte[] test1 = new byte[]{1};
		for (long l : test2)
		{
			try {
				test1 = (byte[]) m1.invoke(clipboard, l);
				System.out.println("DATA FOR TYPE # " + l);
				for (byte b : test1)
					System.out.println(b);
			} catch (Exception e) {
			}
		}
		
		clipboard.closeClipboard();
	}
}
