package rawdev.core;

import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldProviderSurface;

public class WorldProviderSurfaceImp extends WorldProvider {
	public WorldProviderSurfaceImp (WorldProviderSurface e)
	{
	    this.worldObj = e.worldObj;
	    this.terrainType = e.terrainType;
	    this.field_82913_c = e.field_82913_c;
	    this.worldChunkMgr = e.worldChunkMgr;
	    this.isHellWorld = e.isHellWorld;
	    this.hasNoSky = e.hasNoSky;
	    this.dimensionId = e.dimensionId;
        float f = 0.1F;

        for (int i = 0; i <= 15; ++i)
        {
            float f1 = 1.0F - (float)i / 15.0F;
            this.lightBrightnessTable[i] = (1.0F - f1) / (f1 * 3.0F + 1.0F) * (1.0F - f) + f;
        }
	}
	
    public float getCloudHeight()
    {
        return 8.0F;
    }
    
    public double getVoidFogYFactor()
    {
        return 0;
    }
    
    public boolean doesXZShowFog(int par1, int par2)
    {
        return false;
    }
    public boolean getWorldHasVoidParticles()
    {
        return false;
    }

	@Override
	public String getDimensionName() {
		return "SurfaceImp";
	}
}
