package rawdev.core;

import ic2.core.Ic2Items;
import ic2.core.init.InternalName;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;

import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldProviderSurface;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.Property;
import net.minecraftforge.common.Property.Type;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.LoadController;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;

// Referenced classes of package rawdev.core:
//            MoreLava

@Mod(modid="RawDev", name="RawDev", version="0")
@NetworkMod(clientSideRequired=false, serverSideRequired=false)
public class RawDev implements ITickHandler
{
	private void EnsureLastWord() throws Throwable
	{
		//this method allow mod to run LAST no matter what
		//if other mod used similar technique result is undefined
		
		Loader load = Loader.instance();
		
		LoadController lc = (LoadController) UnsafeImp.Read_Object(load, "modController");

		List<ModContainer> mcsA = lc.getActiveModList();
		
		List<ModContainer> lcn = new ArrayList();
		
		ModContainer last = null;
		
		for (ModContainer x : mcsA)
	    {
			if (x.getName().equals("RawDev"))
			{
				last = x;
				continue;
			}
			lcn.add(x);
		}
		lcn.add(last);
		
		UnsafeImp.Write_Object(lc,"activeModList",lcn);
	}
	@Mod.EventHandler
    public void StageA(FMLPreInitializationEvent e) throws Throwable
    {
		EnsureLastWord();
		TickRegistry.registerTickHandler(this, Side.CLIENT);
    }
	
	
	
	@Mod.EventHandler
    public void StageB(FMLPostInitializationEvent e) throws Throwable
    {
		HashMap discover;
		try {
			discover = (HashMap) UnsafeImp.Read_Object(TileEntity.class, "nameToClassMap");
		} catch (Exception e1) {
			discover = (HashMap) UnsafeImp.Read_Object(TileEntity.class, "field_70326_a");
		}
		
		discover.remove("Replicator");
		GameRegistry.registerTileEntity(TileEntityReplicatorImp.class, "Replicator");
		
		Block.blocksList[Ic2Items.replicator.itemID] = null;
		Item.itemsList	[Ic2Items.replicator.itemID] = null;
		
        new BlockMachine2Imp(new ConfigurationImp(new Property("block",Ic2Items.replicator.itemID+"",Type.INTEGER)), InternalName.blockMachine2);
    }
	
	public void tickStart(EnumSet<TickType> type, Object... tickData) {
			Minecraft mc = FMLClientHandler.instance().getClient();
			World worldServer = mc.thePlayer.worldObj;
			WorldProvider oldWorldProvider = worldServer.provider;
			
			if (!oldWorldProvider.getClass().equals(WorldProviderSurface.class))
					return;
			UnsafeImp.ftfl0(worldServer, new WorldProviderSurfaceImp((WorldProviderSurface) oldWorldProvider),"provider","field_73011_w");
			
			worldServer = DimensionManager.getWorld(mc.thePlayer.dimension);
	}
	@Override
	public EnumSet<TickType> ticks() {
		if (FMLClientHandler.instance().getClient()== null)
			return null;
		if (FMLClientHandler.instance().getClient().thePlayer == null)
			return null;
		return EnumSet.of(TickType.CLIENT);
	}
	public String getLabel() {return null;}
	public void tickEnd(EnumSet<TickType> type, Object... tickData) {}
}
