/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.api;

import cpw.mods.fml.common.FMLLog;
import java.lang.reflect.Method;
import java.util.HashMap;
import net.minecraftforge.common.ForgeDirection;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IEssentiaTransport;

public class ThaumcraftApiHelper {
    static Method isResearchComplete;
    static Method getObjectTags;
    static Method getBonusTags;
    static Method generateTags;
    private static HashMap<Integer, AspectList> allAspects;
    private static HashMap<Integer, AspectList> allCompoundAspects;

    public static AspectList cullTags(AspectList temp) {
        AspectList temp2 = new AspectList();
        for (Aspect tag : temp.getAspects()) {
            if (tag == null) continue;
            temp2.add(tag, temp.getAmount(tag));
        }
        while (temp2 != null && temp2.size() > 10) {
            Aspect lowest = null;
            int low = Integer.MAX_VALUE;
            for (Aspect tag : temp2.getAspects()) {
                if (tag == null || temp2.getAmount(tag) >= low) continue;
                low = temp2.getAmount(tag);
                lowest = tag;
            }
            temp2.aspects.remove(lowest);
        }
        return temp2;
    }

    public static boolean areItemsEqual(ye s1, ye s2) {
        if (s1.g() && s2.g()) {
            return s1.d == s2.d;
        }
        return s1.d == s2.d && s1.k() == s2.k();
    }

    public static boolean isResearchComplete(String username, String researchkey) {
        boolean ot = false;
        try {
            if (isResearchComplete == null) {
                Class<?> fake = Class.forName("thaumcraft.common.lib.research.ResearchManager");
                isResearchComplete = fake.getMethod("isResearchComplete", String.class, String.class);
            }
            ot = (Boolean)isResearchComplete.invoke(null, username, researchkey);
        }
        catch (Exception ex) {
            FMLLog.warning((String)"[Thaumcraft API] Could not invoke thaumcraft.common.lib.research.ResearchManager method isResearchComplete", (Object[])new Object[0]);
        }
        return ot;
    }

    public static ye getStackInRowAndColumn(Object instance, int row, int column) {
        ye ot = null;
        try {
            Class<?> fake = Class.forName("thaumcraft.common.tiles.TileMagicWorkbench");
            Method getStackInRowAndColumn = fake.getMethod("getStackInRowAndColumn", Integer.TYPE, Integer.TYPE);
            ot = (ye)getStackInRowAndColumn.invoke(instance, row, column);
        }
        catch (Exception ex) {
            FMLLog.warning((String)"[Thaumcraft API] Could not invoke thaumcraft.common.tiles.TileMagicWorkbench method getStackInRowAndColumn", (Object[])new Object[0]);
        }
        return ot;
    }

    public static AspectList getObjectAspects(ye is) {
        AspectList ot = null;
        try {
            if (getObjectTags == null) {
                Class<?> fake = Class.forName("thaumcraft.common.lib.ThaumcraftCraftingManager");
                getObjectTags = fake.getMethod("getObjectTags", ye.class);
            }
            ot = (AspectList)getObjectTags.invoke(null, is);
        }
        catch (Exception ex) {
            FMLLog.warning((String)"[Thaumcraft API] Could not invoke thaumcraft.common.lib.ThaumcraftCraftingManager method getObjectTags", (Object[])new Object[0]);
        }
        return ot;
    }

    public static AspectList getBonusObjectTags(ye is, AspectList ot) {
        try {
            if (getBonusTags == null) {
                Class<?> fake = Class.forName("thaumcraft.common.lib.ThaumcraftCraftingManager");
                getBonusTags = fake.getMethod("getBonusTags", ye.class, AspectList.class);
            }
            ot = (AspectList)getBonusTags.invoke(null, is, ot);
        }
        catch (Exception ex) {
            FMLLog.warning((String)"[Thaumcraft API] Could not invoke thaumcraft.common.lib.ThaumcraftCraftingManager method getBonusTags", (Object[])new Object[0]);
        }
        return ot;
    }

    public static AspectList generateTags(int id, int meta) {
        try {
            if (generateTags == null) {
                Class<?> fake = Class.forName("thaumcraft.common.lib.ThaumcraftCraftingManager");
                generateTags = fake.getMethod("generateTags", Integer.TYPE, Integer.TYPE);
            }
            return (AspectList)generateTags.invoke(null, id, meta);
        }
        catch (Exception ex) {
            FMLLog.warning((String)"[Thaumcraft API] Could not invoke thaumcraft.common.lib.ThaumcraftCraftingManager method generateTags", (Object[])new Object[0]);
            return null;
        }
    }

    public static boolean containsMatch(boolean strict, ye[] inputs, ye ... targets) {
        for (ye input : inputs) {
            for (ye target : targets) {
                if (!ThaumcraftApiHelper.itemMatches(target, input, strict)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean itemMatches(ye target, ye input, boolean strict) {
        if (input == null && target != null || input != null && target == null) {
            return false;
        }
        return target.d == input.d && (target.k() == Short.MAX_VALUE && !strict || target.k() == input.k());
    }

    public static asp getConnectableTile(abw world, int x, int y, int z, ForgeDirection face) {
        asp te = world.r(x + face.offsetX, y + face.offsetY, z + face.offsetZ);
        if (te instanceof IEssentiaTransport && ((IEssentiaTransport)te).isConnectable(face.getOpposite())) {
            return te;
        }
        return null;
    }

    public static asp getConnectableTile(acf world, int x, int y, int z, ForgeDirection face) {
        asp te = world.r(x + face.offsetX, y + face.offsetY, z + face.offsetZ);
        if (te instanceof IEssentiaTransport && ((IEssentiaTransport)te).isConnectable(face.getOpposite())) {
            return te;
        }
        return null;
    }

    public static AspectList getAllAspects(int amount) {
        if (allAspects.get(amount) == null) {
            AspectList al = new AspectList();
            for (Aspect aspect : Aspect.aspects.values()) {
                al.add(aspect, amount);
            }
            allAspects.put(amount, al);
        }
        return allAspects.get(amount);
    }

    public static AspectList getAllCompoundAspects(int amount) {
        if (allCompoundAspects.get(amount) == null) {
            AspectList al = new AspectList();
            for (Aspect aspect : Aspect.getCompoundAspects()) {
                al.add(aspect, amount);
            }
            allCompoundAspects.put(amount, al);
        }
        return allCompoundAspects.get(amount);
    }

    static {
        allAspects = new HashMap();
        allCompoundAspects = new HashMap();
    }
}

