/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.api.aspects;

import java.io.Serializable;
import java.util.LinkedHashMap;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;

public class AspectList
implements Serializable {
    public LinkedHashMap<Aspect, Integer> aspects = new LinkedHashMap();

    public AspectList(int id, int meta) {
        try {
            AspectList temp = ThaumcraftApiHelper.getObjectAspects(new ye(id, 1, meta));
            if (temp != null) {
                for (Aspect tag : temp.getAspects()) {
                    this.add(tag, temp.getAmount(tag));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public AspectList() {
    }

    public AspectList copy() {
        AspectList out = new AspectList();
        for (Aspect a : this.getAspects()) {
            out.add(a, this.getAmount(a));
        }
        return out;
    }

    public int size() {
        return this.aspects.size();
    }

    public int visSize() {
        int q = 0;
        for (Aspect as : this.aspects.keySet()) {
            q += this.getAmount(as);
        }
        return q;
    }

    public Aspect[] getAspects() {
        Aspect[] q = new Aspect[1];
        return this.aspects.keySet().toArray(q);
    }

    public Aspect[] getPrimalAspects() {
        AspectList t2 = new AspectList();
        for (Aspect as : this.aspects.keySet()) {
            if (!as.isPrimal()) continue;
            t2.add(as, 1);
        }
        Aspect[] q = new Aspect[1];
        return t2.aspects.keySet().toArray(q);
    }

    public Aspect[] getAspectsSorted() {
        Aspect[] out = this.aspects.keySet().toArray(new Aspect[1]);
        boolean change = false;
        block0: do {
            change = false;
            for (int a = 0; a < out.length - 1; ++a) {
                Aspect e1 = out[a];
                Aspect e2 = out[a + 1];
                if (e1 == null || e2 == null || e1.getTag().compareTo(e2.getTag()) <= 0) continue;
                out[a] = e2;
                out[a + 1] = e1;
                change = true;
                continue block0;
            }
        } while (change);
        return out;
    }

    public Aspect[] getAspectsSortedAmount() {
        Aspect[] out = this.aspects.keySet().toArray(new Aspect[1]);
        boolean change = false;
        block0: do {
            change = false;
            for (int a = 0; a < out.length - 1; ++a) {
                Aspect eb;
                int e1 = this.getAmount(out[a]);
                int e2 = this.getAmount(out[a + 1]);
                if (e1 <= 0 || e2 <= 0 || e2 <= e1) continue;
                Aspect ea = out[a];
                out[a] = eb = out[a + 1];
                out[a + 1] = ea;
                change = true;
                continue block0;
            }
        } while (change);
        return out;
    }

    public int getAmount(Aspect key) {
        return this.aspects.get(key) == null ? 0 : this.aspects.get(key);
    }

    public boolean reduce(Aspect key, int amount) {
        if (this.getAmount(key) >= amount) {
            int am = this.getAmount(key) - amount;
            this.aspects.put(key, am);
            return true;
        }
        return false;
    }

    public AspectList remove(Aspect key, int amount) {
        int am = this.getAmount(key) - amount;
        if (am <= 0) {
            this.aspects.remove(key);
        } else {
            this.aspects.put(key, am);
        }
        return this;
    }

    public AspectList remove(Aspect key) {
        this.aspects.remove(key);
        return this;
    }

    public AspectList add(Aspect aspect, int amount) {
        if (this.aspects.containsKey(aspect)) {
            int oldamount = this.aspects.get(aspect);
            amount += oldamount;
        }
        this.aspects.put(aspect, amount);
        return this;
    }

    public AspectList merge(Aspect aspect, int amount) {
        int oldamount;
        if (this.aspects.containsKey(aspect) && amount < (oldamount = this.aspects.get(aspect).intValue())) {
            amount = oldamount;
        }
        this.aspects.put(aspect, amount);
        return this;
    }

    public void readFromNBT(by nbttagcompound) {
        this.aspects.clear();
        cg tlist = nbttagcompound.m("Aspects");
        for (int j = 0; j < tlist.c(); ++j) {
            by rs = (by)tlist.b(j);
            if (!rs.b("key")) continue;
            this.add(Aspect.getAspect(rs.i("key")), rs.e("amount"));
        }
    }

    public void writeToNBT(by nbttagcompound) {
        cg tlist = new cg();
        nbttagcompound.a("Aspects", (cl)tlist);
        for (Aspect aspect : this.getAspects()) {
            if (aspect == null) continue;
            by f = new by();
            f.a("key", aspect.getTag());
            f.a("amount", this.getAmount(aspect));
            tlist.a((cl)f);
        }
    }
}

