/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraftforge.common.EnumHelper;
import net.minecraftforge.oredict.OreDictionary;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.crafting.CrucibleRecipe;
import thaumcraft.api.crafting.InfusionEnchantmentRecipe;
import thaumcraft.api.crafting.InfusionRecipe;
import thaumcraft.api.crafting.ShapedArcaneRecipe;
import thaumcraft.api.crafting.ShapelessArcaneRecipe;
import thaumcraft.api.research.IScanEventHandler;
import thaumcraft.api.research.ResearchCategories;
import thaumcraft.api.research.ResearchCategoryList;
import thaumcraft.api.research.ResearchItem;
import thaumcraft.api.research.ResearchPage;

public class ThaumcraftApi {
    public static yd toolMatThaumium = EnumHelper.addToolMaterial((String)"THAUMIUM", (int)3, (int)400, (float)7.0f, (float)2.0f, (int)22);
    public static yd toolMatElemental = EnumHelper.addToolMaterial((String)"THAUMIUM_ELEMENTAL", (int)3, (int)1500, (float)10.0f, (float)3.0f, (int)18);
    public static wj armorMatThaumium = EnumHelper.addArmorMaterial((String)"THAUMIUM", (int)25, (int[])new int[]{2, 6, 5, 2}, (int)25);
    public static wj armorMatSpecial = EnumHelper.addArmorMaterial((String)"SPECIAL", (int)25, (int[])new int[]{1, 3, 2, 1}, (int)25);
    public static int enchantFrugal;
    public static int enchantPotency;
    public static int enchantWandFortune;
    public static int enchantHaste;
    public static int enchantRepair;
    public static ArrayList<Integer> portableHoleBlackList;
    public static ArrayList<IScanEventHandler> scanEventhandlers;
    public static ArrayList<EntityTags> scanEntities;
    private static ArrayList craftingRecipes;
    private static HashMap<List, ye> smeltingBonus;
    private static ArrayList<List> smeltingBonusExlusion;
    private static HashMap<int[], Object[]> keyCache;
    public static ConcurrentHashMap<List, AspectList> objectTags;

    public static void registerScanEventhandler(IScanEventHandler scanEventHandler) {
        scanEventhandlers.add(scanEventHandler);
    }

    public static void registerEntityTag(String entityName, AspectList aspects, cl ... nbt) {
        scanEntities.add(new EntityTags(entityName, nbt, aspects));
    }

    public static void addSmeltingBonus(ye in, ye out) {
        smeltingBonus.put(Arrays.asList(in.d, in.k()), new ye(out.d, 0, out.k()));
    }

    public static ye getSmeltingBonus(ye in) {
        return smeltingBonus.get(Arrays.asList(in.d, in.k()));
    }

    public static void addSmeltingBonusExclusion(ye in) {
        smeltingBonusExlusion.add(Arrays.asList(in.d, in.k()));
    }

    public static boolean isSmeltingBonusExluded(ye in) {
        return smeltingBonusExlusion.contains(Arrays.asList(in.d, in.k()));
    }

    public static List getCraftingRecipes() {
        return craftingRecipes;
    }

    public static ShapedArcaneRecipe addArcaneCraftingRecipe(String research, ye result, AspectList aspects, Object ... recipe) {
        ShapedArcaneRecipe r = new ShapedArcaneRecipe(research, result, aspects, recipe);
        craftingRecipes.add(r);
        return r;
    }

    public static ShapelessArcaneRecipe addShapelessArcaneCraftingRecipe(String research, ye result, AspectList aspects, Object ... recipe) {
        ShapelessArcaneRecipe r = new ShapelessArcaneRecipe(research, result, aspects, recipe);
        craftingRecipes.add(r);
        return r;
    }

    public static InfusionRecipe addInfusionCraftingRecipe(String research, Object result, int instability, AspectList aspects, ye input, ye[] recipe) {
        if (!(result instanceof ye) && !(result instanceof cl)) {
            return null;
        }
        InfusionRecipe r = new InfusionRecipe(research, result, instability, aspects, input, recipe);
        craftingRecipes.add(r);
        return r;
    }

    public static InfusionEnchantmentRecipe addInfusionEnchantmentRecipe(String research, aau enchantment, int instability, AspectList aspects, ye[] recipe) {
        InfusionEnchantmentRecipe r = new InfusionEnchantmentRecipe(research, enchantment, instability, aspects, recipe);
        craftingRecipes.add(r);
        return r;
    }

    public static InfusionRecipe getInfusionRecipe(ye res) {
        for (Object r : ThaumcraftApi.getCraftingRecipes()) {
            if (!(r instanceof InfusionRecipe) || !(((InfusionRecipe)r).recipeOutput instanceof ye) || !((ye)((InfusionRecipe)r).recipeOutput).a(res)) continue;
            return (InfusionRecipe)r;
        }
        return null;
    }

    public static CrucibleRecipe addCrucibleRecipe(String key, ye result, Object catalyst, AspectList tags) {
        CrucibleRecipe rc = new CrucibleRecipe(key, result, catalyst, tags);
        ThaumcraftApi.getCraftingRecipes().add(rc);
        return rc;
    }

    public static CrucibleRecipe getCrucibleRecipe(ye stack) {
        for (Object r : ThaumcraftApi.getCraftingRecipes()) {
            if (!(r instanceof CrucibleRecipe) || !((CrucibleRecipe)r).recipeOutput.a(stack)) continue;
            return (CrucibleRecipe)r;
        }
        return null;
    }

    public static Object[] getCraftingRecipeKey(uf player, ye stack) {
        int[] key = new int[]{stack.d, stack.k()};
        if (keyCache.containsKey(key)) {
            if (keyCache.get(key) == null) {
                return null;
            }
            if (ThaumcraftApiHelper.isResearchComplete(player.bu, (String)keyCache.get(key)[0])) {
                return keyCache.get(key);
            }
            return null;
        }
        for (ResearchCategoryList rcl : ResearchCategories.researchCategories.values()) {
            for (ResearchItem ri : rcl.research.values()) {
                if (ri.getPages() == null) continue;
                for (int a = 0; a < ri.getPages().length; ++a) {
                    ResearchPage page = ri.getPages()[a];
                    if (page.recipeOutput == null || stack == null || !page.recipeOutput.a(stack)) continue;
                    keyCache.put(key, new Object[]{ri.key, a});
                    if (ThaumcraftApiHelper.isResearchComplete(player.bu, ri.key)) {
                        return new Object[]{ri.key, a};
                    }
                    return null;
                }
            }
        }
        keyCache.put(key, null);
        return null;
    }

    public static boolean exists(int id, int meta) {
        AspectList tmp = objectTags.get(Arrays.asList(id, meta));
        if (tmp == null) {
            tmp = objectTags.get(Arrays.asList(id, -1));
            if (meta == -1 && tmp == null) {
                int index = 0;
                do {
                    tmp = objectTags.get(Arrays.asList(id, index));
                } while (++index < 16 && tmp == null);
            }
            if (tmp == null) {
                return false;
            }
        }
        return true;
    }

    public static void registerObjectTag(int id, int meta, AspectList aspects) {
        if (aspects == null) {
            aspects = new AspectList();
        }
        objectTags.put(Arrays.asList(id, meta), aspects);
    }

    public static void registerObjectTag(int id, int[] meta, AspectList aspects) {
        if (aspects == null) {
            aspects = new AspectList();
        }
        objectTags.put(Arrays.asList(id, meta), aspects);
    }

    public static void registerObjectTag(String oreDict, AspectList aspects) {
        ArrayList ores;
        if (aspects == null) {
            aspects = new AspectList();
        }
        if ((ores = OreDictionary.getOres((String)oreDict)) != null && ores.size() > 0) {
            for (ye ore : ores) {
                int d = ore.k();
                if (d == Short.MAX_VALUE) {
                    d = -1;
                }
                objectTags.put(Arrays.asList(ore.d, d), aspects);
            }
        }
    }

    public static void registerComplexObjectTag(int id, int meta, AspectList aspects) {
        if (!ThaumcraftApi.exists(id, meta)) {
            AspectList tmp = ThaumcraftApiHelper.generateTags(id, meta);
            if (tmp != null && tmp.size() > 0) {
                for (Aspect tag : tmp.getAspects()) {
                    aspects.add(tag, tmp.getAmount(tag));
                }
            }
            ThaumcraftApi.registerObjectTag(id, meta, aspects);
        } else {
            AspectList tmp = ThaumcraftApiHelper.getObjectAspects(new ye(id, 1, meta));
            for (Aspect tag : aspects.getAspects()) {
                tmp.merge(tag, tmp.getAmount(tag));
            }
            ThaumcraftApi.registerObjectTag(id, meta, tmp);
        }
    }

    static {
        portableHoleBlackList = new ArrayList();
        scanEventhandlers = new ArrayList();
        scanEntities = new ArrayList();
        craftingRecipes = new ArrayList();
        smeltingBonus = new HashMap();
        smeltingBonusExlusion = new ArrayList();
        keyCache = new HashMap();
        objectTags = new ConcurrentHashMap();
    }

    public static class EntityTags {
        public String entityName;
        public cl[] nbts;
        public AspectList aspects;

        public EntityTags(String entityName, cl[] nbts, AspectList aspects) {
            this.entityName = entityName;
            this.nbts = nbts;
            this.aspects = aspects;
        }
    }
}

