/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.api.crafting;

import java.util.ArrayList;
import java.util.HashMap;
import net.minecraftforge.oredict.OreDictionary;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.crafting.IArcaneRecipe;

public class ShapedArcaneRecipe
implements IArcaneRecipe {
    private static final int MAX_CRAFT_GRID_WIDTH = 3;
    private static final int MAX_CRAFT_GRID_HEIGHT = 3;
    public ye output = null;
    public Object[] input = null;
    public AspectList aspects = null;
    public String research;
    public int width = 0;
    public int height = 0;
    private boolean mirrored = true;

    public ShapedArcaneRecipe(String research, aqz result, AspectList aspects, Object ... recipe) {
        this(research, new ye(result), aspects, recipe);
    }

    public ShapedArcaneRecipe(String research, yc result, AspectList aspects, Object ... recipe) {
        this(research, new ye(result), aspects, recipe);
    }

    public ShapedArcaneRecipe(String research, ye result, AspectList aspects, Object ... recipe) {
        this.output = result.m();
        this.research = research;
        this.aspects = aspects;
        String shape = "";
        int idx = 0;
        if (recipe[idx] instanceof Boolean) {
            this.mirrored = (Boolean)recipe[idx];
            if (recipe[idx + 1] instanceof Object[]) {
                recipe = (Object[])recipe[idx + 1];
            } else {
                idx = 1;
            }
        }
        if (recipe[idx] instanceof String[]) {
            String[] parts = (String[])recipe[idx++];
            for (String s : parts) {
                this.width = s.length();
                shape = shape + (String)s;
            }
            this.height = parts.length;
        } else {
            while (recipe[idx] instanceof String) {
                String s = (String)recipe[idx++];
                shape = shape + s;
                this.width = s.length();
                ++this.height;
            }
        }
        if (this.width * this.height != shape.length()) {
            String ret = "Invalid shaped ore recipe: ";
            for (Object tmp : recipe) {
                ret = ret + tmp + ", ";
            }
            ret = ret + this.output;
            throw new RuntimeException(ret);
        }
        HashMap<Character, Object> itemMap = new HashMap<Character, Object>();
        while (idx < recipe.length) {
            Character chr = (Character)recipe[idx];
            Object in = recipe[idx + 1];
            if (in instanceof ye) {
                itemMap.put(chr, ((ye)in).m());
            } else if (in instanceof yc) {
                itemMap.put(chr, new ye((yc)in));
            } else if (in instanceof aqz) {
                itemMap.put(chr, new ye((aqz)in, 1, Short.MAX_VALUE));
            } else if (in instanceof String) {
                itemMap.put(chr, OreDictionary.getOres((String)((String)in)));
            } else {
                String ret = "Invalid shaped ore recipe: ";
                for (Object tmp : recipe) {
                    ret = ret + tmp + ", ";
                }
                ret = ret + this.output;
                throw new RuntimeException(ret);
            }
            idx += 2;
        }
        this.input = new Object[this.width * this.height];
        int x = 0;
        for (char chr : shape.toCharArray()) {
            this.input[x++] = itemMap.get(Character.valueOf(chr));
        }
    }

    @Override
    public ye getCraftingResult(mo var1) {
        return this.output.m();
    }

    @Override
    public int getRecipeSize() {
        return this.input.length;
    }

    @Override
    public ye getRecipeOutput() {
        return this.output;
    }

    @Override
    public boolean matches(mo inv, abw world, uf player) {
        if (this.research.length() > 0 && !ThaumcraftApiHelper.isResearchComplete(player.bu, this.research)) {
            return false;
        }
        for (int x = 0; x <= 3 - this.width; ++x) {
            for (int y = 0; y <= 3 - this.height; ++y) {
                if (this.checkMatch(inv, x, y, false)) {
                    return true;
                }
                if (!this.mirrored || !this.checkMatch(inv, x, y, true)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkMatch(mo inv, int startX, int startY, boolean mirror) {
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                int subX = x - startX;
                int subY = y - startY;
                Object target = null;
                if (subX >= 0 && subY >= 0 && subX < this.width && subY < this.height) {
                    target = mirror ? this.input[this.width - subX - 1 + subY * this.width] : this.input[subX + subY * this.width];
                }
                ye slot = ThaumcraftApiHelper.getStackInRowAndColumn(inv, x, y);
                if (target instanceof ye) {
                    if (this.checkItemEquals((ye)target, slot)) continue;
                    return false;
                }
                if (target instanceof ArrayList) {
                    boolean matched = false;
                    for (ye item : (ArrayList)target) {
                        matched = matched || this.checkItemEquals(item, slot);
                    }
                    if (matched) continue;
                    return false;
                }
                if (target != null || slot == null) continue;
                return false;
            }
        }
        return true;
    }

    private boolean checkItemEquals(ye target, ye input) {
        if (input == null && target != null || input != null && target == null) {
            return false;
        }
        return !(target.d != input.d || target.p() && !ye.a((ye)target, (ye)input) || target.k() != Short.MAX_VALUE && target.k() != input.k());
    }

    public ShapedArcaneRecipe setMirrored(boolean mirror) {
        this.mirrored = mirror;
        return this;
    }

    public Object[] getInput() {
        return this.input;
    }

    @Override
    public AspectList getAspects() {
        return this.aspects;
    }

    @Override
    public String getResearch() {
        return this.research;
    }
}

