/*
 * Decompiled with CFR 0.152.
 */
package ic2.api.energy.prefab;

import cpw.mods.fml.common.FMLCommonHandler;
import ic2.api.energy.EnergyNet;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.info.Info;
import ic2.api.item.ElectricItem;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;

public class BasicSink
extends asp
implements IEnergySink {
    public final asp parent;
    protected int capacity;
    protected int tier;
    protected double energyStored;
    protected boolean addedToEnet;

    public BasicSink(asp parent, int capacity, int tier) {
        this.parent = parent;
        this.capacity = capacity;
        this.tier = tier;
    }

    public void h() {
        if (!this.addedToEnet) {
            this.onLoaded();
        }
    }

    public void onLoaded() {
        if (!this.addedToEnet && !FMLCommonHandler.instance().getEffectiveSide().isClient() && Info.isIc2Available()) {
            this.k = this.parent.k;
            this.l = this.parent.l;
            this.m = this.parent.m;
            this.n = this.parent.n;
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.addedToEnet = true;
        }
    }

    public void w_() {
        super.w_();
        this.onChunkUnload();
    }

    public void onChunkUnload() {
        if (this.addedToEnet && Info.isIc2Available()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.addedToEnet = false;
        }
    }

    public void a(by tag) {
        super.a(tag);
        by data = tag.l("IC2BasicSink");
        this.energyStored = data.h("energy");
    }

    public void b(by tag) {
        try {
            super.b(tag);
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        by data = new by();
        data.a("energy", this.energyStored);
        tag.a("IC2BasicSink", (cl)data);
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    public int getTier() {
        return this.tier;
    }

    public void setTier(int tier) {
        this.tier = tier;
    }

    public double getEnergyStored() {
        return this.energyStored;
    }

    public void setEnergyStored(double amount) {
        this.energyStored = amount;
    }

    public boolean canUseEnergy(double amount) {
        return this.energyStored >= amount;
    }

    public boolean useEnergy(double amount) {
        if (this.canUseEnergy(amount) && !FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            this.energyStored -= amount;
            return true;
        }
        return false;
    }

    public boolean discharge(ye stack, int limit) {
        if (stack == null || !Info.isIc2Available()) {
            return false;
        }
        int amount = (int)Math.floor((double)this.capacity - this.energyStored);
        if (amount <= 0) {
            return false;
        }
        if (limit > 0 && limit < amount) {
            amount = limit;
        }
        amount = ElectricItem.manager.discharge(stack, amount, this.tier, limit > 0, false);
        this.energyStored += (double)amount;
        return amount > 0;
    }

    @Deprecated
    public void onUpdateEntity() {
        this.h();
    }

    @Deprecated
    public void onInvalidate() {
        this.w_();
    }

    @Deprecated
    public void onOnChunkUnload() {
        this.onChunkUnload();
    }

    @Deprecated
    public void onReadFromNbt(by tag) {
        this.a(tag);
    }

    @Deprecated
    public void onWriteToNbt(by tag) {
        this.b(tag);
    }

    @Override
    public boolean acceptsEnergyFrom(asp emitter, ForgeDirection direction) {
        return true;
    }

    @Override
    public double demandedEnergyUnits() {
        return Math.max(0.0, (double)this.capacity - this.energyStored);
    }

    @Override
    public double injectEnergyUnits(ForgeDirection directionFrom, double amount) {
        this.energyStored += amount;
        return 0.0;
    }

    @Override
    public int getMaxSafeInput() {
        return EnergyNet.instance.getPowerFromTier(this.tier);
    }
}

