/*
 * Decompiled with CFR 0.152.
 */
package ic2.api.energy.prefab;

import cpw.mods.fml.common.FMLCommonHandler;
import ic2.api.energy.EnergyNet;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.info.Info;
import ic2.api.item.ElectricItem;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;

public class BasicSource
extends asp
implements IEnergySource {
    public final asp parent;
    protected int capacity;
    protected int tier;
    protected double energyStored;
    protected boolean addedToEnet;

    public BasicSource(asp parent, int capacity, int tier) {
        int power = EnergyNet.instance.getPowerFromTier(tier);
        this.parent = parent;
        this.capacity = capacity < power ? power : capacity;
        this.tier = tier;
    }

    public void h() {
        if (!this.addedToEnet) {
            this.onLoaded();
        }
    }

    public void onLoaded() {
        if (!this.addedToEnet && !FMLCommonHandler.instance().getEffectiveSide().isClient() && Info.isIc2Available()) {
            this.k = this.parent.k;
            this.l = this.parent.l;
            this.m = this.parent.m;
            this.n = this.parent.n;
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.addedToEnet = true;
        }
    }

    public void w_() {
        super.w_();
        this.onChunkUnload();
    }

    public void onChunkUnload() {
        if (this.addedToEnet && Info.isIc2Available()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.addedToEnet = false;
        }
    }

    public void a(by tag) {
        super.a(tag);
        by data = tag.l("IC2BasicSource");
        this.energyStored = data.h("energy");
    }

    public void b(by tag) {
        try {
            super.b(tag);
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        by data = new by();
        data.a("energy", this.energyStored);
        tag.a("IC2BasicSource", (cl)data);
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void setCapacity(int capacity) {
        int power = EnergyNet.instance.getPowerFromTier(this.tier);
        if (capacity < power) {
            capacity = power;
        }
        this.capacity = capacity;
    }

    public int getTier() {
        return this.tier;
    }

    public void setTier(int tier) {
        int power = EnergyNet.instance.getPowerFromTier(tier);
        if (this.capacity < power) {
            this.capacity = power;
        }
        this.tier = tier;
    }

    public double getEnergyStored() {
        return this.energyStored;
    }

    public void setEnergyStored(double amount) {
        this.energyStored = amount;
    }

    public double getFreeCapacity() {
        return (double)this.capacity - this.energyStored;
    }

    public double addEnergy(double amount) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return 0.0;
        }
        if (amount > (double)this.capacity - this.energyStored) {
            amount = (double)this.capacity - this.energyStored;
        }
        this.energyStored += amount;
        return amount;
    }

    public boolean charge(ye stack) {
        if (stack == null || !Info.isIc2Available()) {
            return false;
        }
        int amount = ElectricItem.manager.charge(stack, (int)this.energyStored, this.tier, false, false);
        this.energyStored -= (double)amount;
        return amount > 0;
    }

    @Deprecated
    public void onUpdateEntity() {
        this.h();
    }

    @Deprecated
    public void onInvalidate() {
        this.w_();
    }

    @Deprecated
    public void onOnChunkUnload() {
        this.onChunkUnload();
    }

    @Deprecated
    public void onReadFromNbt(by tag) {
        this.a(tag);
    }

    @Deprecated
    public void onWriteToNbt(by tag) {
        this.b(tag);
    }

    @Override
    public boolean emitsEnergyTo(asp receiver, ForgeDirection direction) {
        return true;
    }

    @Override
    public double getOfferedEnergy() {
        int power = EnergyNet.instance.getPowerFromTier(this.tier);
        if (this.energyStored >= (double)power) {
            return power;
        }
        return 0.0;
    }

    @Override
    public void drawEnergy(double amount) {
        this.energyStored -= amount;
    }
}

