package mods.NetworkAnchor;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import cpw.mods.fml.common.network.IPacketHandler;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;

public class PacketHandler implements IPacketHandler
{
    public static final String configChannel = "IC2NA|CFG";
    public static final String buttonChannel = "IC2NA|BTN";

    @Override
    public void onPacketData(INetworkManager manager, Packet250CustomPayload packet, Player player)
    {
        if (configChannel.equals(packet.channel))
        {
            handleConfig(packet);
        }
        else if (buttonChannel.equals(packet.channel))
        {
            handleButton(packet);
        }
    }

    // break integer into four bytes and write them to byte stream
    /*public static void writeInt(ByteArrayOutputStream bs, int value)
    {
        for (int i = 0; i < 4; i++)
        {
            bs.write(value & 0xFF);
            value >>= 8;
        }
    }

    // assemble integer from four bytes from byte stream
    public static int readInt(ByteArrayInputStream bs) throws IOException
    {
        int value = 0;
        for (int i = 0; i < 4; i++)
        {
            if (bs.available() == 0) throw new IOException("Cannot read int from input stream - not enough bytes.");
            value |= bs.read() << (8*i);
        }
        return value;
    }*/

    // Parse config packet
    public static void handleConfig(Packet250CustomPayload packet)
    {
        try
        {
            ByteArrayInputStream bs = new ByteArrayInputStream(packet.data);
            ObjectInputStream os = new ObjectInputStream(bs);
            NetworkAnchor.instance.clientRules = (RealmRules) os.readObject();
            NetworkAnchor.instance.updateWrenchRequirement();
            NetworkAnchor.instance.updateRecipe();
        }
        catch (Throwable e)
        {
            e.printStackTrace();
        }
    }

    public static void sendConfig(INetworkManager manager)
    {
        try
        {
            ByteArrayOutputStream bs = new ByteArrayOutputStream();
            ObjectOutputStream os = new ObjectOutputStream(bs);
            os.writeObject(NetworkAnchor.instance.serverRules);
            manager.addToSendQueue(new Packet250CustomPayload(configChannel, bs.toByteArray()));
        }
        catch (Throwable e)
        {
            e.printStackTrace();
        }
    }

    // Parse button packet
    public static void handleButton(Packet250CustomPayload packet)
    {
        try
        {
            ByteArrayInputStream bs = new ByteArrayInputStream(packet.data);
            DataInputStream ds = new DataInputStream(bs);
            int d = ds.readInt(); // parse byte stream before doing anything
            int x = ds.readInt();
            int y = ds.readInt();
            int z = ds.readInt();
            int b = ds.readInt();

            if (DimensionManager.isDimensionRegistered(d))
            {
                World w = DimensionManager.getWorld(d);
                if (w == null)
                {
                    DimensionManager.initDimension(d);
                    w = DimensionManager.getWorld(d);
                }

                TileEntity tile = w.getBlockTileEntity(x, y, z);
                if (tile != null && !tile.isInvalid() && tile instanceof TileEntityNetworkAnchor)
                {
                    ((TileEntityNetworkAnchor) tile).buttonHandler(b);
                }
            }
        }
        catch (Throwable e)
        {
            e.printStackTrace();
        }
    }

    public static void sendButtonClick(TileEntityNetworkAnchor tile, int buttonID)
    {
        try
        {
            ByteArrayOutputStream bs = new ByteArrayOutputStream();
            DataOutputStream ds = new DataOutputStream(bs);
            ds.writeInt(tile.worldObj.provider.dimensionId);
            ds.writeInt(tile.xCoord);
            ds.writeInt(tile.yCoord);
            ds.writeInt(tile.zCoord);
            ds.writeInt(buttonID);
            ds.flush();
            ds.close();
            Packet250CustomPayload packet = new Packet250CustomPayload(buttonChannel, bs.toByteArray());
            PacketDispatcher.sendPacketToServer(packet);
            // also directly call routine on client side
            tile.buttonHandler(buttonID);
        }
        catch (Throwable e)
        {
            e.printStackTrace();
        }
    }
}
