package mods.NetworkAnchor;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import cpw.mods.fml.common.network.IGuiHandler;

public class GuiHandler implements IGuiHandler
{
    @Override
    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z)
    {
        if (!world.blockExists(x, y, z)) return null;
        TileEntity tile = world.getBlockTileEntity(x, y, z);
        if (tile instanceof TileEntityNetworkAnchor == false) return null;
        if (ID != 0) return null;
        return new ContainerNetworkAnchor(player.inventory, (TileEntityNetworkAnchor) tile);
    }

    @Override
    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z)
    {
        if (!world.blockExists(x, y, z)) return null;
        TileEntity tile = world.getBlockTileEntity(x, y, z);
        if (tile instanceof TileEntityNetworkAnchor == false) return null;
        if (ID != 0) return null;
        return new GuiNetworkAnchor(player.inventory, (TileEntityNetworkAnchor) tile);
    }
}
