package mods.NetworkAnchor;

import net.minecraft.block.Block;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;

public class ItemNetworkAnchor extends ItemBlock
{
    protected Block block;

    public ItemNetworkAnchor(int id, Block block)
    {
        super(id);
        setMaxDamage(0);
        setHasSubtypes(true);
        this.block = block;
    }

    @Override
    public String getUnlocalizedName(ItemStack stack)
    {
        switch (stack.getItemDamage())
        {
            case 0: return "tile.networkAnchor";
            case 1: return "tile.scanTerminator";
            default: return super.getUnlocalizedName(stack);
        }
    }

    @Override
    public Icon getIconFromDamage(int metadata)
    {
        return block.getIcon(2, metadata);
    }

    @Override
    public int getMetadata(int metadata)
    {
        return metadata;
    }
}
