package mods.NetworkAnchor;

import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;

public class TheRecipe implements IRecipe
{
    public IRecipe easy, hard;

    public TheRecipe(IRecipe easy, IRecipe hard)
    {
        this.easy = easy;
        this.hard = hard;
    }

    public IRecipe recipe()
    {
        return NetworkAnchor.instance.clientRules.hardGregTechRecipe && hard != null ? hard : easy;
    }

    @Override
    public boolean matches(InventoryCrafting inventorycrafting, World world)
    {
        return recipe().matches(inventorycrafting, world);
    }

    @Override
    public ItemStack getCraftingResult(InventoryCrafting inventorycrafting)
    {
        return recipe().getCraftingResult(inventorycrafting);
    }

    @Override
    public int getRecipeSize()
    {
        return recipe().getRecipeSize();
    }

    @Override
    public ItemStack getRecipeOutput()
    {
        return recipe().getRecipeOutput();
    }
}
