package mods.NetworkAnchor;

import ic2.api.item.Items;
import ic2.api.recipe.Recipes;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.logging.Logger;

import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.ShapedOreRecipe;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.Mod.EventHandler;
import cpw.mods.fml.common.Mod.Instance;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;

@Mod(
        modid = NetworkAnchor.modid,
        name = NetworkAnchor.modid,
        version = "0.10.3e",
        dependencies = "required-after:IC2; after:GregTech_Addon; after:IC2CA; after:Railcraft"
        )

@NetworkMod(
        clientSideRequired = true,
        serverSideRequired = true,
        channels = {PacketHandler.configChannel, PacketHandler.buttonChannel},
        packetHandler = PacketHandler.class,
        connectionHandler = ConnectionHandler.class
        )

public class NetworkAnchor
{
    public static final String modid = "NetworkAnchor";
    public static final String iconPrefix = modid + ":";

    // The instance of mod that Forge uses.
    @Instance("NetworkAnchor")
    public static NetworkAnchor instance;

    // Logger
    public static final Logger logger = Logger.getLogger(modid);

    // Realm rules. Will be passed from server to client.
    public RealmRules serverRules = new RealmRules(); // source copy of config for a side
    public RealmRules clientRules = new RealmRules(); // working copy for client or source config for server

    // Server side only config.
    public int blockID = 777; // id's checked by forge on connection
    public double energyBase = 0; // energy consumption variables.
    public double energyPerTile = 0; // -//-
    public double energyPerChunk = 4; // -//-
    public int hardLimit = 0; // 0 = disabled/infinity
    public double scanRateBase = 0;
    public double scanRateA = 100;
    public double scanRateB = 1.3;

    // Blocks
    public BlockNetworkAnchor blockNetworkAnchor;

    // Recipes
    public ShapedOreRecipe easy = null, hard = null, theRecipe = null;

    @EventHandler
    public void preInit(FMLPreInitializationEvent event)
    {
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        try
        {
            config.load();

            blockID = config.getBlock(modid, "BlockID", blockID).getInt(blockID);

            serverRules.hardGregTechRecipe = config.get(modid, "HardGregTechRecipe", serverRules.hardGregTechRecipe).getBoolean(serverRules.hardGregTechRecipe);
            clientRules.hardGregTechRecipe = serverRules.hardGregTechRecipe; // copy to client

            energyBase = config.get(modid, "EnergyBase", energyBase).getDouble(energyBase);
            if (energyBase < 0) energyBase = 0; // sentinel

            energyPerTile = config.get(modid, "EnergyPerTile", energyPerTile).getDouble(energyPerTile);
            if (energyPerTile < 0) energyPerTile = 0; // sentinel

            energyPerChunk = config.get(modid, "EnergyPerChunk", energyPerChunk).getDouble(energyPerChunk);
            if (energyPerChunk < 0) energyPerChunk = 0; // sentinel

            // Update helper variable
            serverRules.bEnergy = energyBase != 0 || energyPerTile != 0 || energyPerChunk != 0;
            clientRules.bEnergy = serverRules.bEnergy; // copy to client

            hardLimit = config.get(modid, "ScanRateHardLimit", hardLimit).getInt(hardLimit);
            if (hardLimit < 0) hardLimit = 0; // sentinel

            serverRules.wrenchRequired = config.get(modid, "WrenchRequired", serverRules.wrenchRequired).getBoolean(serverRules.wrenchRequired);
            clientRules.wrenchRequired = serverRules.wrenchRequired; // copy to client

            serverRules.wrenchChance = (float) config.get(modid, "WrenchChance", serverRules.wrenchChance).getDouble(serverRules.wrenchChance);
            if (serverRules.wrenchChance < 0.0F) serverRules.wrenchChance = 0.0F; // sentinel
            if (serverRules.wrenchChance > 1.0F) serverRules.wrenchChance = 1.0F; // sentinel
            clientRules.wrenchChance = serverRules.wrenchChance; // copy to client

            scanRateBase = config.get(modid, "ScanRateBase", scanRateBase).getDouble(scanRateBase);
            if (scanRateBase < 0) scanRateBase = 0;

            scanRateA = config.get(modid, "ScanRateA", scanRateA).getDouble(scanRateA);
            if (scanRateA < 0) scanRateA = 0;

            scanRateB = config.get(modid, "ScanRateB", scanRateB).getDouble(scanRateB);
            if (scanRateB < 1) scanRateB = 1;
        }
        finally
        {
            if (config.hasChanged()) config.save();
        }
    }

    public void updateWrenchRequirement()
    {
        if (clientRules.wrenchRequired)
            MinecraftForge.removeBlockEffectiveness(blockNetworkAnchor, 0, "pickaxe");
        else
            MinecraftForge.setBlockHarvestLevel(blockNetworkAnchor, 0, "pickaxe", 0);
    }

    public void updateRecipe()
    {
        if (hard == null) return;
        ShapedOreRecipe copyFrom = clientRules.hardGregTechRecipe ? hard : easy;
        Field fields[] = ShapedOreRecipe.class.getDeclaredFields();
        for (Field f : fields)
        {
            try
            {
                if ( !Modifier.isStatic(f.getModifiers()) )
                {
                    f.setAccessible(true);
                    f.set(theRecipe, f.get(copyFrom));
                }
            }
            catch (IllegalArgumentException e)
            {
                e.printStackTrace();
            }
            catch (IllegalAccessException e)
            {
                e.printStackTrace();
            }
        }
    }

    @EventHandler
    public void load(FMLInitializationEvent event)
    {
        // Create NetworkAnchor block
        blockNetworkAnchor = new BlockNetworkAnchor(blockID, new Material(MapColor.ironColor));
        blockNetworkAnchor.setUnlocalizedName("networkAnchor");
        blockNetworkAnchor.setStepSound(Block.soundMetalFootstep);
        blockNetworkAnchor.setHardness(2.0F);

        updateWrenchRequirement();
        MinecraftForge.setBlockHarvestLevel(blockNetworkAnchor, 1, "pickaxe", 0); // scan terminator not require wrenching

        if (event.getSide().isClient()) blockNetworkAnchor.setCreativeTab(Items.getItem("machine").getItem().getCreativeTab());
        GameRegistry.registerBlock(blockNetworkAnchor, ItemNetworkAnchor.class, "networkAnchor");

        // Register custom stacks
        GameRegistry.registerCustomItemStack("networkAnchor", blockNetworkAnchor.stackNetworkAnchor1);
        GameRegistry.registerCustomItemStack("scanTerminator", blockNetworkAnchor.stackScanTerminator1);

        // Register tile entities
        GameRegistry.registerTileEntity(TileEntityNetworkAnchor.class, "TileEntityNetworkAnchor");
        GameRegistry.registerTileEntity(TileEntityScanTerminator.class, "TileEntityScanTerminator");

        // Register GUI handler
        NetworkRegistry.instance().registerGuiHandler(instance, new GuiHandler());

        // Register chunk loading callback
        ForgeChunkManager.setForcedChunkLoadingCallback(instance, new ChunkloadCallback());
    }

    @EventHandler
    public void postInit(FMLPostInitializationEvent event)
    {
        if (event.getSide().isClient())
        {
            //IRecipe hard = null, easy = null;

            // Try to make hard recipe if there is GregTech available
            if (isGregTechAvailable())
            {
                ItemStack D = getGregTechItem(3, 1, 4); // display
                ItemStack O = getGregTechItem(43, 1, 0); // dataOrb
                ItemStack M = getGregTechBlock(0, 1, 10); // highlyAdvancedMachineBlock

                if (D != null && O != null && M != null)
                {
                    hard = new ShapedOreRecipe(blockNetworkAnchor.stackNetworkAnchor1,
                                               "IDI", "MOM", "TFT",
                                               'I', Items.getItem("iridiumPlate"),
                                               'D', D,
                                               'M', M,
                                               'O', O,
                                               'T', Items.getItem("hvTransformer"),
                                               'F', Items.getItem("glassFiberCableItem")
                                               );

                    if (clientRules.hardGregTechRecipe)
                    {
                        theRecipe = new ShapedOreRecipe(blockNetworkAnchor.stackNetworkAnchor1,
                                                        "IDI", "MOM", "TFT",
                                                        'I', Items.getItem("iridiumPlate"),
                                                        'D', D,
                                                        'M', M,
                                                        'O', O,
                                                        'T', Items.getItem("hvTransformer"),
                                                        'F', Items.getItem("glassFiberCableItem")
                                                        );
                    }
                }
            }

            // Make easy recipe
            ItemStack A = Items.getItem("electronicCircuit");
            ItemStack B = Items.getItem("machine");
            easy = new ShapedOreRecipe(blockNetworkAnchor.stackNetworkAnchor1,
                                       "A", "B", "C",
                                       'A', A,
                                       'B', B,
                                       'C', Items.getItem("insulatedCopperCableItem")
                                       );

            if (theRecipe == null)
            {
                theRecipe = new ShapedOreRecipe(blockNetworkAnchor.stackNetworkAnchor1,
                                                "A", "B", "C",
                                                'A', A,
                                                'B', B,
                                                'C', Items.getItem("insulatedCopperCableItem")
                                                );
            }

            // Add the recipe
            GameRegistry.addRecipe(theRecipe);

            // Scan Terminator (doesn't depend on recipe hardness)
            Recipes.advRecipes.addRecipe(
                    blockNetworkAnchor.stackScanTerminator1,
                    new Object[] {
                        " A ", " B ", " C ",
                        'A', A,
                        'B', B,
                        'C', Items.getItem("insulatedIronCableItem")
                        });
        }

        // Import upgrade modules

        // Classic IC2

        UpgradeDictionary.put(Items.getItem("overclockerUpgrade"), UpgradeDictionary.SPEED, 1, 1);
        UpgradeDictionary.put(Items.getItem("transformerUpgrade"), UpgradeDictionary.TIER, 1, 1);
        UpgradeDictionary.put(Items.getItem("energyStorageUpgrade"), UpgradeDictionary.STORAGE, 10000, 1);

        // GregTech

        if (isGregTechAvailable())
        {
            UpgradeDictionary.put(getGregTechItem(3, 1, 12), UpgradeDictionary.STORAGE, 1000000, 2); // Energy Crystal Storage Upgrade
            UpgradeDictionary.put(getGregTechItem(3, 1, 13), UpgradeDictionary.STORAGE, 10000000, 3); // Lapotron Crystal Storage Upgrade
            UpgradeDictionary.put(getGregTechItem(3, 1, 14), UpgradeDictionary.STORAGE, 100000000, 4); // Energy Orb Storage Upgrade
            UpgradeDictionary.put(getGregTechItem(3, 1, 26), UpgradeDictionary.STORAGE, 100000, 1); // Lithium Storage Upgrade
            UpgradeDictionary.put(getGregTechItem(3, 1, 27), UpgradeDictionary.TIER, 3, 1); // HV Transformer Upgrade
        }

        // ComboArmors

        UpgradeDictionary.put(getComboArmorsItem("energyMk2"), UpgradeDictionary.STORAGE, 1000000, 2);
        UpgradeDictionary.put(getComboArmorsItem("energyMk3"), UpgradeDictionary.STORAGE, 10000000, 3);

        // RailCraft

        UpgradeDictionary.put(GameRegistry.findItemStack("Railcraft", "ic2.upgrade.lapotron", 1), UpgradeDictionary.STORAGE, 10000000, 3);
    }

    // External APIs

    // GregTech

    public static boolean isGregTechAvailable()
    {
        try
        {
            return ((Boolean) Class.forName("gregtechmod.api.GregTech_API").getMethod("isGregTechLoaded").invoke(null)).booleanValue();
        }
        catch (Exception e)
        {
            return false;
        }
    }

    public static ItemStack getGregTechBlock(int aIndex, int aAmount, int aMeta)
    {
        try
        {
            return (ItemStack) Class.forName("gregtechmod.api.GregTech_API").getMethod("getGregTechBlock", int.class, int.class, int.class).invoke(null, aIndex, aAmount, aMeta);
        }
        catch (Exception e)
        {
            return null;
        }
    }

    public static ItemStack getGregTechItem(int aIndex, int aAmount, int aMeta)
    {
        try
        {
            return (ItemStack) Class.forName("gregtechmod.api.GregTech_API").getMethod("getGregTechItem", int.class, int.class, int.class).invoke(null, aIndex, aAmount, aMeta);
        }
        catch (Exception e)
        {
            return null;
        }
    }

    // ComboArmors

    public static ItemStack getComboArmorsItem(String item)
    {
        try
        {
            return (ItemStack) Class.forName("ic2ca.api.Ic2caItemsApi").getMethod("getItemByName", String.class).invoke(null, item);
        }
        catch (Exception e)
        {
            return null;
        }
    }
}
