/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.ic2recharger;

import aroma1997.ic2recharger.IC2Recharger;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import java.util.List;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class ItemRecharger
extends Item
implements IElectricItem {
    private int tier;

    public ItemRecharger(int id, int tier, String unlocalizedName) {
        super(id + -256);
        this.tier = tier;
        if (tier == 4) {
            this.func_77656_e(50);
        } else {
            this.func_77656_e(27);
        }
        this.func_77625_d(1);
        this.setNoRepair();
        this.func_77655_b(unlocalizedName);
        this.func_77637_a(IC2Recharger.creativeTabPR);
    }

    public boolean canProvideEnergy(ItemStack itemStack) {
        return true;
    }

    private void charge(ItemStack charger, World worldObj, EntityPlayer thePlayer, ItemStack chargedItem) {
        if (chargedItem != null && chargedItem.func_77973_b() instanceof IElectricItem && chargedItem != charger && !(chargedItem.func_77973_b() instanceof ItemRecharger)) {
            if (this.tier != 5) {
                int chargeAmount = ElectricItem.manager.charge(chargedItem, this.getTransferLimit(charger), this.tier, false, true);
                int charged = ElectricItem.manager.discharge(charger, chargeAmount, this.tier, false, false);
                ElectricItem.manager.charge(chargedItem, charged, this.tier, true, false);
            } else {
                ElectricItem.manager.charge(chargedItem, this.getTransferLimit(charger), this.tier, true, false);
            }
        }
    }

    public int getChargedItemId(ItemStack itemStack) {
        return this.field_77779_bT;
    }

    public int getEmptyItemId(ItemStack itemStack) {
        return this.field_77779_bT;
    }

    public int getMaxCharge(ItemStack itemStack) {
        switch (this.tier) {
            case 1: {
                return 40000;
            }
            case 2: {
                return 600000;
            }
            case 3: {
                return 10000000;
            }
            case 4: {
                return 100000000;
            }
            case 5: {
                return 100000000;
            }
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77633_a(int par1, CreativeTabs par2CreativeTabs, List itemList) {
        if (this.tier != 5) {
            ItemStack charged = new ItemStack((Item)this, 1);
            ElectricItem.manager.charge(charged, Integer.MAX_VALUE, Integer.MAX_VALUE, true, false);
            itemList.add(charged);
            itemList.add(new ItemStack((Item)this, 1, this.func_77612_l()));
        } else {
            itemList.add(new ItemStack((Item)this));
        }
    }

    public int getTier(ItemStack itemStack) {
        return this.tier > 3 ? 3 : this.tier;
    }

    public int getTransferLimit(ItemStack itemStack) {
        return this.getMaxCharge(itemStack) / 100;
    }

    public void func_77663_a(ItemStack stack, World worldObj, Entity entity, int par4, boolean par5) {
        if (entity instanceof EntityPlayer) {
            ItemStack[] armorInventory;
            ItemStack[] inventory;
            EntityPlayer thePlayer = (EntityPlayer)entity;
            for (ItemStack element : inventory = thePlayer.field_71071_by.field_70462_a) {
                this.charge(stack, worldObj, thePlayer, element);
            }
            for (ItemStack element : armorInventory = thePlayer.field_71071_by.field_70460_b) {
                this.charge(stack, worldObj, thePlayer, element);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a("Aroma1997sPortableRecharger:" + this.func_77658_a());
    }
}

