package net.minecraft.src.ic2.api;

import net.minecraft.src.IBlockAccess;
import net.minecraft.src.World;

/**
 * Interface used for all colorable blocks, will be used by Painter item.
 * 
 * @author Alblaka
 *
 */
public interface IPaintableBlock
{
	/**
	 * Called by painters on a Block, should color the block in any way.
	 * @param world World reference
	 * @param x X-Coordinate
	 * @param y Y-Coordinate
	 * @param z Z-Coordinate
	 * @param color Refers to the used color, based on Dye Metavalues.
	 * @return true if the block was colored, false otherwise
	 */
	public boolean colorBlock(World world, int x, int y, int z, int color);
}
