package net.minecraft.src.ic2.api;

/**
 * @file
 * @author Player
 * @version 2.0
 *
 * @section DESCRIPTION
 *
 * The IWrenchable interface has to be implemented by all objects (TEs) which want to make use of
 * the wrench's rotation and removal features.
 */

import net.minecraft.src.EntityPlayer;

public interface IWrenchable {
	/**
	 * Determine if the wrench can be used to set the block's facing to side.
	 *
	 * @note will be called before wrenchRemove
	 * @return true if the wrenching was applied and wrench should loose durability
	 */
	boolean wrenchSetFacing(EntityPlayer entityPlayer, int side);

	/**
	 * Set the block's facing
	 */
	void setFacing(short facing);
		
	/**
	 * Determine if the wrench can be used to remove the block.
	 *
	 * @note will be called if wrenchSetFacing fails
	 * @return true if the wrenching was applied and wrench should loose durability
	 */
	boolean wrenchRemove(EntityPlayer entityPlayer);
	
	/**
	 * Determine the probability to drop the block as it is (0 to 1).
	 *
	 * @note the first entry in getBlockDropped will be replaced by blockid:meta if the drop is successful 
	 */
	float getWrenchDropRate();
}

