// Decompiled by Jad v1.5.8g. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.kpdus.com/jad.html
// Decompiler options: packimports(3) braces deadcode 

package net.minecraft.src.EnergyCoupler;

import net.minecraft.src.TileEntity;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.Packet230ModLoader;
import net.minecraft.src.ModLoader;
import net.minecraft.src.ModLoaderMp;
import net.minecraft.src.IInventory;
import net.minecraft.src.ItemStack;

import net.minecraft.src.ic2.api.EnergyNet;
import net.minecraft.src.ic2.api.IEnergySink;
import net.minecraft.src.ic2.api.IEnergySource;
import net.minecraft.src.ic2.api.Direction;
import net.minecraft.src.ic2.api.IWrenchable;
import net.minecraft.src.ic2.api.IEnergyConductor;

import ic2.platform.Platform;
import ic2.platform.NetworkManager;

import ic2.common.INetworkUpdateListener;
import ic2.common.TileEntityBlock;

import java.util.List;
import java.util.Vector;
import java.text.DecimalFormat;
import java.math.BigDecimal;

import net.minecraft.src.buildcraft.api.IPowerReceptor;
import net.minecraft.src.buildcraft.api.Orientations;
import net.minecraft.src.buildcraft.api.Position;
import net.minecraft.src.buildcraft.api.PowerFramework;
import net.minecraft.src.buildcraft.api.PowerProvider;

// Referenced classes of package net.minecraft.src:
//            TileEntity, NBTTagCompound, World

public class TileEntityEnergyCoupler extends TileEntityBlock
  implements IEnergySink, IPowerReceptor, IEnergySource, IWrenchable, INetworkUpdateListener, IInventory
{
  public boolean addedToEnergyNet;
  PowerProvider powerProvider;
  public int maxStorage;
  public int energy;
  public boolean isRedstonePowered;
  public short invertDirection;
  
  private boolean created;
  private short facing;
  public short prevFacing;
  private boolean active;
  public boolean prevActive;
  
  public TileEntityEnergyCoupler(int maxEU)
  {
    created = false;
    facing = 0;
    prevFacing = 0;
    active = false;
    prevActive = false;
    
    addedToEnergyNet = false;
    powerProvider = PowerFramework.currentFramework.createPowerProvider();
    powerProvider.configure(0,1,convertToBCEnergy(maxEU),1,convertToBCEnergy(maxEU));
    maxStorage = maxEU;
    energy = 0;
    invertDirection = 0;
  }
  
  public void onCreated()
  {
    if(!Platform.isSimulating()) {
      NetworkManager.requestInitialTileEntityData(worldObj, xCoord, yCoord, zCoord);
    }
  }
  
  public void readFromNBT(NBTTagCompound nbttagcompound)
  {
     super.readFromNBT(nbttagcompound);
     prevFacing = facing = nbttagcompound.getShort("facing");
     invertDirection = nbttagcompound.getShort("invertDirection");
  }

  public void writeToNBT(NBTTagCompound nbttagcompound)
  {
     super.writeToNBT(nbttagcompound);
     nbttagcompound.setShort("facing", facing);
     nbttagcompound.setShort("invertDirection", invertDirection);
  }
  
  public boolean getActive()
  {
    return active;
  }

  public void setActive(boolean flag)
  {
    active = flag;
    if(prevActive != flag) {
      NetworkManager.updateTileEntityField(this, "active");
    }
    
    prevActive = flag;
  }
  
  public short getInvertDirection()
  {
    return invertDirection;
  }
  
  public void setInvertDirection(short flag)
  {
    invertDirection = flag;
    NetworkManager.updateTileEntityField(this, "invertDirection");
  }
  
  public void toggleDirection()
  {
    if (invertDirection == 1) {
      setInvertDirection((short)0);
    } else {
      setInvertDirection((short)1);
    }
  }
  
  public List getNetworkedFields()
  {
    Vector vector = new Vector(3);
    vector.add("active");
    vector.add("facing");
    vector.add("invertDirection");
    return vector;
  }
  
  public void onNetworkUpdate(String s)
  {
    if(s.equals("active") && prevActive != active || s.equals("facing") && prevFacing != facing) {
      worldObj.markBlockNeedsUpdate(xCoord, yCoord, zCoord);
      prevActive = active;
      prevFacing = facing;
    }
  }
  
  public short getFacing()
  {
    return facing;
  }
    
  public boolean demandsEnergy() 
  {
    if (isRedstonePowered) {
      return false;
    }
    
    return energy < maxStorage;
  }
  
  public int injectEnergy(Direction direction, int i) 
  {
    int j = i;
    
    if(energy + i > maxStorage) {
      j = maxStorage - energy;
    }
    
    energy += j;
    
    return i - j;
  }
  
  public boolean acceptsEnergyFrom(TileEntity tileentity, Direction direction) {
    //ModLoader.getMinecraftInstance().ingameGUI.addChatMessage((new StringBuilder()).append("[Energy Coupler] AcceptsEnergyFrom: Direction: "+direction.toSideValue()+" Facing: "+getFacing()).toString());
    if (invertDirection == 1) {
      return false;
    }
    
    return (tileentity instanceof IEnergyConductor && direction.toSideValue() == getFacing());
  }
  
  public boolean isAddedToEnergyNet() {
    return addedToEnergyNet;
  }
  
  public void updateEntity()
  {
    if(!created) {
      onCreated();
      created = true;
    }
    
    if(Platform.isSimulating()) {
      if (!addedToEnergyNet) {
        EnergyNet.getForWorld(worldObj).addTileEntity(this);
        addedToEnergyNet = true;
      }
      
      updateRedstone();
      
      if (!isRedstonePowered) {
        if (invertDirection == 1) {
          EnergyNet.getForWorld(worldObj).emitEnergyFrom(this, convertToEUs(getPowerProvider().useEnergy(1, powerRequest(), true)));
        } else {
          Position p = new Position(xCoord, yCoord, zCoord, Orientations.values()[getInverseFacing(getFacing())]);

      		p.moveForwards(1.0);

      		TileEntity tile = worldObj.getBlockTileEntity((int) p.x, (int) p.y, (int) p.z);
    
      		if (isPoweredTile(tile)) {
      		  IPowerReceptor receptor = (IPowerReceptor) tile;
    		    
    		    PowerProvider provider = receptor.getPowerProvider();
    		    if ((convertToBCEnergy(energy) + provider.energyStored) < provider.maxEnergyStored) {
    		      receptor.getPowerProvider().receiveEnergy(convertToBCEnergy(energy));
    		      energy -= maxStorage;
    		      
    		    } else {
    		      int energyToSend = provider.maxEnergyStored - provider.energyStored;
    		      receptor.getPowerProvider().receiveEnergy(energyToSend);
    		      //ModLoader.getMinecraftInstance().ingameGUI.addChatMessage((new StringBuilder()).append("[Energy Coupler] EnergyToSend: "+energyToSend+" EUs: "+convertToEUs(energyToSend)).toString());
    		      energy -= convertToEUs(energyToSend);
    		    }
    		    
    		    if (energy < 0) {
    		      energy = 0;
    		    }
      		}
        }
      }
    }
  }
  
  public void invalidate()
  {
    if(Platform.isSimulating() && addedToEnergyNet) {
      EnergyNet.getForWorld(worldObj).removeTileEntity(this);
      addedToEnergyNet = false;
    }
    
    super.invalidate();
  }
  
  public int getMaxEnergyOutput()
  {
    return maxStorage;
  }
  
  public boolean emitsEnergyTo(TileEntity tileentity, Direction direction)
  {
    if (invertDirection == 1 && !isRedstonePowered) {
      return direction.toSideValue() == getFacing();
    }
    
    return false;
  }
  
  public void updateRedstone()
  {
    boolean flag = worldObj.isBlockIndirectlyGettingPowered(xCoord, yCoord, zCoord);
    if(flag != isRedstonePowered) {
      EnergyNet.getForWorld(worldObj).removeTileEntity(this);
      addedToEnergyNet = false;
      isRedstonePowered = flag;
      EnergyNet.getForWorld(worldObj).addTileEntity(this);
      addedToEnergyNet = true;
    }
  }
  
  public boolean isPoweredTile (TileEntity tile) {
 		if (tile instanceof IPowerReceptor) {
 			IPowerReceptor receptor = (IPowerReceptor) tile;
 			PowerProvider provider = receptor.getPowerProvider();
 			
 			return provider != null;	
 		}
 		
 		return false;
 	}
  
  public void setPowerProvider (PowerProvider provider) {
    powerProvider = provider;
  }
	
	public PowerProvider getPowerProvider () {
	  return powerProvider;
	}
	
	public void doWork () {
    
	}
	
	public int powerRequest () {
	  if (invertDirection == 1 && !isRedstonePowered) {
	    //return new BigDecimal(maxStorage).divide(new BigDecimal(BlockEnergyCoupler.conversionRatio.value),BigDecimal.ROUND_HALF_DOWN).intValueExact();
	    //return maxStorage;
	    return getPowerProvider().maxEnergyReceived;
	  }
	  
	  return 0;
	}
	
	public boolean wrenchSetFacing(EntityPlayer entityplayer, int i)
  {
    return getFacing() != i;
  }

  public void setFacing(short word0)
  {
    if(addedToEnergyNet) {
      EnergyNet.getForWorld(worldObj).removeTileEntity(this);
    }
    
    addedToEnergyNet = false;
    facing = word0;
    if(prevFacing != word0) {
      NetworkManager.updateTileEntityField(this, "facing");
    }
    prevFacing = word0;
    EnergyNet.getForWorld(worldObj).addTileEntity(this);
    addedToEnergyNet = true;
  }
  
  public boolean wrenchRemove(EntityPlayer entityplayer)
  {
    return true;
  }
  
  public float getWrenchDropRate()
  {
    return 1.0F;
  }
  
  /*
	public boolean changeFacing(short word0)
  {
    if(getFacing() == word0) {
        return false;
    }
    
    if(Platform.isSimulating()) {
      if(addedToEnergyNet) {
        EnergyNet.getForWorld(worldObj).removeTileEntity(this);
      }

      addedToEnergyNet = false;
      setFacing(word0);
      EnergyNet.getForWorld(worldObj).addTileEntity(this);
      addedToEnergyNet = true;
    }
    
    return true;
  }
	*/
	
	public short getInverseFacing(short i)
  {
    short back = 0;
    
    switch (i) {
      case 0:
        back = 1;
        break;
        
      case 1:
        back = 0;
        break;
        
      case 5:
        back = 4;
        break;
        
      case 4:
        back = 5;
        break;
        
      case 2:
        back = 3;
        break;
        
      case 3:
        back = 2;
        break;
    }
      
    return back;
  }
  
  protected int convertToEUs(int i)
  {
    return new BigDecimal(i).multiply(new BigDecimal(BlockEnergyCoupler.conversionRatio.value)).intValue();
  }
  
  protected int convertToBCEnergy(int i)
  {
    return new BigDecimal(i).divide(new BigDecimal(BlockEnergyCoupler.conversionRatio.value),BigDecimal.ROUND_HALF_DOWN).intValueExact();
  }
  
  public int getSizeInventory()
  {
    return 0;
  }

  public ItemStack getStackInSlot(int i)
  {
    ItemStack stack[] = new ItemStack[0];
    return stack[0];
  }

  public ItemStack decrStackSize(int i, int j)
  {
    ItemStack stack[] = new ItemStack[0];
    return stack[0];
  }

  public void setInventorySlotContents(int i, ItemStack itemstack)
  {
    
  }

  public String getInvName()
  {
    return "";
  }

  public int getInventoryStackLimit()
  {
    return 0;
  }

  public boolean canInteractWith(EntityPlayer entityplayer)
  {
    return true;
  }

  public void openChest()
  {
    
  }

  public void closeChest()
  {
    
  }
}
