/*
 * Decompiled with CFR 0.152.
 */
package gcewing.lighting;

import gcewing.lighting.BaseContainer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;

public class BaseGuiContainer
extends GuiContainer {
    double uscale;
    double vscale;
    float red = 1.0f;
    float green = 1.0f;
    float blue = 1.0f;
    int textColor = 0x404040;
    boolean textShadow = false;

    public BaseGuiContainer(Container container, int width, int height) {
        super(container);
        this.field_74194_b = width;
        this.field_74195_c = height;
    }

    public BaseGuiContainer(BaseContainer container) {
        this(container, container.xSize, container.ySize);
    }

    protected void func_74185_a(float var1, int var2, int var3) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.field_74198_m, (float)this.field_74197_n, (float)0.0f);
        this.drawBackgroundLayer();
        GL11.glPopMatrix();
    }

    void drawBackgroundLayer() {
    }

    protected void func_74189_g(int par1, int par2) {
        this.drawForegroundLayer();
    }

    void drawForegroundLayer() {
    }

    void close() {
        this.field_73882_e.field_71439_g.func_71053_j();
    }

    void bindTexture(ResourceLocation rsrc) {
        this.bindTexture(rsrc, 1, 1);
    }

    void bindTexture(ResourceLocation rsrc, int usize, int vsize) {
        System.out.printf("BaseGuiContainer.bindTexture: %s size (%s, %s)\n", rsrc, usize, vsize);
        this.field_73882_e.func_110434_K().func_110577_a(rsrc);
        this.uscale = 1.0 / (double)usize;
        this.vscale = 1.0 / (double)vsize;
    }

    void drawTexturedRect(double x, double y, double w, double h) {
        this.drawTexturedRectUV(x, y, w, h, 0.0, 0.0, 1.0, 1.0);
    }

    void drawTexturedRect(double x, double y, double w, double h, double u, double v) {
        this.drawTexturedRect(x, y, w, h, u, v, w, h);
    }

    void drawTexturedRect(double x, double y, double w, double h, double u, double v, double us, double vs) {
        this.drawTexturedRectUV(x, y, w, h, u * this.uscale, v * this.vscale, us * this.uscale, vs * this.vscale);
    }

    void drawTexturedRectUV(double x, double y, double w, double h, double u, double v, double us, double vs) {
        Tessellator tess = Tessellator.field_78398_a;
        tess.func_78382_b();
        tess.func_78386_a(this.red, this.green, this.blue);
        tess.func_78374_a(x, y + h, (double)this.field_73735_i, u, v + vs);
        tess.func_78374_a(x + w, y + h, (double)this.field_73735_i, u + us, v + vs);
        tess.func_78374_a(x + w, y, (double)this.field_73735_i, u + us, v);
        tess.func_78374_a(x, y, (double)this.field_73735_i, u, v);
        tess.func_78381_a();
    }

    public void setColor(double r, double g, double b) {
        this.red = (float)r;
        this.green = (float)g;
        this.blue = (float)b;
    }

    public void resetColor() {
        this.setColor(1.0, 1.0, 1.0);
    }

    public void drawString(String s, int x, int y) {
        this.field_73886_k.func_85187_a(s, x, y, this.textColor, this.textShadow);
    }

    public void drawCenteredString(String s, int x, int y) {
        this.field_73886_k.func_85187_a(s, x - this.field_73886_k.func_78256_a(s) / 2, y, this.textColor, this.textShadow);
    }

    public void drawInventoryName(IInventory inv, int x, int y) {
        this.drawString(BaseGuiContainer.inventoryName(inv), x, y);
    }

    public void drawPlayerInventoryName() {
        this.drawString(BaseGuiContainer.playerInventoryName(), 8, this.field_74195_c - 96 + 2);
    }

    public static String inventoryName(IInventory inv) {
        String name = inv.func_70303_b();
        if (!inv.func_94042_c()) {
            name = StatCollector.func_74838_a((String)name);
        }
        return name;
    }

    public static String playerInventoryName() {
        return StatCollector.func_74838_a((String)"container.inventory");
    }
}

