/*
 * Decompiled with CFR 0.152.
 */
package gcewing.lighting;

import gcewing.lighting.BaseContainerBlock;
import gcewing.lighting.Floodlight;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class BlockFloodlight<TE extends TileEntity>
extends BaseContainerBlock<TE> {
    static int renderType;
    protected Icon[] icons;

    public BlockFloodlight(int id) {
        this(id, Material.field_76246_e, null);
    }

    public BlockFloodlight(int id, Class<TE> teClass) {
        this(id, Material.field_76246_e, teClass);
    }

    public BlockFloodlight(int id, Material mat, Class<TE> teClass) {
        super(id, mat, teClass);
    }

    @Override
    public void func_94332_a(IconRegister reg) {
        this.icons = new Icon[6];
        this.icons[0] = this.getIcon(reg, "floodlight-bottom");
        this.icons[1] = this.getIcon(reg, "floodlight-side");
        this.icons[2] = this.getIcon(reg, "floodlight-top");
        this.icons[3] = this.getIcon(reg, "floodlight-bottom-lit");
        this.icons[4] = this.getIcon(reg, "floodlight-side-lit");
        this.icons[5] = this.getIcon(reg, "floodlight-top-lit");
        super.func_94332_a(reg);
    }

    @Override
    public int func_71857_b() {
        return renderType;
    }

    @Override
    public void setRenderType(int id) {
        renderType = id;
    }

    public int func_85104_a(World world, int x, int y, int z, int side, float hx, float hy, float hz, int initData) {
        return side << 1;
    }

    @Override
    public Icon func_71858_a(int side, int data) {
        int base = 0;
        if ((data & 1) != 0) {
            base += 3;
        }
        switch (side) {
            case 0: {
                return this.icons[base];
            }
            case 1: {
                return this.icons[base + 2];
            }
        }
        return this.icons[base + 1];
    }

    public void func_71861_g(World world, int x, int y, int z) {
        this.update(world, x, y, z);
        this.updateBeam(world, x, y, z);
    }

    @Override
    public void func_71852_a(World world, int x, int y, int z, int id, int metadata) {
        ForgeDirection dir = this.direction(metadata);
        Floodlight.propagateBeam(world, x, y, z, dir, 0, 1);
        super.func_71852_a(world, x, y, z, id, metadata);
    }

    public void func_71863_a(World world, int x, int y, int z, int neighborBlockID) {
        this.update(world, x, y, z);
        this.updateBeam(world, x, y, z);
    }

    public void update(World world, int x, int y, int z) {
        if (!world.field_72995_K) {
            boolean active = this.isActive(world, x, y, z);
            this.setIlluminated(world, x, y, z, active);
        }
    }

    public void updateBeam(World world, int x, int y, int z) {
        if (!world.field_72995_K) {
            ForgeDirection dir = this.getDirection(world, x, y, z);
            Floodlight.updateBeamInDirection(world, x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ, dir);
        }
    }

    public void setIlluminated(World world, int x, int y, int z, boolean state) {
        int newData;
        int oldData = world.func_72805_g(x, y, z);
        if (oldData != (newData = oldData & 0xE | (state ? 1 : 0))) {
            world.func_72921_c(x, y, z, newData, 3);
            world.func_72845_h(x, y, z);
        }
    }

    public boolean isActive(World world, int x, int y, int z) {
        return world.func_72864_z(x, y, z);
    }

    public boolean isActiveInDirection(World world, int x, int y, int z, ForgeDirection dir) {
        return this.getDirection(world, x, y, z) == dir && this.isActive(world, x, y, z);
    }

    public ForgeDirection getDirection(World world, int x, int y, int z) {
        int data = world.func_72805_g(x, y, z);
        return this.direction(data);
    }

    public ForgeDirection direction(int metadata) {
        return ForgeDirection.getOrientation((int)(metadata >> 1));
    }
}

