/*
 * Decompiled with CFR 0.152.
 */
package gcewing.lighting;

import gcewing.lighting.GregsLighting;
import gcewing.lighting.Water;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;

public class TEFloodlightCarbide
extends TileEntity
implements IInventory,
ISidedInventory {
    ItemStack[] inventory = new ItemStack[2];
    static final int waterSlot = 0;
    static final int carbideSlot = 1;
    static final int[] waterSideSlots = new int[]{0};
    static final int[] carbideSideSlots = new int[]{1};
    static final int minutesPerCarbide = 5;
    static final int maxCarbideLevel = 300;
    static final int maxWaterLevel = 19200;
    int waterLevel;
    int carbideLevel;
    int ticks = 0;

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.inventory[i];
    }

    public ItemStack func_70304_b(int i) {
        return null;
    }

    public void func_70299_a(int i, ItemStack stack) {
        this.inventory[i] = stack;
        this.func_70296_d();
        this.refillWater();
        this.updateBlock();
    }

    public String func_70303_b() {
        return "container.carbide_floodlight";
    }

    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack stack = this.inventory[slot];
        if (stack != null) {
            if (stack.field_77994_a <= amount) {
                this.inventory[slot] = null;
            } else {
                stack = stack.func_77979_a(amount);
            }
            this.func_70296_d();
        }
        return stack;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return true;
    }

    public int[] func_94128_d(int side) {
        if (side == ForgeDirection.UP.ordinal()) {
            return waterSideSlots;
        }
        return carbideSideSlots;
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return true;
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return true;
    }

    public void func_70307_a(NBTTagCompound tc) {
        super.func_70307_a(tc);
        NBTTagList tlist = tc.func_74761_m("Items");
        this.inventory = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < tlist.func_74745_c(); ++i) {
            NBTTagCompound titem = (NBTTagCompound)tlist.func_74743_b(i);
            byte s = titem.func_74771_c("Slot");
            if (s < 0 || s >= this.inventory.length) continue;
            this.inventory[s] = ItemStack.func_77949_a((NBTTagCompound)titem);
        }
        this.waterLevel = tc.func_74762_e("Water");
        this.carbideLevel = tc.func_74762_e("Carbide");
    }

    public void func_70310_b(NBTTagCompound tc) {
        super.func_70310_b(tc);
        NBTTagList tlist = new NBTTagList();
        for (int i = 0; i < this.inventory.length; ++i) {
            if (this.inventory[i] == null) continue;
            NBTTagCompound titem = new NBTTagCompound();
            titem.func_74774_a("Slot", (byte)i);
            this.inventory[i].func_77955_b(titem);
            tlist.func_74742_a((NBTBase)titem);
        }
        tc.func_74782_a("Items", (NBTBase)tlist);
        tc.func_74768_a("Water", this.waterLevel);
        tc.func_74768_a("Carbide", this.carbideLevel);
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_94042_c() {
        return false;
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n) == this) {
            return player.func_70092_e((double)this.field_70329_l + 0.5, (double)this.field_70330_m + 0.5, (double)this.field_70327_n + 0.5) <= 64.0;
        }
        return false;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public void func_70316_g() {
        if (!this.field_70331_k.field_72995_K) {
            if (this.ticks == 0) {
                this.ticks = 20;
                if (this.isActive()) {
                    --this.waterLevel;
                    this.refillWater();
                    --this.carbideLevel;
                    this.refillCarbide();
                    if (!this.isActive()) {
                        this.updateBlock();
                    }
                }
            }
            --this.ticks;
        }
    }

    void updateBlock() {
        GregsLighting.floodlightCarbide.update(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public boolean isActive() {
        return this.waterLevel > 0 && this.carbideLevel > 0 && this.receivingRedstoneSignal();
    }

    boolean receivingRedstoneSignal() {
        return this.field_70331_k.func_72864_z(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    void refillWater() {
        ItemStack stack;
        if (this.waterLevel == 0 && Water.isWaterItem(stack = this.inventory[0])) {
            this.waterLevel = 19200;
            ItemStack container = Water.emptyContainerFor(stack);
            if (container != null) {
                this.func_70299_a(0, container);
            } else {
                this.func_70298_a(0, 1);
            }
        }
    }

    void refillCarbide() {
        ItemStack stack;
        if (this.carbideLevel == 0 && this.waterLevel > 0 && this.receivingRedstoneSignal() && (stack = this.inventory[1]) != null && stack.func_77973_b() == GregsLighting.calciumCarbide) {
            this.func_70298_a(1, 1);
            this.carbideLevel = 300;
        }
    }
}

