/*
 * Decompiled with CFR 0.152.
 */
package gcewing.lighting.ic2;

import gcewing.lighting.GregsLighting;
import gcewing.lighting.ic2.BlockFloodlightIC2;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.tile.IWrenchable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;

public class TEFloodlightIC2
extends TileEntity
implements IEnergySink,
IWrenchable {
    final int maxEnergy = 64;
    final int maxInput = 32;
    final int energyUsedPerTick = 1;
    int energy = 0;
    boolean addedToEnergyNet = false;

    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.energy = nbt.func_74762_e("energy");
    }

    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        nbt.func_74768_a("energy", this.energy);
    }

    public void onChunkUnload() {
        this.func_70313_j();
    }

    public int getMaxSafeInput() {
        return 32;
    }

    public void func_70316_g() {
        if (!this.field_70331_k.field_72995_K) {
            if (!this.addedToEnergyNet) {
                System.out.printf("TEFloodlightIC2.updateEntity: adding to energy net\n", new Object[0]);
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
                this.addedToEnergyNet = true;
                this.func_70296_d();
            }
            if (this.isActive()) {
                --this.energy;
                if (this.energy < 0) {
                    this.energy = 0;
                }
                this.func_70296_d();
                if (!this.isActive()) {
                    this.updateBlock();
                }
            }
        }
        super.func_70316_g();
    }

    public void func_70313_j() {
        if (this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.addedToEnergyNet = false;
            this.func_70296_d();
        }
        super.func_70313_j();
    }

    BlockFloodlightIC2 getBlock() {
        return (BlockFloodlightIC2)this.func_70311_o();
    }

    void updateBlock() {
        BlockFloodlightIC2 block = this.getBlock();
        block.update(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
        block.updateBeam(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public boolean isActive() {
        boolean on = this.switchedOn();
        boolean redstone = this.receivingRedstoneSignal();
        return this.energy > 0 && (on || redstone);
    }

    public boolean switchedOn() {
        BlockFloodlightIC2 block = this.getBlock();
        boolean result = block.switchedOn;
        return result;
    }

    boolean receivingRedstoneSignal() {
        return this.field_70331_k.func_72864_z(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return true;
    }

    public double demandedEnergyUnits() {
        return Math.max(0, this.maxEnergy - this.energy);
    }

    public double injectEnergyUnits(ForgeDirection directionFrom, double amount) {
        if (amount > 32.0) {
            System.out.printf("TEFloodlightIC2.injectEnergy: Exploding\n", new Object[0]);
            GregsLighting.explodeMachineAt(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
            return 0.0;
        }
        boolean hadEnergy = this.energy > 0;
        int surplus = 0;
        this.energy = (int)((double)this.energy + amount);
        if (this.energy > 64) {
            surplus = this.energy - 64;
            this.energy = 64;
        }
        if (hadEnergy != this.energy > 0) {
            this.func_70296_d();
            this.updateBlock();
        }
        return surplus;
    }

    public boolean isAddedToEnergyNet() {
        return this.addedToEnergyNet;
    }

    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return false;
    }

    public short getFacing() {
        return 0;
    }

    public void setFacing(short facing) {
    }

    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return false;
    }

    public float getWrenchDropRate() {
        return 0.0f;
    }

    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return null;
    }
}

