/*
 * Decompiled with CFR 0.152.
 */
package gcewing.lighting;

import cpw.mods.fml.common.registry.VillagerRegistry;
import java.io.File;
import java.util.Collection;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.Property;

public class BaseConfiguration
extends Configuration {
    public boolean extended = false;
    int nextVillagerID = 100;

    public BaseConfiguration(File file) {
        super(file);
    }

    public boolean getBoolean(String category, String key, boolean defaultValue) {
        return this.get(category, key, defaultValue).getBoolean(defaultValue);
    }

    public int getInteger(String category, String key, int defaultValue) {
        return this.get(category, key, defaultValue).getInt();
    }

    public int getVillager(String key, String skin) {
        VillagerRegistry reg = VillagerRegistry.instance();
        Property prop = this.get("villagers", key, -1);
        int id = prop.getInt();
        if (id == -1) {
            id = this.allocateVillagerId(reg);
            prop.set(id);
        }
        reg.registerVillagerId(id);
        return id;
    }

    int allocateVillagerId(VillagerRegistry reg) {
        int id;
        Collection inUse = VillagerRegistry.getRegisteredVillagers();
        do {
            ++this.nextVillagerID;
        } while (inUse.contains(id));
        return id;
    }

    public Property get(String category, String key, String defaultValue, String comment, Property.Type type) {
        if (!this.hasKey(category, key)) {
            this.extended = true;
        }
        return super.get(category, key, defaultValue, comment, type);
    }
}

