/*
 * Decompiled with CFR 0.152.
 */
package gcewing.lighting;

import cpw.mods.fml.common.registry.GameRegistry;
import gcewing.lighting.BaseMod;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BaseContainerBlock<TE extends TileEntity>
extends BlockContainer
implements BaseMod.IBlock {
    static Random random = new Random();
    public int renderID = 0;
    Class<? extends TileEntity> tileEntityClass = null;
    String[] iconNames = null;
    Icon[] icons;

    public BaseContainerBlock(int id, Material material, Class<TE> teClass) {
        super(id, material);
        this.tileEntityClass = teClass;
        if (teClass != null) {
            try {
                GameRegistry.registerTileEntity(teClass, (String)teClass.getName());
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
    }

    public static Icon getIcon(Block block, IconRegister reg, String name) {
        String modPackage = block.getClass().getPackage().getName();
        return reg.func_94245_a(modPackage + ":" + name);
    }

    public static Icon[] getIcons(Block block, IconRegister reg, String ... names) {
        Icon[] result = new Icon[names.length];
        for (int i = 0; i < names.length; ++i) {
            result[i] = BaseContainerBlock.getIcon(block, reg, names[i]);
        }
        return result;
    }

    void setIconNames(String ... names) {
        this.iconNames = names;
    }

    void setPrefixedIconNames(String prefix, String ... suffixes) {
        String[] names = new String[suffixes.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = prefix + "-" + suffixes[i];
        }
        this.setIconNames(names);
    }

    public int func_71857_b() {
        return this.renderID;
    }

    @Override
    public void setRenderType(int id) {
        this.renderID = id;
    }

    @Override
    public String getQualifiedRendererClassName() {
        String name = this.getRendererClassName();
        if (name != null) {
            name = this.getClass().getPackage().getName() + "." + name;
        }
        return name;
    }

    String getRendererClassName() {
        return null;
    }

    public boolean func_71886_c() {
        return this.renderID == 0;
    }

    public void func_94332_a(IconRegister reg) {
        this.icons = this.iconNames != null ? this.getIcons(reg, this.iconNames) : this.getIcons(reg, this.func_71917_a().substring(5));
    }

    protected Icon getIcon(IconRegister reg, String name) {
        return BaseContainerBlock.getIcon((Block)this, reg, name);
    }

    protected Icon[] getIcons(IconRegister reg, String ... names) {
        return BaseContainerBlock.getIcons((Block)this, reg, names);
    }

    public Icon func_71858_a(int side, int data) {
        return this.getLocalIcon(side, data);
    }

    Icon getLocalIcon(int side, int data) {
        if (this.icons == null) {
            System.out.println("icons is null");
        }
        if (side < this.icons.length) {
            return this.icons[side];
        }
        return this.icons[this.icons.length - 1];
    }

    public boolean hasTileEntity(int metadata) {
        return this.tileEntityClass != null;
    }

    public TE getTileEntity(IBlockAccess world, int x, int y, int z) {
        if (this.func_71887_s()) {
            return (TE)world.func_72796_p(x, y, z);
        }
        return null;
    }

    public TileEntity func_72274_a(World world) {
        if (this.tileEntityClass != null) {
            try {
                return this.tileEntityClass.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public void func_71852_a(World world, int x, int y, int z, int par5, int par6) {
        IInventory var7;
        TileEntity te = world.func_72796_p(x, y, z);
        if (te instanceof IInventory && (var7 = (IInventory)te) != null) {
            for (int var8 = 0; var8 < var7.func_70302_i_(); ++var8) {
                ItemStack var9 = var7.func_70301_a(var8);
                if (var9 == null) continue;
                float var10 = random.nextFloat() * 0.8f + 0.1f;
                float var11 = random.nextFloat() * 0.8f + 0.1f;
                float var12 = random.nextFloat() * 0.8f + 0.1f;
                while (var9.field_77994_a > 0) {
                    int var13 = random.nextInt(21) + 10;
                    if (var13 > var9.field_77994_a) {
                        var13 = var9.field_77994_a;
                    }
                    var9.field_77994_a -= var13;
                    EntityItem var14 = new EntityItem(world, (double)((float)x + var10), (double)((float)y + var11), (double)((float)z + var12), new ItemStack(var9.field_77993_c, var13, var9.func_77960_j()));
                    float var15 = 0.05f;
                    var14.field_70159_w = (float)random.nextGaussian() * var15;
                    var14.field_70181_x = (float)random.nextGaussian() * var15 + 0.2f;
                    var14.field_70179_y = (float)random.nextGaussian() * var15;
                    if (var9.func_77942_o()) {
                        var14.func_92059_d().func_77982_d((NBTTagCompound)var9.func_77978_p().func_74737_b());
                    }
                    world.func_72838_d((Entity)var14);
                }
            }
        }
        super.func_71852_a(world, x, y, z, par5, par6);
    }
}

