/*
 * Decompiled with CFR 0.152.
 */
package gcewing.lighting;

import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.relauncher.ReflectionHelper;
import gcewing.lighting.BaseConfiguration;
import gcewing.lighting.BaseModClient;
import java.io.File;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.ConfigCategory;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.Property;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class BaseMod
implements IGuiHandler {
    public BaseConfiguration config;
    public String modPackage;
    public String resourceDir;
    public URL resourceURL;
    public BaseMod base;
    public BaseModClient client;
    public IGuiHandler proxy;
    public boolean serverSide;
    public boolean clientSide;
    public boolean debugGui;
    File cfgFile;
    List<IBlock> registeredBlocks = new ArrayList<IBlock>();
    Map<Integer, Class<? extends Container>> containerClasses = new HashMap<Integer, Class<? extends Container>>();

    public String resourcePath(String fileName) {
        return this.resourceDir + fileName;
    }

    public BaseMod() {
        this.base = this;
        this.modPackage = this.getClass().getPackage().getName();
        String resourceRelDir = "assets/" + this.modPackage + "/";
        this.resourceDir = "/" + resourceRelDir;
        this.resourceURL = this.getClass().getClassLoader().getResource(resourceRelDir);
    }

    public void preInit(FMLPreInitializationEvent e) {
        this.serverSide = e.getSide().isServer();
        this.clientSide = e.getSide().isClient();
        this.cfgFile = e.getSuggestedConfigurationFile();
        this.loadConfig();
        boolean[] configMarkers = (boolean[])ReflectionHelper.getPrivateValue(Configuration.class, (Object)((Object)this.config), (String[])new String[]{"configMarkers"});
        this.preallocateBlockIDs(configMarkers);
        this.preallocateItemIDs(configMarkers);
    }

    void preallocateBlockIDs(boolean[] configMarkers) {
        ConfigCategory items = this.config.getCategory("block");
        for (Property prop : items.getValues().values()) {
            int id = prop.getInt();
            if (id == -1) continue;
            configMarkers[id] = true;
        }
    }

    void preallocateItemIDs(boolean[] configMarkers) {
        ConfigCategory items = this.config.getCategory("item");
        for (Property prop : items.getValues().values()) {
            int id = prop.getInt();
            if (id == -1) continue;
            configMarkers[id + 256] = true;
        }
    }

    public void init(FMLInitializationEvent e) {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void postInit(FMLPostInitializationEvent e) {
        this.registerBlocks();
        this.registerItems();
        this.registerOres();
        this.registerRecipes();
        this.registerTileEntities();
        this.registerRandomItems();
        this.registerWorldGenerators();
        this.registerContainers();
        this.registerEntities();
        this.registerOther();
        if (e.getSide().isClient()) {
            this.client = this.initClient();
            this.proxy = this.client;
        }
        System.out.printf("BaseMod.postInit: %s: client = %s\n", this, this.client);
        if (this.proxy == null) {
            this.proxy = this;
        }
        NetworkRegistry.instance().registerGuiHandler((Object)this, this.proxy);
        this.saveConfig();
    }

    void loadConfig() {
        this.config = new BaseConfiguration(this.cfgFile);
    }

    void saveConfig() {
        if (this.config.extended) {
            this.config.save();
        }
    }

    String qualifiedName(String name) {
        return this.modPackage + "." + name;
    }

    BaseModClient initClient() {
        return new BaseModClient(this);
    }

    public Item newItem(String name, String title) {
        return this.newItem(name, Item.class, title);
    }

    public <ITEM extends Item> ITEM newItem(String name, Class<ITEM> cls, String title) {
        try {
            int id = this.config.getItem(name, 31743).getInt();
            Constructor<ITEM> ctor = cls.getConstructor(Integer.TYPE);
            Item item = (Item)ctor.newInstance(id);
            String qualName = this.modPackage + ":" + name;
            item.func_77655_b(qualName);
            item.func_111206_d(qualName);
            LanguageRegistry.addName((Object)item, (String)title);
            if (this.clientSide && item.func_77640_w() == null) {
                item.func_77637_a(CreativeTabs.field_78026_f);
            }
            return (ITEM)item;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Block newBlock(String name, String title) {
        return this.newBlock(name, Block.class, title);
    }

    public <BLOCK extends Block> BLOCK newBlock(String name, Class<BLOCK> cls, String title) {
        return this.newBlock(name, cls, ItemBlock.class, title);
    }

    public <BLOCK extends Block> BLOCK newBlock(String name, Class<BLOCK> cls, Class itemClass, String title) {
        try {
            int id = this.config.getBlock(name, 4095).getInt();
            Constructor<BLOCK> ctor = cls.getConstructor(Integer.TYPE);
            Block block = (Block)ctor.newInstance(id);
            String qualName = this.modPackage + ":" + name;
            block.func_71864_b(qualName);
            block.func_111022_d(qualName);
            GameRegistry.registerBlock((Block)block, (Class)itemClass);
            if (title != null) {
                LanguageRegistry.addName((Object)block, (String)title);
                if (this.clientSide && block.func_71882_w() == null && !title.startsWith("[")) {
                    block.func_71849_a(CreativeTabs.field_78026_f);
                }
            }
            if (block instanceof IBlock) {
                this.registeredBlocks.add((IBlock)block);
            }
            return (BLOCK)block;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void registerOre(String name, Block block) {
        OreDictionary.registerOre((String)name, (ItemStack)new ItemStack(block));
    }

    public void registerOre(String name, Item item) {
        OreDictionary.registerOre((String)name, (Item)item);
    }

    public static boolean blockMatchesOre(Block block, String name) {
        return BaseMod.stackMatchesOre(new ItemStack(block), name);
    }

    public static boolean itemMatchesOre(Item item, String name) {
        return BaseMod.stackMatchesOre(new ItemStack(item), name);
    }

    public static boolean stackMatchesOre(ItemStack stack, String name) {
        int id = OreDictionary.getOreID((ItemStack)stack);
        return id == OreDictionary.getOreID((String)name);
    }

    public void newRecipe(Item product, int qty, Object ... params) {
        this.newRecipe(new ItemStack(product, qty), params);
    }

    public void newRecipe(Block product, int qty, Object ... params) {
        this.newRecipe(new ItemStack(product, qty), params);
    }

    public void newRecipe(ItemStack product, Object ... params) {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(product, params));
    }

    public void newShapelessRecipe(Block product, int qty, Object ... params) {
        this.newShapelessRecipe(new ItemStack(product, qty), params);
    }

    public void newShapelessRecipe(Item product, int qty, Object ... params) {
        this.newShapelessRecipe(new ItemStack(product, qty), params);
    }

    public void newShapelessRecipe(ItemStack product, Object ... params) {
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(product, params));
    }

    public void newSmeltingRecipe(Item product, int qty, Item input) {
        GameRegistry.addSmelting((int)input.field_77779_bT, (ItemStack)new ItemStack(product, qty), (float)0.0f);
    }

    public void newSmeltingRecipe(Item product, int qty, Block input) {
        GameRegistry.addSmelting((int)input.field_71990_ca, (ItemStack)new ItemStack(product, qty), (float)0.0f);
    }

    public void addRandomChestItem(ItemStack stack, int minQty, int maxQty, int weight, String ... category) {
        WeightedRandomChestContent item = new WeightedRandomChestContent(stack, minQty, maxQty, weight);
        for (int i = 0; i < category.length; ++i) {
            ChestGenHooks.addItem((String)category[i], (WeightedRandomChestContent)item);
        }
    }

    public void registerEntity(Class<? extends Entity> cls, String name, Enum id) {
        this.registerEntity(cls, name, id.ordinal());
    }

    public void registerEntity(Class<? extends Entity> cls, String name, int id) {
        this.registerEntity(cls, name, id, 1, true);
    }

    public void registerEntity(Class<? extends Entity> cls, String name, Enum id, int updateFrequency, boolean sendVelocityUpdates) {
        this.registerEntity(cls, name, id.ordinal(), updateFrequency, sendVelocityUpdates);
    }

    public void registerEntity(Class<? extends Entity> cls, String name, int id, int updateFrequency, boolean sendVelocityUpdates) {
        System.out.printf("%s: BaseMod.registerEntity: %s, \"%s\", %s\n", this.getClass().getSimpleName(), cls.getSimpleName(), name, id);
        EntityRegistry.registerModEntity(cls, (String)name, (int)id, (Object)this.base, (int)256, (int)updateFrequency, (boolean)sendVelocityUpdates);
    }

    void registerBlocks() {
    }

    void registerItems() {
    }

    void registerOres() {
    }

    void registerRecipes() {
    }

    void registerTileEntities() {
    }

    void registerRandomItems() {
    }

    void registerWorldGenerators() {
    }

    void registerEntities() {
    }

    void registerOther() {
    }

    public ResourceLocation resourceLocation(String path) {
        return new ResourceLocation(this.modPackage, path);
    }

    public ResourceLocation textureLocation(String path) {
        return this.resourceLocation("textures/" + path);
    }

    public Set<String> listResources(String subdir) {
        try {
            JarFile jar;
            HashSet<String> result = new HashSet<String>();
            String protocol = this.resourceURL.getProtocol();
            if (protocol.equals("jar")) {
                String resPath = this.resourceURL.getPath();
                int pling = resPath.lastIndexOf("!");
                URL jarURL = new URL(resPath.substring(0, pling));
                String resDirInJar = resPath.substring(pling + 2);
                String prefix = resDirInJar + subdir + "/";
                jar = new JarFile(new File(jarURL.toURI()));
                Enumeration<JarEntry> entries = jar.entries();
                while (entries.hasMoreElements()) {
                    String name = entries.nextElement().getName();
                    if (!name.startsWith(prefix) || name.endsWith("/") || name.contains("/.")) continue;
                    result.add(name.substring(prefix.length()));
                }
            } else {
                throw new RuntimeException("Resource URL protocol " + protocol + " not supported");
            }
            jar.close();
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    void registerContainers() {
    }

    public void addContainer(Enum id, Class<? extends Container> cls) {
        this.addContainer(id.ordinal(), cls);
    }

    public void addContainer(int id, Class<? extends Container> cls) {
        this.containerClasses.put(id, cls);
    }

    public void openGui(EntityPlayer player, Enum id, World world, int x, int y, int z) {
        this.openGui(player, id.ordinal(), world, x, y, z);
    }

    public void openGui(EntityPlayer player, int id, World world, int x, int y, int z) {
        if (this.debugGui) {
            System.out.printf("BaseMod.openGui: for %s with id %s in %s at (%s, %s, %s)\n", this.base, id, world, x, y, z);
        }
        player.openGui((Object)this.base, id, world, x, y, z);
    }

    public Object getServerGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        Class<? extends Container> cls;
        if (this.debugGui) {
            System.out.printf("BaseMod.getServerGuiElement: for id %s\n", id);
        }
        Object result = (cls = this.containerClasses.get(id)) != null ? this.createGuiElement(cls, player, world, x, y, z) : this.getGuiContainer(id, player, world, x, y, z);
        if (this.debugGui) {
            System.out.printf("BaseMod.getServerGuiElement: Returning %s\n", result);
        }
        return result;
    }

    Container getGuiContainer(int id, EntityPlayer player, World world, int x, int y, int z) {
        System.out.printf("%s: BaseMod.getGuiContainer: No Container class found for gui id %d\n", this, id);
        return null;
    }

    public Object getClientGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        return null;
    }

    Object createGuiElement(Class cls, EntityPlayer player, World world, int x, int y, int z) {
        try {
            try {
                if (this.debugGui) {
                    System.out.printf("BaseMod.createGuiElement: Invoking create method of %s for %s in %s\n", cls, player, world);
                }
                return cls.getMethod("create", EntityPlayer.class, World.class, Integer.TYPE, Integer.TYPE, Integer.TYPE).invoke(null, player, world, x, y, z);
            }
            catch (NoSuchMethodException e) {
                if (this.debugGui) {
                    System.out.printf("BaseMod.createGuiElement: Invoking constructor of %s\n", cls);
                }
                return cls.getConstructor(EntityPlayer.class, World.class, Integer.TYPE, Integer.TYPE, Integer.TYPE).newInstance(player, world, x, y, z);
            }
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            System.out.printf("BaseMod.createGuiElement: %s: %s\n", e, cause);
            if (cause != null) {
                cause.printStackTrace();
            } else {
                e.printStackTrace();
            }
            return null;
        }
    }

    static interface IBlock {
        public void setRenderType(int var1);

        public String getQualifiedRendererClassName();
    }
}

