/*
 * Decompiled with CFR 0.152.
 */
package gcewing.lighting;

import gcewing.lighting.BaseConfiguration;
import gcewing.lighting.BlockFloodlight;
import gcewing.lighting.BlockFloodlightBeam;
import gcewing.lighting.GregsLighting;
import gcewing.lighting.TEFloodlightBeam;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class Floodlight {
    public static int maxRange = 64;
    public static boolean debugBeamBlocks = false;
    public static boolean debugBeamBlockPlacement = false;

    public static void configure(BaseConfiguration config) {
        maxRange = config.getInteger("options", "maxFloodlightRange", maxRange);
        debugBeamBlocks = config.getBoolean("options", "debugBeamBlocks", false);
    }

    public static void updateBeams(World world, int x, int y, int z) {
        if (debugBeamBlocks) {
            System.out.printf("Floodlight.updateBeams at (%d,%d,%d)\n", x, y, z);
        }
        for (int i = 0; i < 6; ++i) {
            Floodlight.updateBeamInDirection(world, x, y, z, ForgeDirection.getOrientation((int)i));
        }
    }

    static void updateBeamInDirection(World world, int x, int y, int z, ForgeDirection dir) {
        if (debugBeamBlocks) {
            System.out.printf("Floodlight.updateBeamInDirection %s from (%d,%d,%d) in %s\n", dir, x, y, z, world);
        }
        int intensity = Floodlight.findSourceIntensity(world, x, y, z, dir);
        Floodlight.propagateBeam(world, x, y, z, dir, intensity, 0);
    }

    static int findSourceIntensity(World world, int x, int y, int z, ForgeDirection dir) {
        if (debugBeamBlocks) {
            System.out.printf("Floodlight.findSourceIntensity %s from (%d,%d,%d)\n", dir, x, y, z);
        }
        int h = world.func_72800_K();
        for (int i = 1; i <= maxRange; ++i) {
            int intensity;
            int sx = x - i * dir.offsetX;
            int sy = y - i * dir.offsetY;
            int sz = z - i * dir.offsetZ;
            if (debugBeamBlocks) {
                System.out.printf("Floodlight.findSourceIntensity: Checking (%d,%d,%d)\n", sx, sy, sz);
            }
            if (sy < 0 || sy >= h) {
                if (debugBeamBlocks) {
                    System.out.printf("Floodlight.findSourceIntensity: Reached edge of map, returning 0\n", new Object[0]);
                }
                return 0;
            }
            Block block = Floodlight.getBlock(world, sx, sy, sz);
            if (block == null) {
                if (debugBeamBlocks) {
                    System.out.printf("Floodlight.findSourceIntensity: Found air, returning 0\n", new Object[0]);
                }
                return 0;
            }
            if (debugBeamBlocks) {
                System.out.printf("Floodlight.findSourceIntensity: Found %s\n", block.func_71931_t());
            }
            if (block instanceof BlockFloodlight) {
                if (debugBeamBlocks) {
                    System.out.printf("Floodlight.findSourceIntensity: Found floodlight\n", new Object[0]);
                }
                if (((BlockFloodlight)block).isActiveInDirection(world, sx, sy, sz, dir)) {
                    int result = maxRange + 1 - i;
                    if (debugBeamBlocks) {
                        System.out.printf("Floodlight.findSourceIntensity: Is active, returning %d\n", result);
                    }
                    return result;
                }
            }
            if (block instanceof BlockFloodlightBeam && (intensity = Floodlight.beamIntensity(world, sx, sy, sz, dir)) > 0) {
                int result = intensity - i;
                if (debugBeamBlocks) {
                    System.out.printf("Floodlight.findSourceIntensity: Found beam block, returning %d\n", result);
                }
                return result;
            }
            if (!block.func_71926_d()) continue;
            if (debugBeamBlocks) {
                System.out.printf("Floodlight.findSourceIntensity: Found opaque block, returning 0\n", new Object[0]);
            }
            return 0;
        }
        return 0;
    }

    public static void propagateBeam(World world, int x, int y, int z, ForgeDirection dir, int intensity, int start) {
        if (debugBeamBlocks) {
            System.out.printf("Floodlight.propagateBeam %s from (%d,%d,%d) + %d with intensity %d\n", dir, x, y, z, start, intensity);
        }
        int h = world.func_72800_K();
        for (int i = start; i < maxRange; ++i) {
            int bx = x + i * dir.offsetX;
            int by = y + i * dir.offsetY;
            int bz = z + i * dir.offsetZ;
            if (debugBeamBlocks) {
                System.out.printf("Floodlight.propagateBeam: Checking (%d,%d,%d)\n", bx, by, bz);
            }
            if (by < 0 || by >= h) {
                if (debugBeamBlocks) {
                    System.out.printf("Floodlight.propagateBeam: Reached edge of map\n", new Object[0]);
                }
                return;
            }
            Block block = Floodlight.getBlock(world, bx, by, bz);
            if (block != null && block.func_71926_d()) {
                if (debugBeamBlocks) {
                    System.out.printf("Floodlight.propagateBeam: Found opaque block\n", new Object[0]);
                }
                return;
            }
            if (block != null && !(block instanceof BlockFloodlightBeam) || Floodlight.setBeamIntensity(world, bx, by, bz, dir, intensity - i) || i == start) continue;
            if (debugBeamBlocks) {
                System.out.printf("Floodlight.propagateBeam: Intensity already correct\n", new Object[0]);
            }
            return;
        }
    }

    static Block getBlock(World world, int x, int y, int z) {
        return Block.field_71973_m[world.func_72798_a(x, y, z)];
    }

    static int beamIntensity(World world, int x, int y, int z, ForgeDirection dir) {
        TEFloodlightBeam te = Floodlight.getBeamTileEntity(world, x, y, z);
        if (te != null) {
            return te.getIntensity(dir);
        }
        return 0;
    }

    static boolean setBeamIntensity(World world, int x, int y, int z, ForgeDirection dir, int intensity) {
        TEFloodlightBeam te;
        Object block;
        boolean changed = false;
        if (intensity < 0) {
            intensity = 0;
        }
        if (debugBeamBlocks) {
            System.out.printf("Floodlight.setBeamIntensity %s at (%d,%d,%d) to %d\n", dir, x, y, z, intensity);
        }
        if ((block = Floodlight.getBlock(world, x, y, z)) == null) {
            if (intensity == 0) {
                return false;
            }
            if (debugBeamBlocks || debugBeamBlockPlacement) {
                System.out.printf("Floodlight.setBeamIntensity: Placing beam block at (%d,%d,%d)\n", x, y, z);
            }
            block = GregsLighting.floodlightBeam;
            world.func_72832_d(x, y, z, block.field_71990_ca, 0, 0);
            world.func_72845_h(x, y, z);
        }
        if ((te = Floodlight.getBeamTileEntity(world, x, y, z)) != null) {
            if (debugBeamBlocks) {
                System.out.printf("Floodlight.setBeamIntensity: Intensities before = %d, %d, %d, %d, %d, %d\n", te.intensity[0], te.intensity[1], te.intensity[2], te.intensity[3], te.intensity[4], te.intensity[5]);
            }
            changed = te.setIntensity(dir, intensity);
            if (debugBeamBlocks) {
                System.out.printf("Floodlight.setBeamIntensity: Intensities after = %d, %d, %d, %d, %d, %d\n", te.intensity[0], te.intensity[1], te.intensity[2], te.intensity[3], te.intensity[4], te.intensity[5]);
            }
            if (te.allIntensitiesZero()) {
                if (debugBeamBlocks || debugBeamBlockPlacement) {
                    System.out.printf("Floodlight.setBeamIntensity: Removing beam block at (%d,%d,%d)\n", x, y, z);
                }
                world.func_72832_d(x, y, z, 0, 0, 0);
                world.func_72845_h(x, y, z);
            }
        }
        return changed;
    }

    static TEFloodlightBeam getBeamTileEntity(World world, int x, int y, int z) {
        TileEntity te = world.func_72796_p(x, y, z);
        if (te instanceof TEFloodlightBeam) {
            return (TEFloodlightBeam)te;
        }
        return null;
    }
}

