/*
 * Decompiled with CFR 0.152.
 */
package gcewing.lighting;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import gcewing.lighting.BaseMod;
import gcewing.lighting.BaseModClient;
import gcewing.lighting.BlockFloodlight;
import gcewing.lighting.BlockFloodlightBeam;
import gcewing.lighting.BlockFloodlightCarbide;
import gcewing.lighting.ContainerFLC;
import gcewing.lighting.Floodlight;
import gcewing.lighting.GregsLightingClient;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

@Mod(modid="GregsLighting", name="Greg's Lighting", version="1.9.0")
@NetworkMod(clientSideRequired=true, serverSideRequired=true, versionBounds="[1.9,1.10)")
public class GregsLighting
extends BaseMod {
    public static final String modName = "GregsLighting";
    public static final int guiFloodlightCarbide = 1;
    public static BlockFloodlightCarbide floodlightCarbide;
    public static BlockFloodlight floodlight;
    public static BlockFloodlightBeam floodlightBeam;
    public static Item calciumCarbide;
    public static Item bonemealAndCharcoal;
    public static Item gaslightMantle;
    public static Item gasNozzle;
    public static Item glowingIngot;
    public static Item ic2Filament;
    public static Item ic2Bulb;
    public static GregsLighting mod;

    public GregsLighting() {
        mod = this;
    }

    @Override
    BaseModClient initClient() {
        return new GregsLightingClient(this);
    }

    @Override
    @Mod.PreInit
    public void preInit(FMLPreInitializationEvent e) {
        super.preInit(e);
        Floodlight.configure(this.config);
    }

    @Override
    @Mod.Init
    public void init(FMLInitializationEvent e) {
        super.init(e);
    }

    @Override
    @Mod.PostInit
    public void postInit(FMLPostInitializationEvent e) {
        super.postInit(e);
    }

    @Override
    void registerOther() {
        this.registerIC2();
    }

    @Override
    void registerBlocks() {
        floodlightCarbide = this.newBlock("carbideFloodlight", BlockFloodlightCarbide.class, "Carbide Floodlight");
        floodlightCarbide.func_71848_c(1.5f).func_71849_a(CreativeTabs.field_78026_f);
        floodlightBeam = this.newBlock("floodlightBeam", BlockFloodlightBeam.class, "[Floodlight Beam]");
        floodlight = this.newBlock("floodlight", BlockFloodlight.class, "Floodlight");
        floodlight.func_71848_c(1.5f).func_71849_a(CreativeTabs.field_78026_f);
    }

    @Override
    void registerItems() {
        calciumCarbide = this.newItem("calciumCarbide", "Calcium Carbide");
        bonemealAndCharcoal = this.newItem("bonemealAndCharcoal", "Bonemeal-Charcoal Mixture");
        gaslightMantle = this.newItem("gaslightMantle", "Gaslight Mantle");
        ic2Bulb = this.newItem("glowstoneBulb", "IC2 Floodlight Bulb");
        gasNozzle = this.newItem("gasNozzle", "Gas Nozzle");
        glowingIngot = this.newItem("glowingIngot", "Glowing Alloy Ingot");
        ic2Filament = this.newItem("ic2FilamentAssembly", "IC2 Filament Assembly");
    }

    @Override
    void registerRecipes() {
        this.newShapelessRecipe(bonemealAndCharcoal, 1, new ItemStack(Item.field_77756_aW, 1, 15), new ItemStack(Item.field_77705_m, 1, 1));
        if (this.config.getBoolean("options", "enableSimpleFloodlight", true)) {
            this.newRecipe((Block)floodlight, 1, "IrI", "IgI", "GGG", Character.valueOf('I'), Item.field_77703_o, Character.valueOf('r'), Item.field_77767_aC, Character.valueOf('g'), glowingIngot, Character.valueOf('G'), Block.field_71946_M);
            this.newRecipe(glowingIngot, 1, "GGG", "GgG", "GGG", Character.valueOf('G'), Block.field_72014_bd, Character.valueOf('g'), Item.field_77733_bq);
        }
        this.newSmeltingRecipe(calciumCarbide, 1, bonemealAndCharcoal);
        this.newRecipe(gasNozzle, 4, "I", "I", Character.valueOf('I'), Item.field_77703_o);
        this.newRecipe((Block)floodlightCarbide, 1, "CrC", "CnC", "GGG", Character.valueOf('C'), Block.field_71978_w, Character.valueOf('r'), Item.field_77767_aC, Character.valueOf('n'), gasNozzle, Character.valueOf('G'), Block.field_71946_M);
    }

    @Override
    void registerContainers() {
        this.addContainer(1, ContainerFLC.class);
    }

    void registerIC2() {
        if (Loader.isModLoaded((String)"IC2")) {
            System.out.printf("GregsLighting: Linking to IC2\n", new Object[0]);
            try {
                Class<?> cls = Class.forName("gcewing.lighting.ic2.GregsLightingIC2");
                Method init = cls.getMethod("init", new Class[0]);
                init.invoke(null, new Object[0]);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e.getCause());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void openGuiFloodlightCarbide(World world, int x, int y, int z, EntityPlayer player) {
        mod.openGui(player, 1, world, x, y, z);
    }

    public static boolean explodeMachineAt(World world, int x, int y, int z) {
        try {
            Class<?> mainIC2Class = Class.forName("ic2.common.IC2");
            mainIC2Class.getMethod("explodeMachineAt", World.class, Integer.TYPE, Integer.TYPE, Integer.TYPE).invoke(null, world, x, y, z);
            return true;
        }
        catch (Exception e) {
            System.out.printf("GregsLighting.explodeMachineAt: %s\n", e);
            return false;
        }
    }
}

