/*
 * Decompiled with CFR 0.152.
 */
package ic2classic.core;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import ic2classic.core.Ic2Items;
import ic2classic.core.block.machine.tileentity.TileEntityCompressor;
import ic2classic.core.block.machine.tileentity.TileEntityMatter;
import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Achievement;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatBase;
import net.minecraftforge.common.AchievementPage;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;

public class IC2Achievements {
    public HashMap<String, Achievement> achievementList = new HashMap();
    private int achievementBaseX = -4;
    private int achievementBaseY = -5;

    public IC2Achievements() {
        this.registerAchievement("acquireResin", 2, 0, Ic2Items.resin, AchievementList.field_76005_g, false);
        if (Ic2Items.copperOre != null || Ic2Items.tinOre != null || Ic2Items.uraniumOre != null) {
            this.registerAchievement("mineOre", 4, 0, Ic2Items.copperOre == null ? Ic2Items.tinOre : (Ic2Items.tinOre == null ? Ic2Items.uraniumOre : Ic2Items.copperOre), AchievementList.field_76012_o, false);
        }
        this.registerAchievement("acquireRefinedIron", 0, 0, Ic2Items.refinedIronIngot, AchievementList.field_76016_k, false);
        this.registerAchievement("buildCable", 0, 2, Ic2Items.insulatedCopperCableItem, "acquireRefinedIron", false);
        this.registerAchievement("buildGenerator", 6, 2, Ic2Items.generator, "buildCable", false);
        this.registerAchievement("buildMacerator", 6, 0, Ic2Items.macerator, "buildGenerator", false);
        this.registerAchievement("buildCoalDiamond", 8, 0, Ic2Items.industrialDiamond, "buildMacerator", false);
        this.registerAchievement("buildElecFurnace", 8, 2, Ic2Items.electroFurnace, "buildGenerator", false);
        this.registerAchievement("buildIndFurnace", 10, 2, Ic2Items.inductionFurnace, "buildElecFurnace", false);
        this.registerAchievement("buildCompressor", 4, 4, Ic2Items.compressor, "buildGenerator", false);
        this.registerAchievement("compressUranium", 2, 4, Ic2Items.uraniumIngot, "buildCompressor", false);
        this.registerAchievement("dieFromOwnNuke", 0, 4, Ic2Items.nuke, "compressUranium", true);
        this.registerAchievement("buildExtractor", 8, 4, Ic2Items.extractor, "buildGenerator", false);
        this.registerAchievement("buildBatBox", 6, 6, Ic2Items.batBox, "buildGenerator", false);
        this.registerAchievement("buildDrill", 8, 6, Ic2Items.miningDrill, "buildBatBox", false);
        this.registerAchievement("buildDDrill", 10, 6, Ic2Items.diamondDrill, "buildDrill", false);
        this.registerAchievement("buildChainsaw", 4, 6, Ic2Items.chainsaw, "buildBatBox", false);
        this.registerAchievement("killCreeperChainsaw", 2, 6, Ic2Items.chainsaw, "buildChainsaw", true);
        this.registerAchievement("buildMFE", 6, 8, Ic2Items.mfeUnit, "buildBatBox", false);
        this.registerAchievement("buildMassFab", 8, 8, Ic2Items.massFabricator, "buildBatBox", false);
        this.registerAchievement("acquireMatter", 10, 8, Ic2Items.matter, "buildMassFab", false);
        this.registerAchievement("buildQArmor", 12, 8, Ic2Items.quantumBodyarmor, "acquireMatter", false);
        this.registerAchievement("starveWithQHelmet", 14, 8, Ic2Items.quantumHelmet, "buildQArmor", true);
        this.registerAchievement("buildMiningLaser", 4, 8, Ic2Items.miningLaser, "buildMFE", false);
        this.registerAchievement("killDragonMiningLaser", 2, 8, Ic2Items.miningLaser, "buildMiningLaser", true);
        this.registerAchievement("buildMFS", 6, 10, Ic2Items.mfsUnit, "buildMFE", false);
        this.registerAchievement("buildTeleporter", 4, 10, Ic2Items.teleporter, "buildMFS", false);
        this.registerAchievement("teleportFarAway", 2, 10, Ic2Items.teleporter, "buildTeleporter", true);
        this.registerAchievement("buildTerraformer", 8, 10, Ic2Items.terraformer, "buildMFS", false);
        this.registerAchievement("terraformEndCultivation", 10, 10, Ic2Items.cultivationTerraformerBlueprint, "buildTerraformer", true);
        AchievementPage.registerAchievementPage((AchievementPage)new AchievementPage("IndustrialCraft 2", this.achievementList.values().toArray(new Achievement[this.achievementList.size()])));
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    public Achievement registerAchievement(String textId, int x, int y, ItemStack icon, Achievement requirement, boolean special) {
        Achievement achievement = new Achievement("ic2classic " + textId, textId, this.achievementBaseX + x, this.achievementBaseY + y, icon, requirement);
        if (special) {
            achievement.func_75987_b();
        }
        achievement.func_75971_g();
        this.achievementList.put(textId, achievement);
        return achievement;
    }

    public Achievement registerAchievement(String textId, int x, int y, Item icon, String requirement, boolean special) {
        return this.registerAchievement(textId, x, y, new ItemStack(icon), requirement, special);
    }

    public Achievement registerAchievement(String textId, int x, int y, Item icon, Achievement requirement, boolean special) {
        return this.registerAchievement(textId, x, y, new ItemStack(icon), requirement, special);
    }

    public Achievement registerAchievement(String textId, int x, int y, ItemStack icon, String requirement, boolean special) {
        Achievement achievement = new Achievement("ic2classic " + textId, textId, this.achievementBaseX + x, this.achievementBaseY + y, icon, this.getAchievement(requirement));
        if (special) {
            achievement.func_75987_b();
        }
        achievement.func_75971_g();
        this.achievementList.put(textId, achievement);
        return achievement;
    }

    public void issueAchievement(EntityPlayer entityplayer, String textId) {
        if (this.achievementList.containsKey(textId)) {
            entityplayer.func_71029_a((StatBase)this.achievementList.get(textId));
        }
    }

    public Achievement getAchievement(String textId) {
        if (this.achievementList.containsKey(textId)) {
            return this.achievementList.get(textId);
        }
        return null;
    }

    @SubscribeEvent
    public void onCraft(PlayerEvent.ItemCraftedEvent evt) {
        ItemStack itemstack = evt.crafting;
        EntityPlayer entityplayer = evt.player;
        if (itemstack.func_77969_a(Ic2Items.generator)) {
            this.issueAchievement(entityplayer, "buildGenerator");
        } else if (itemstack.func_77973_b() == Ic2Items.insulatedCopperCableItem.func_77973_b()) {
            this.issueAchievement(entityplayer, "buildCable");
        } else if (itemstack.func_77969_a(Ic2Items.macerator)) {
            this.issueAchievement(entityplayer, "buildMacerator");
        } else if (itemstack.func_77969_a(Ic2Items.electroFurnace)) {
            this.issueAchievement(entityplayer, "buildElecFurnace");
        } else if (itemstack.func_77969_a(Ic2Items.compressor)) {
            this.issueAchievement(entityplayer, "buildCompressor");
        } else if (itemstack.func_77969_a(Ic2Items.batBox)) {
            this.issueAchievement(entityplayer, "buildBatBox");
        } else if (itemstack.func_77969_a(Ic2Items.mfeUnit)) {
            this.issueAchievement(entityplayer, "buildMFE");
        } else if (itemstack.func_77969_a(Ic2Items.teleporter)) {
            this.issueAchievement(entityplayer, "buildTeleporter");
        } else if (itemstack.func_77969_a(Ic2Items.massFabricator)) {
            this.issueAchievement(entityplayer, "buildMassFab");
        } else if (itemstack.func_77973_b() == Ic2Items.quantumBodyarmor || itemstack.func_77973_b() == Ic2Items.quantumBoots || itemstack.func_77973_b() == Ic2Items.quantumHelmet || itemstack.func_77973_b() == Ic2Items.quantumLeggings) {
            this.issueAchievement(entityplayer, "buildQArmor");
        } else if (itemstack.func_77969_a(Ic2Items.extractor)) {
            this.issueAchievement(entityplayer, "buildExtractor");
        } else if (itemstack.func_77973_b() == Ic2Items.miningDrill) {
            this.issueAchievement(entityplayer, "buildDrill");
        } else if (itemstack.func_77973_b() == Ic2Items.diamondDrill) {
            this.issueAchievement(entityplayer, "buildDDrill");
        } else if (itemstack.func_77973_b() == Ic2Items.chainsaw) {
            this.issueAchievement(entityplayer, "buildChainsaw");
        } else if (itemstack.func_77973_b() == Ic2Items.miningLaser) {
            this.issueAchievement(entityplayer, "buildMiningLaser");
        } else if (itemstack.func_77969_a(Ic2Items.mfsUnit)) {
            this.issueAchievement(entityplayer, "buildMFS");
        } else if (itemstack.func_77969_a(Ic2Items.terraformer)) {
            this.issueAchievement(entityplayer, "buildTerraformer");
        } else if (itemstack.func_77973_b() == Ic2Items.coalChunk) {
            this.issueAchievement(entityplayer, "buildCoalDiamond");
        } else if (itemstack.func_77969_a(Ic2Items.inductionFurnace)) {
            this.issueAchievement(entityplayer, "buildIndFurnace");
        }
    }

    public void onSmelting(EntityPlayer entityplayer, ItemStack itemstack) {
        if (itemstack.func_77973_b() == Ic2Items.refinedIronIngot) {
            this.issueAchievement(entityplayer, "acquireRefinedIron");
        }
    }

    public void onMachineOp(EntityPlayer entityplayer, ItemStack itemstack, IInventory inventory) {
        if (inventory instanceof TileEntityCompressor && itemstack.func_77973_b() == Ic2Items.uraniumIngot) {
            this.issueAchievement(entityplayer, "compressUranium");
        } else if (inventory instanceof TileEntityMatter && itemstack.func_77973_b() == Ic2Items.matter) {
            this.issueAchievement(entityplayer, "acquireMatter");
        }
    }

    @SubscribeEvent
    public void onItemPickup(EntityItemPickupEvent event) {
        if (Ic2Items.copperOre != null && event.item.func_92059_d().func_77969_a(Ic2Items.copperOre) || Ic2Items.tinOre != null && event.item.func_92059_d().func_77969_a(Ic2Items.tinOre) || Ic2Items.uraniumDrop != null && event.item.func_92059_d().func_77973_b() == Ic2Items.uraniumDrop) {
            this.issueAchievement(event.entityPlayer, "mineOre");
        }
    }
}

