/*
 * Decompiled with CFR 0.152.
 */
package ic2classic.core.block.machine.tileentity;

import cpw.mods.fml.common.eventhandler.Event;
import ic2classic.core.ContainerIC2;
import ic2classic.core.IC2;
import ic2classic.core.IHasGui;
import ic2classic.core.Ic2Items;
import ic2classic.core.audio.AudioSource;
import ic2classic.core.audio.PositionSpec;
import ic2classic.core.block.generator.tileentity.TileEntityGeoGenerator;
import ic2classic.core.block.machine.ContainerPump;
import ic2classic.core.block.machine.tileentity.TileEntityElecMachine;
import ic2classic.core.util.StackUtil;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.MovingObjectPosition;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.FillBucketEvent;

public class TileEntityPump
extends TileEntityElecMachine
implements IHasGui {
    public int soundTicker = IC2.random.nextInt(64);
    public short pumpCharge = 0;
    private AudioSource audioSource;

    public TileEntityPump() {
        super(2, 1, 200, 32);
    }

    @Override
    public String func_145825_b() {
        return "Pump";
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        boolean needsInvUpdate = false;
        if (this.energy > 0 && !this.isPumpReady()) {
            --this.energy;
            this.pumpCharge = (short)(this.pumpCharge + 1);
        }
        if (this.energy <= this.maxEnergy) {
            needsInvUpdate = this.provideEnergy();
        }
        if (this.isPumpReady()) {
            needsInvUpdate = this.pump();
        }
        if (this.getActive() == this.isPumpReady() && this.energy > 0) {
            this.setActive(!this.getActive());
        }
        if (needsInvUpdate) {
            this.func_70296_d();
        }
    }

    @Override
    public void onUnloaded() {
        if (IC2.platform.isRendering() && this.audioSource != null) {
            IC2.audioManager.removeSources(this);
            this.audioSource = null;
        }
        super.onUnloaded();
    }

    public boolean pump() {
        if (!this.canHarvest()) {
            return false;
        }
        if (this.isWaterBelow() || this.isLavaBelow()) {
            Block id = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
            this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
            if (id == Blocks.field_150358_i) {
                id = Blocks.field_150355_j;
            }
            if (id == Blocks.field_150356_k) {
                id = Blocks.field_150353_l;
            }
            return this.pumpThis(id);
        }
        if (this.inventory[0] != null && this.inventory[0].func_77973_b() == Items.field_151133_ar) {
            ItemStack customBucket = new ItemStack(Items.field_151133_ar);
            FillBucketEvent event = new FillBucketEvent(null, customBucket, this.field_145850_b, new MovingObjectPosition(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, 1, this.field_145850_b.func_82732_R().func_72345_a((double)this.field_145851_c, (double)(this.field_145848_d - 1), (double)this.field_145849_e)));
            MinecraftForge.EVENT_BUS.post((Event)event);
            customBucket = event.result;
            if (customBucket != null && customBucket.func_77973_b() != Items.field_151133_ar) {
                ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
                drops.add(customBucket);
                StackUtil.distributeDrop(this, drops);
                --this.inventory[0].field_77994_a;
                if (this.inventory[0].field_77994_a <= 0) {
                    this.inventory[0] = null;
                }
                this.pumpCharge = 0;
                return true;
            }
        }
        return false;
    }

    public boolean isWaterBelow() {
        Block b = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
        return b == Blocks.field_150355_j || b == Blocks.field_150358_i;
    }

    public boolean isLavaBelow() {
        Block b = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
        return b == Blocks.field_150353_l;
    }

    public boolean pumpThis(Block id) {
        if (id == Blocks.field_150353_l && this.deliverLavaToGeo()) {
            this.pumpCharge = 0;
            return true;
        }
        if (this.inventory[0] != null && this.inventory[0].func_77973_b() == Items.field_151133_ar) {
            if (id == Blocks.field_150355_j) {
                this.inventory[0] = new ItemStack(Items.field_151131_as);
            }
            if (id == Blocks.field_150353_l) {
                this.inventory[0] = new ItemStack(Items.field_151129_at);
            }
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
            drops.add(this.inventory[0]);
            StackUtil.distributeDrop(this, drops);
            this.inventory[0] = null;
            this.pumpCharge = 0;
            return true;
        }
        if (this.inventory[0] != null && this.inventory[0].func_77973_b() == Ic2Items.cell) {
            ItemStack drop = null;
            if (id == Blocks.field_150355_j) {
                drop = new ItemStack(Ic2Items.waterCell);
            }
            if (id == Blocks.field_150353_l) {
                drop = new ItemStack(Ic2Items.lavaCell);
            }
            --this.inventory[0].field_77994_a;
            if (this.inventory[0].field_77994_a <= 0) {
                this.inventory[0] = null;
            }
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
            drops.add(drop);
            StackUtil.distributeDrop(this, drops);
            this.pumpCharge = 0;
            return true;
        }
        this.pumpCharge = 0;
        return this.putInChestBucket(id);
    }

    public boolean putInChestBucket(Block id) {
        return this.putInChestBucket(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e, id) || this.putInChestBucket(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, id) || this.putInChestBucket(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e, id) || this.putInChestBucket(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e, id) || this.putInChestBucket(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1, id) || this.putInChestBucket(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1, id);
    }

    public boolean putInChestBucket(int x, int y, int z, Block id) {
        if (!(this.field_145850_b.func_147438_o(x, y, z) instanceof TileEntityChest)) {
            return false;
        }
        TileEntityChest chest = (TileEntityChest)this.field_145850_b.func_147438_o(x, y, z);
        int i = 0;
        while (i < chest.func_70302_i_()) {
            if (chest.func_70301_a(i) != null && chest.func_70301_a(i).func_77973_b() == Items.field_151133_ar) {
                if (id == Blocks.field_150355_j) {
                    chest.func_70299_a(i, new ItemStack(Items.field_151131_as));
                }
                if (id == Blocks.field_150353_l) {
                    chest.func_70299_a(i, new ItemStack(Items.field_151129_at));
                }
                return true;
            }
            ++i;
        }
        return false;
    }

    public void fountain() {
        if (this.field_145850_b.func_72820_D() % 10L == 0L) {
            this.pumpCharge = (short)(this.pumpCharge - 1);
        }
        int y = 0;
        int x = 1;
        while (x < 4) {
            if (this.field_145850_b.func_147437_c(this.field_145851_c, this.field_145848_d + x, this.field_145849_e) || this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d + x, this.field_145849_e) == Blocks.field_150358_i) {
                y = x;
            }
            ++x;
        }
        if (y != 0) {
            this.field_145850_b.func_147465_d(this.field_145851_c, this.field_145848_d + y, this.field_145849_e, (Block)Blocks.field_150358_i, 1, 3);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.pumpCharge = nbttagcompound.func_74765_d("pumpCharge");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74777_a("pumpCharge", this.pumpCharge);
    }

    public boolean isPumpReady() {
        return this.pumpCharge >= 200;
    }

    public boolean canHarvest() {
        if (!this.isPumpReady()) {
            return false;
        }
        return this.inventory[0] != null && (this.inventory[0].func_77973_b() == Ic2Items.cell || this.inventory[0].func_77973_b() == Items.field_151133_ar) || this.isBucketInChestAvaible();
    }

    public boolean isBucketInChestAvaible() {
        return this.isBucketInChestAvaible(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e) || this.isBucketInChestAvaible(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e) || this.isBucketInChestAvaible(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e) || this.isBucketInChestAvaible(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e) || this.isBucketInChestAvaible(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1) || this.isBucketInChestAvaible(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1);
    }

    public boolean isBucketInChestAvaible(int x, int y, int z) {
        if (!(this.field_145850_b.func_147438_o(x, y, z) instanceof TileEntityChest)) {
            return false;
        }
        TileEntityChest chest = (TileEntityChest)this.field_145850_b.func_147438_o(x, y, z);
        int i = 0;
        while (i < chest.func_70302_i_()) {
            if (chest.func_70301_a(i) != null && chest.func_70301_a(i).func_77973_b() == Items.field_151133_ar) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean deliverLavaToGeo() {
        int lava = 3000;
        if (lava > 0 && this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e) instanceof TileEntityGeoGenerator) {
            lava = ((TileEntityGeoGenerator)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e)).distributeLava(lava);
        }
        if (lava > 0 && this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e) instanceof TileEntityGeoGenerator) {
            lava = ((TileEntityGeoGenerator)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e)).distributeLava(lava);
        }
        if (lava > 0 && this.field_145850_b.func_147438_o(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e) instanceof TileEntityGeoGenerator) {
            lava = ((TileEntityGeoGenerator)this.field_145850_b.func_147438_o(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e)).distributeLava(lava);
        }
        if (lava > 0 && this.field_145850_b.func_147438_o(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e) instanceof TileEntityGeoGenerator) {
            lava = ((TileEntityGeoGenerator)this.field_145850_b.func_147438_o(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e)).distributeLava(lava);
        }
        if (lava > 0 && this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1) instanceof TileEntityGeoGenerator) {
            lava = ((TileEntityGeoGenerator)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1)).distributeLava(lava);
        }
        if (lava > 0 && this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1) instanceof TileEntityGeoGenerator) {
            lava = ((TileEntityGeoGenerator)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1)).distributeLava(lava);
        }
        return lava < 2980;
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerPump(entityPlayer, this);
    }

    @Override
    public String getGuiClassName(EntityPlayer entityPlayer) {
        return "block.machine.gui.GuiPump";
    }

    @Override
    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    @Override
    public void readDescriptionNBT(NBTTagCompound tag) {
        boolean prevActive = this.getActive();
        super.readDescriptionNBT(tag);
        if (prevActive != this.getActive()) {
            if (this.audioSource == null) {
                this.audioSource = IC2.audioManager.createSource(this, PositionSpec.Center, "Machines/PumpOp.ogg", true, false, IC2.audioManager.defaultVolume);
            }
            if (this.getActive()) {
                if (this.audioSource != null) {
                    this.audioSource.play();
                }
            } else if (this.audioSource != null) {
                this.audioSource.stop();
            }
        }
    }

    public int[] func_94128_d(int var1) {
        return new int[]{var1 == 0 ? 1 : 0};
    }
}

