/*
 * Decompiled with CFR 0.152.
 */
package ic2classic.core.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2classic.api.IElectricItem;
import ic2classic.core.IC2;
import ic2classic.core.item.ItemIC2;
import ic2classic.core.util.StackUtil;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public abstract class ElectricItem
extends ItemIC2
implements IElectricItem {
    public int maxCharge;
    public int transferLimit = 100;
    public int tier = 1;

    public static int charge(ItemStack itemStack, int amount, int tier, boolean ignoreTransferLimit, boolean simulate) {
        if (!(itemStack.func_77973_b() instanceof IElectricItem) || amount < 0 || itemStack.field_77994_a > 1) {
            return 0;
        }
        IElectricItem item = (IElectricItem)itemStack.func_77973_b();
        if (item.getTier() > tier) {
            return 0;
        }
        if (amount > item.getTransferLimit() && !ignoreTransferLimit) {
            amount = item.getTransferLimit();
        }
        NBTTagCompound nbtData = StackUtil.getOrCreateNbtData(itemStack);
        int charge = nbtData.func_74762_e("charge");
        if (amount > item.getMaxCharge() - charge) {
            amount = item.getMaxCharge() - charge;
        }
        charge += amount;
        if (!simulate) {
            nbtData.func_74768_a("charge", charge);
            itemStack.func_150996_a(charge > 0 ? item.getChargedItemId() : item.getEmptyItemId());
            if (itemStack.func_77973_b() instanceof IElectricItem) {
                item = (IElectricItem)itemStack.func_77973_b();
                if (itemStack.func_77958_k() > 2) {
                    itemStack.func_77964_b(1 + (item.getMaxCharge() - charge) * (itemStack.func_77958_k() - 2) / item.getMaxCharge());
                } else {
                    itemStack.func_77964_b(0);
                }
            } else {
                itemStack.func_77964_b(0);
            }
        }
        return amount;
    }

    public static int discharge(ItemStack itemStack, int amount, int tier, boolean ignoreTransferLimit, boolean simulate) {
        NBTTagCompound nbtData;
        int charge;
        if (!(itemStack.func_77973_b() instanceof IElectricItem) || amount < 0 || itemStack.field_77994_a > 1) {
            return 0;
        }
        IElectricItem item = (IElectricItem)itemStack.func_77973_b();
        if (item.getTier() > tier) {
            return 0;
        }
        if (amount > item.getTransferLimit() && !ignoreTransferLimit) {
            amount = item.getTransferLimit();
        }
        if (amount > (charge = (nbtData = StackUtil.getOrCreateNbtData(itemStack)).func_74762_e("charge"))) {
            amount = charge;
        }
        charge -= amount;
        if (!simulate) {
            nbtData.func_74768_a("charge", charge);
            itemStack.func_150996_a(charge > 0 ? item.getChargedItemId() : item.getEmptyItemId());
            if (itemStack.func_77973_b() instanceof IElectricItem) {
                item = (IElectricItem)itemStack.func_77973_b();
                if (itemStack.func_77958_k() > 2) {
                    itemStack.func_77964_b(1 + (item.getMaxCharge() - charge) * (itemStack.func_77958_k() - 2) / item.getMaxCharge());
                } else {
                    itemStack.func_77964_b(0);
                }
            } else {
                itemStack.func_77964_b(0);
            }
        }
        return amount;
    }

    public static boolean canUse(ItemStack itemStack, int amount) {
        NBTTagCompound nbtData = StackUtil.getOrCreateNbtData(itemStack);
        return nbtData.func_74762_e("charge") >= amount;
    }

    public static boolean use(ItemStack itemStack, int amount, EntityPlayer player) {
        if (IC2.platform.isSimulating() && itemStack.func_77973_b() instanceof IElectricItem) {
            ElectricItem.chargeFromArmor(itemStack, player);
            int transfer = ElectricItem.discharge(itemStack, amount, Integer.MAX_VALUE, true, true);
            if (transfer == amount) {
                ElectricItem.discharge(itemStack, amount, Integer.MAX_VALUE, true, false);
                ElectricItem.chargeFromArmor(itemStack, player);
                return true;
            }
        }
        return false;
    }

    public static void chargeFromArmor(ItemStack itemStack, EntityPlayer player) {
        if (!IC2.platform.isSimulating() || player == null || !(itemStack.func_77973_b() instanceof IElectricItem)) {
            return;
        }
        boolean inventoryChanged = false;
        int i = 0;
        while (i < 4) {
            IElectricItem armorItem;
            ItemStack armorItemStack = player.field_71071_by.field_70460_b[i];
            if (armorItemStack != null && armorItemStack.func_77973_b() instanceof IElectricItem && (armorItem = (IElectricItem)armorItemStack.func_77973_b()).canProvideEnergy() && armorItem.getTier() >= ((IElectricItem)itemStack.func_77973_b()).getTier()) {
                int transfer = ElectricItem.charge(itemStack, Integer.MAX_VALUE, Integer.MAX_VALUE, true, true);
                if ((transfer = ElectricItem.discharge(armorItemStack, transfer, Integer.MAX_VALUE, true, false)) > 0) {
                    ElectricItem.charge(itemStack, transfer, Integer.MAX_VALUE, true, false);
                    inventoryChanged = true;
                }
            }
            ++i;
        }
        if (inventoryChanged) {
            player.field_71070_bA.func_75142_b();
        }
    }

    public ElectricItem(int index) {
        super(index);
        this.func_77656_e(27);
        this.func_77625_d(1);
    }

    @Override
    public boolean canProvideEnergy() {
        return false;
    }

    @Override
    public Item getChargedItemId() {
        return this;
    }

    @Override
    public Item getEmptyItemId() {
        return this;
    }

    @Override
    public int getMaxCharge() {
        return this.maxCharge;
    }

    @Override
    public int getTier() {
        return this.tier;
    }

    @Override
    public int getTransferLimit() {
        return this.transferLimit;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item par1, CreativeTabs par2CreativeTabs, List itemList) {
        if (this.getChargedItemId() == this) {
            ItemStack charged = new ItemStack((Item)this, 1);
            ElectricItem.charge(charged, Integer.MAX_VALUE, Integer.MAX_VALUE, true, false);
            itemList.add(charged);
        }
        if (this.getEmptyItemId() == this) {
            itemList.add(new ItemStack((Item)this, 1, this.func_77612_l()));
        }
    }
}

