/*
 * Decompiled with CFR 0.152.
 */
package ic2classic.core.network;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import ic2classic.api.network.INetworkClientTileEntityEventListener;
import ic2classic.api.network.INetworkItemEventListener;
import ic2classic.core.IC2;
import ic2classic.core.IHasGui;
import ic2classic.core.item.IHandHeldInventory;
import ic2classic.core.item.armor.ItemArmorQuantumSuit;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.C17PacketCustomPayload;
import net.minecraft.network.play.server.S3FPacketCustomPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class NetworkManager {
    private static final AttributeKey<EntityPlayerMP> CHANNEL_TO_PLAYER_KEY = new AttributeKey("ic2classic player");

    public NetworkManager() {
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    @SubscribeEvent
    public void onConnectServerSide(FMLNetworkEvent.ServerConnectionFromClientEvent evt) {
        evt.manager.channel().attr(CHANNEL_TO_PLAYER_KEY).set((Object)((NetHandlerPlayServer)evt.handler).field_147369_b);
        evt.manager.channel().pipeline().addBefore("packet_handler", "ic2classic packet handler", (ChannelHandler)new ChannelInboundHandlerAdapter(){

            public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                if (!NetworkManager.this.handlePacketServer(ctx.channel(), msg)) {
                    ctx.fireChannelRead(msg);
                }
            }
        });
    }

    public boolean handlePacketServer(Channel channel, Object msg) {
        if (msg instanceof C17PacketCustomPayload && ((C17PacketCustomPayload)msg).func_149559_c().equals("ic2classic")) {
            this.onPacketDataServer(((C17PacketCustomPayload)msg).func_149558_e(), (EntityPlayerMP)channel.attr(CHANNEL_TO_PLAYER_KEY).get());
            return true;
        }
        return false;
    }

    public void initiateTileEntityEvent(TileEntity te, int event, boolean limitRange) {
        int maxDistance = limitRange ? 400 : MinecraftServer.func_71276_C().func_71203_ab().func_72372_a() + 16;
        World world = te.func_145831_w();
        S3FPacketCustomPayload packet = null;
        for (Object obj : world.field_73010_i) {
            EntityPlayerMP entityPlayer = (EntityPlayerMP)obj;
            int distanceX = te.field_145851_c - (int)entityPlayer.field_70165_t;
            int distanceZ = te.field_145849_e - (int)entityPlayer.field_70161_v;
            int distance = limitRange ? distanceX * distanceX + distanceZ * distanceZ : Math.max(Math.abs(distanceX), Math.abs(distanceZ));
            if (distance > maxDistance) continue;
            if (packet == null) {
                try {
                    ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                    DataOutputStream os = new DataOutputStream(buffer);
                    os.writeByte(1);
                    os.writeInt(world.field_73011_w.field_76574_g);
                    os.writeInt(te.field_145851_c);
                    os.writeInt(te.field_145848_d);
                    os.writeInt(te.field_145849_e);
                    os.writeInt(event);
                    os.close();
                    packet = new S3FPacketCustomPayload("ic2classic", buffer.toByteArray());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            entityPlayer.field_71135_a.field_147371_a.func_150725_a(packet, new GenericFutureListener[0]);
        }
    }

    public void initiateItemEvent(EntityPlayer player, ItemStack itemStack, int event, boolean limitRange) {
        if (player.func_146103_bH().getId().length() > 127) {
            return;
        }
        int maxDistance = limitRange ? 400 : MinecraftServer.func_71276_C().func_71203_ab().func_72372_a() + 16;
        S3FPacketCustomPayload packet = null;
        for (Object obj : player.field_70170_p.field_73010_i) {
            EntityPlayerMP entityPlayer = (EntityPlayerMP)obj;
            int distanceX = (int)player.field_70165_t - (int)entityPlayer.field_70165_t;
            int distanceZ = (int)player.field_70161_v - (int)entityPlayer.field_70161_v;
            int distance = limitRange ? distanceX * distanceX + distanceZ * distanceZ : Math.max(Math.abs(distanceX), Math.abs(distanceZ));
            if (distance > maxDistance) continue;
            if (packet == null) {
                try {
                    ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                    DataOutputStream os = new DataOutputStream(buffer);
                    os.writeByte(2);
                    os.writeByte(player.func_146103_bH().getId().length());
                    os.writeChars(player.func_146103_bH().getId());
                    os.writeInt(Item.func_150891_b((Item)itemStack.func_77973_b()));
                    os.writeInt(itemStack.func_77960_j());
                    os.writeInt(event);
                    os.close();
                    packet = new S3FPacketCustomPayload("ic2classic", buffer.toByteArray());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            entityPlayer.field_71135_a.field_147371_a.func_150725_a(packet, new GenericFutureListener[0]);
        }
    }

    public void initiateClientItemEvent(ItemStack itemStack, int event) {
    }

    public void initiateClientTileEntityEvent(TileEntity te, int event) {
    }

    public void initiateGuiDisplay(EntityPlayerMP entityPlayer, IHasGui inventory, int windowId) {
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            DataOutputStream os = new DataOutputStream(buffer);
            os.writeByte(4);
            if (inventory instanceof TileEntity) {
                TileEntity te = (TileEntity)inventory;
                os.writeByte(0);
                os.writeInt(te.func_145831_w().field_73011_w.field_76574_g);
                os.writeInt(te.field_145851_c);
                os.writeInt(te.field_145848_d);
                os.writeInt(te.field_145849_e);
            } else if (entityPlayer.field_71071_by.func_70448_g() != null && entityPlayer.field_71071_by.func_70448_g().func_77973_b() instanceof IHandHeldInventory) {
                os.writeByte(1);
                os.writeInt(entityPlayer.field_71071_by.field_70461_c);
            } else {
                IC2.platform.displayError("An unknown GUI type was attempted to be displayed.\nThis could happen due to corrupted data from a player or a bug.\n\n(Technical information: " + inventory + ")");
            }
            os.writeInt(windowId);
            os.close();
            S3FPacketCustomPayload packet = new S3FPacketCustomPayload("ic2classic", buffer.toByteArray());
            entityPlayer.field_71135_a.field_147371_a.func_150725_a((Packet)packet, new GenericFutureListener[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void onPacketDataServer(byte[] packetdata, EntityPlayerMP player) {
        block14: {
            ByteArrayInputStream isRaw = new ByteArrayInputStream(packetdata, 1, packetdata.length - 1);
            try {
                block1 : switch (packetdata[0]) {
                    case 0: {
                        System.out.println("got removed packet 0 on server");
                        break;
                    }
                    case 1: {
                        DataInputStream is = new DataInputStream(isRaw);
                        int itemId = is.readInt();
                        int itemDamage = is.readInt();
                        int event = is.readInt();
                        Item item = Item.func_150899_d((int)itemId);
                        if (item instanceof INetworkItemEventListener) {
                            ((INetworkItemEventListener)item).onNetworkEvent(itemDamage, (EntityPlayer)player, event);
                        }
                        break;
                    }
                    case 2: {
                        DataInputStream is = new DataInputStream(isRaw);
                        int keyState = is.readInt();
                        IC2.keyboard.processKeyUpdate((EntityPlayer)player, keyState);
                        break;
                    }
                    case 3: {
                        DataInputStream is = new DataInputStream(isRaw);
                        int dimensionId = is.readInt();
                        int x = is.readInt();
                        int y = is.readInt();
                        int z = is.readInt();
                        int event = is.readInt();
                        WorldServer[] worldServerArray = DimensionManager.getWorlds();
                        int n = worldServerArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            WorldServer world = worldServerArray[n2];
                            if (dimensionId == world.field_73011_w.field_76574_g) {
                                TileEntity te = world.func_147438_o(x, y, z);
                                if (te instanceof INetworkClientTileEntityEventListener) {
                                    ((INetworkClientTileEntityEventListener)te).onNetworkEvent((EntityPlayer)player, event);
                                    break block1;
                                }
                                break block14;
                            }
                            ++n2;
                        }
                        break;
                    }
                    case 4: {
                        GZIPInputStream gzip = new GZIPInputStream((InputStream)isRaw, packetdata.length - 1);
                        DataInputStream is = new DataInputStream(gzip);
                        int clientNetworkProtocolVersion = is.readInt();
                        if (clientNetworkProtocolVersion != 1) {
                            player.field_71135_a.func_147360_c("IC2 network protocol version mismatch (expected 1 (1.112.170-lf), got " + clientNetworkProtocolVersion + ")");
                        }
                        boolean enableQuantumSpeedOnSprint = is.readByte() != 0;
                        ItemArmorQuantumSuit.enableQuantumSpeedOnSprintMap.put((EntityPlayer)player, enableQuantumSpeedOnSprint);
                        is.close();
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void initiateKeyUpdate(int keyState) {
    }

    public void initiateExplosionEffect(World world, double x, double y, double z) {
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            DataOutputStream os = new DataOutputStream(buffer);
            os.writeByte(5);
            os.writeInt(world.field_73011_w.field_76574_g);
            os.writeDouble(x);
            os.writeDouble(y);
            os.writeDouble(z);
            os.close();
            S3FPacketCustomPayload packet = new S3FPacketCustomPayload("ic2classic", buffer.toByteArray());
            for (Object player : world.field_73010_i) {
                EntityPlayerMP entityPlayer = (EntityPlayerMP)player;
                if (!(entityPlayer.func_70092_e(x, y, z) < 128.0)) continue;
                entityPlayer.field_71135_a.field_147371_a.func_150725_a((Packet)packet, new GenericFutureListener[0]);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    class TileEntityField {
        TileEntity te;
        String field;
        EntityPlayerMP target = null;

        TileEntityField(TileEntity te, String field) {
            this.te = te;
            this.field = field;
        }

        TileEntityField(TileEntity te, String field, EntityPlayerMP target) {
            this.te = te;
            this.field = field;
            this.target = target;
        }

        public boolean equals(Object obj) {
            if (obj instanceof TileEntityField) {
                TileEntityField tef = (TileEntityField)obj;
                return tef.te == this.te && tef.field.equals(this.field);
            }
            return false;
        }

        public int hashCode() {
            return this.te.hashCode() * 31 ^ this.field.hashCode();
        }
    }
}

