/*
 * Decompiled with CFR 0.152.
 */
package ic2classic.core.block;

import ic2classic.core.IC2;
import ic2classic.core.IHasGui;
import ic2classic.core.block.BlockContainerCommon;
import ic2classic.core.block.TileEntityBlock;
import ic2classic.core.util.StackUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class BlockMultiID
extends BlockContainerCommon {
    public static final int[][] sideAndFacingToSpriteOffset;

    static {
        int[][] nArrayArray = new int[6][];
        int[] nArray = new int[6];
        nArray[0] = 3;
        nArray[1] = 2;
        nArrayArray[0] = nArray;
        nArrayArray[1] = new int[]{2, 3, 1, 1, 1, 1};
        nArrayArray[2] = new int[]{1, 1, 3, 2, 5, 4};
        int[] nArray2 = new int[6];
        nArray2[2] = 2;
        nArray2[3] = 3;
        nArray2[4] = 4;
        nArray2[5] = 5;
        nArrayArray[3] = nArray2;
        nArrayArray[4] = new int[]{4, 5, 4, 5, 3, 2};
        nArrayArray[5] = new int[]{5, 4, 5, 4, 2, 3};
        sideAndFacingToSpriteOffset = nArrayArray;
    }

    protected BlockMultiID(Material mat) {
        super(mat);
        this.func_149647_a(IC2.tabIC2);
    }

    protected abstract IIcon[] getIconSheet();

    public IIcon func_149673_e(IBlockAccess iblockaccess, int i, int j, int k, int side) {
        TileEntity te = iblockaccess.func_147438_o(i, j, k);
        short facing = te instanceof TileEntityBlock ? ((TileEntityBlock)te).getFacing() : (short)0;
        int meta = iblockaccess.func_72805_g(i, j, k);
        if (BlockMultiID.isActive(iblockaccess, i, j, k)) {
            return this.getIconSheet()[meta + (sideAndFacingToSpriteOffset[side][facing] + 6) * 16];
        }
        return this.getIconSheet()[meta + sideAndFacingToSpriteOffset[side][facing] * 16];
    }

    public IIcon func_149691_a(int side, int meta) {
        return this.getIconSheet()[meta + sideAndFacingToSpriteOffset[side][3] * 16];
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer entityPlayer, int side, float a, float b, float c) {
        if (entityPlayer.func_70093_af()) {
            return false;
        }
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof IHasGui) {
            if (IC2.platform.isSimulating()) {
                return IC2.platform.launchGui(entityPlayer, (IHasGui)te);
            }
            return true;
        }
        return false;
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList ret = super.getDrops(world, x, y, z, metadata, fortune);
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof IInventory) {
            IInventory inv = (IInventory)te;
            int i = 0;
            while (i < inv.func_70302_i_()) {
                ItemStack itemStack = inv.func_70301_a(i);
                if (itemStack != null) {
                    ret.add(itemStack);
                    inv.func_70299_a(i, null);
                }
                ++i;
            }
        }
        return ret;
    }

    public void func_149749_a(World world, int x, int y, int z, Block a, int b) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityBlock) {
            ((TileEntityBlock)te).onBlockBreak(a, b);
        }
        boolean firstItem = true;
        for (ItemStack itemStack : this.getDrops(world, x, y, z, world.func_72805_g(x, y, z), 0)) {
            if (firstItem) {
                firstItem = false;
                continue;
            }
            StackUtil.dropAsEntity(world, x, y, z, itemStack);
        }
        super.func_149749_a(world, x, y, z, a, b);
    }

    public void func_149689_a(World world, int i, int j, int k, EntityLivingBase entityliving, ItemStack stack) {
        if (!IC2.platform.isSimulating()) {
            return;
        }
        TileEntityBlock te = (TileEntityBlock)world.func_147438_o(i, j, k);
        if (entityliving == null) {
            te.setFacing((short)2);
        } else {
            int l = MathHelper.func_76128_c((double)((double)(entityliving.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
            switch (l) {
                case 0: {
                    te.setFacing((short)2);
                    break;
                }
                case 1: {
                    te.setFacing((short)5);
                    break;
                }
                case 2: {
                    te.setFacing((short)3);
                    break;
                }
                case 3: {
                    te.setFacing((short)4);
                }
            }
        }
    }

    public static boolean isActive(IBlockAccess iblockaccess, int i, int j, int k) {
        TileEntity te = iblockaccess.func_147438_o(i, j, k);
        if (te instanceof TileEntityBlock) {
            return ((TileEntityBlock)te).getActive();
        }
        return false;
    }

    public void func_149666_a(Item j, CreativeTabs tabs, List itemList) {
        int i = 0;
        while (i < 16) {
            ItemStack is = new ItemStack((Block)this, 1, i);
            if (Item.func_150898_a((Block)this).func_77667_c(is) != null) {
                itemList.add(is);
            }
            ++i;
        }
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        return new ItemStack((Block)this, 1, world.func_72805_g(x, y, z));
    }
}

