/*
 * Decompiled with CFR 0.152.
 */
package ic2classic.core.block.machine.tileentity;

import ic2classic.api.network.INetworkTileEntityEventListener;
import ic2classic.core.ContainerIC2;
import ic2classic.core.IC2;
import ic2classic.core.IHasGui;
import ic2classic.core.Ic2Items;
import ic2classic.core.audio.AudioSource;
import ic2classic.core.block.machine.ContainerElectricMachine;
import ic2classic.core.block.machine.tileentity.TileEntityElecMachine;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public abstract class TileEntityElectricMachine
extends TileEntityElecMachine
implements IHasGui,
INetworkTileEntityEventListener,
ISidedInventory {
    public short progress = 0;
    public int defaultEnergyConsume;
    public int defaultOperationLength;
    public int defaultMaxInput;
    public int defaultEnergyStorage;
    public int energyConsume;
    public int operationLength;
    public float serverChargeLevel;
    public float serverProgress;
    public AudioSource audioSource;

    public TileEntityElectricMachine(int slots, int e, int length, int maxinput) {
        super(slots + 4, 1, e * length + maxinput - 1, maxinput);
        this.defaultEnergyConsume = this.energyConsume = e;
        this.defaultOperationLength = this.operationLength = length;
        this.defaultMaxInput = this.maxInput;
        this.defaultEnergyStorage = e * length;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.progress = nbttagcompound.func_74765_d("progress");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74777_a("progress", this.progress);
    }

    public float getChargeLevel() {
        float ret;
        if (IC2.platform.isSimulating()) {
            ret = (float)this.energy / (float)(this.maxEnergy - this.maxInput + 1);
            if (ret > 1.0f) {
                ret = 1.0f;
            }
        } else {
            ret = this.serverChargeLevel;
        }
        return ret;
    }

    public float getProgress() {
        float ret;
        if (IC2.platform.isSimulating()) {
            ret = (float)this.progress / (float)this.operationLength;
            if (ret > 1.0f) {
                ret = 1.0f;
            }
        } else {
            ret = this.serverProgress;
        }
        return ret;
    }

    public void setChargeLevel(float chargeLevel) {
        assert (!IC2.platform.isSimulating());
        this.serverChargeLevel = chargeLevel;
    }

    public void setProgress(float progress) {
        assert (!IC2.platform.isSimulating());
        this.serverProgress = progress;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (IC2.platform.isSimulating()) {
            this.setOverclockRates();
        }
    }

    @Override
    public void onUnloaded() {
        super.onUnloaded();
        if (IC2.platform.isRendering() && this.audioSource != null) {
            IC2.audioManager.removeSources(this);
            this.audioSource = null;
        }
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (IC2.platform.isSimulating()) {
            this.setOverclockRates();
        }
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        boolean canOperate = this.canOperate();
        boolean needsInvUpdate = false;
        if (this.energy <= this.energyConsume * this.operationLength && canOperate) {
            needsInvUpdate = this.provideEnergy();
        }
        boolean newActive = this.getActive();
        if (this.progress >= this.operationLength) {
            this.operate();
            needsInvUpdate = true;
            this.progress = 0;
            newActive = false;
            IC2.network.initiateTileEntityEvent(this, 2, true);
        }
        canOperate = this.canOperate();
        if (!newActive || this.progress == 0) {
            if (canOperate) {
                if (this.energy >= this.energyConsume) {
                    newActive = true;
                    IC2.network.initiateTileEntityEvent(this, 0, true);
                }
            } else {
                this.progress = 0;
            }
        } else if (!canOperate || this.energy < this.energyConsume) {
            if (!canOperate) {
                this.progress = 0;
            }
            newActive = false;
            IC2.network.initiateTileEntityEvent(this, 1, true);
        }
        if (newActive) {
            this.progress = (short)(this.progress + 1);
            this.energy -= this.energyConsume;
        }
        if (needsInvUpdate) {
            this.func_70296_d();
        }
        if (newActive != this.getActive()) {
            this.setActive(newActive);
        }
    }

    public void setOverclockRates() {
        int overclockerUpgradeCount = 0;
        int transformerUpgradeCount = 0;
        int energyStorageUpgradeCount = 0;
        int i = 0;
        while (i < 4) {
            ItemStack itemStack = this.inventory[i + this.inventory.length - 4];
            if (itemStack != null) {
                if (itemStack.func_77969_a(Ic2Items.overclockerUpgrade)) {
                    overclockerUpgradeCount += itemStack.field_77994_a;
                } else if (itemStack.func_77969_a(Ic2Items.transformerUpgrade)) {
                    transformerUpgradeCount += itemStack.field_77994_a;
                } else if (itemStack.func_77969_a(Ic2Items.energyStorageUpgrade)) {
                    energyStorageUpgradeCount += itemStack.field_77994_a;
                }
            }
            ++i;
        }
        if (overclockerUpgradeCount > 32) {
            overclockerUpgradeCount = 32;
        }
        if (transformerUpgradeCount > 10) {
            transformerUpgradeCount = 10;
        }
        this.energyConsume = (int)((double)this.defaultEnergyConsume * Math.pow(1.6, overclockerUpgradeCount));
        this.operationLength = (int)Math.round((double)this.defaultOperationLength * Math.pow(0.7, overclockerUpgradeCount));
        this.maxInput = this.defaultMaxInput * (int)Math.pow(4.0, transformerUpgradeCount);
        this.maxEnergy = this.defaultEnergyStorage + energyStorageUpgradeCount * 10000 + this.maxInput - 1;
        this.tier = transformerUpgradeCount + 1;
        if (this.operationLength < 1) {
            this.operationLength = 1;
        }
    }

    @Override
    public boolean provideEnergy() {
        if (this.inventory[this.fuelslot] != null && this.inventory[this.fuelslot].func_77973_b() == Items.field_151137_ax) {
            this.energy += this.defaultEnergyConsume * this.defaultOperationLength;
            --this.inventory[this.fuelslot].field_77994_a;
            if (this.inventory[this.fuelslot].field_77994_a <= 0) {
                this.inventory[this.fuelslot] = null;
            }
            return true;
        }
        return super.provideEnergy();
    }

    public void operate() {
        ItemStack processResult;
        if (!this.canOperate()) {
            return;
        }
        if (this.inventory[0].func_77973_b().hasContainerItem(this.inventory[0])) {
            processResult = this.getResultFor(this.inventory[0], false).func_77946_l();
            this.inventory[0] = this.inventory[0].func_77973_b().getContainerItem(this.inventory[0]);
        } else {
            processResult = this.getResultFor(this.inventory[0], true).func_77946_l();
        }
        if (this.inventory[0].field_77994_a <= 0) {
            this.inventory[0] = null;
        }
        if (this.inventory[2] == null) {
            this.inventory[2] = processResult;
        } else {
            this.inventory[2].field_77994_a += processResult.field_77994_a;
        }
    }

    public boolean canOperate() {
        if (this.inventory[0] == null) {
            return false;
        }
        ItemStack processResult = this.getResultFor(this.inventory[0], false);
        if (processResult == null) {
            return false;
        }
        if (this.inventory[2] == null) {
            return true;
        }
        if (!this.inventory[2].func_77969_a(processResult)) {
            return false;
        }
        return this.inventory[2].field_77994_a + processResult.field_77994_a <= this.inventory[2].func_77976_d();
    }

    public abstract ItemStack getResultFor(ItemStack var1, boolean var2);

    @Override
    public abstract String func_145825_b();

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerElectricMachine(entityPlayer, this);
    }

    @Override
    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    public String getStartSoundFile() {
        return null;
    }

    public String getInterruptSoundFile() {
        return null;
    }

    @Override
    public void onNetworkEvent(int event) {
        if (this.audioSource == null && this.getStartSoundFile() != null) {
            this.audioSource = IC2.audioManager.createSource(this, this.getStartSoundFile());
        }
        switch (event) {
            case 0: {
                if (this.audioSource == null) break;
                this.audioSource.play();
                break;
            }
            case 1: {
                if (this.audioSource == null) break;
                this.audioSource.stop();
                if (this.getInterruptSoundFile() == null) break;
                IC2.audioManager.playOnce(this, this.getInterruptSoundFile());
                break;
            }
            case 2: {
                if (this.audioSource == null) break;
                this.audioSource.stop();
            }
        }
    }

    public int[] getAccessibleSlotsFromSideDefault(int side) {
        if (side == 0) {
            return new int[]{1};
        }
        if (side == 1) {
            return new int[1];
        }
        return new int[]{2};
    }
}

