/*
 * Decompiled with CFR 0.152.
 */
package ic2classic.core.block.wiring;

import cpw.mods.fml.common.registry.GameRegistry;
import ic2classic.api.Direction;
import ic2classic.api.IPaintableBlock;
import ic2classic.core.IC2;
import ic2classic.core.Ic2Icons;
import ic2classic.core.Ic2Items;
import ic2classic.core.block.BlockMultiID;
import ic2classic.core.block.TileEntityBlock;
import ic2classic.core.block.wiring.TileEntityCable;
import ic2classic.core.block.wiring.TileEntityCableDetector;
import ic2classic.core.block.wiring.TileEntityCableSplitter;
import ic2classic.core.item.tool.ItemToolCutter;
import ic2classic.core.util.AabbUtil;
import ic2classic.core.util.StackUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockCable
extends BlockMultiID
implements IPaintableBlock {
    private static final Direction[] directions = Direction.values();

    public BlockCable() {
        super(Material.field_151573_f);
        this.func_149711_c(0.2f);
        this.func_149672_a(Block.field_149775_l);
        GameRegistry.registerBlock((Block)this, (String)"cableBlock");
        Ic2Items.copperCableBlock = new ItemStack((Block)this, 1, 1);
        Ic2Items.insulatedCopperCableBlock = new ItemStack((Block)this, 1, 0);
        Ic2Items.goldCableBlock = new ItemStack((Block)this, 1, 2);
        Ic2Items.insulatedGoldCableBlock = new ItemStack((Block)this, 1, 3);
        Ic2Items.doubleInsulatedGoldCableBlock = new ItemStack((Block)this, 1, 4);
        Ic2Items.ironCableBlock = new ItemStack((Block)this, 1, 5);
        Ic2Items.insulatedIronCableBlock = new ItemStack((Block)this, 1, 6);
        Ic2Items.doubleInsulatedIronCableBlock = new ItemStack((Block)this, 1, 7);
        Ic2Items.trippleInsulatedIronCableBlock = new ItemStack((Block)this, 1, 8);
        Ic2Items.glassFiberCableBlock = new ItemStack((Block)this, 1, 9);
        Ic2Items.tinCableBlock = new ItemStack((Block)this, 1, 10);
        Ic2Items.detectorCableBlock = new ItemStack((Block)this, 1, 11);
        Ic2Items.splitterCableBlock = new ItemStack((Block)this, 1, 12);
    }

    public String getTextureFile() {
        return "/ic2classic/sprites/block_cable.png";
    }

    @Override
    protected IIcon[] getIconSheet() {
        return Ic2Icons.bcable;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public IIcon func_149673_e(IBlockAccess iblockaccess, int x, int y, int z, int side) {
        short cableType;
        int color = 0;
        TileEntity te = iblockaccess.func_147438_o(x, y, z);
        if (!(te instanceof TileEntityCable)) {
            cableType = (short)iblockaccess.func_72805_g(x, y, z);
            return Ic2Icons.bcable[cableType * 16 + color];
        }
        TileEntityCable cable = (TileEntityCable)te;
        if (cable.foamed != 0) {
            if (cable.foamed != 1) return Ic2Icons.bcable[208 + cable.foamColor];
            return Ic2Icons.bcable_178;
        }
        cableType = cable.cableType;
        if (!(te instanceof TileEntityCableDetector) && !(te instanceof TileEntityCableSplitter)) {
            color = cable.color;
            return Ic2Icons.bcable[cableType * 16 + color];
        }
        color = cable.getActive() ? 1 : 0;
        return Ic2Icons.bcable[cableType * 16 + color];
    }

    @Override
    public IIcon func_149691_a(int side, int meta) {
        return this.getIconSheet()[meta * 16];
    }

    public MovingObjectPosition func_149731_a(World world, int x, int y, int z, Vec3 origin, Vec3 absDirection) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (!(te instanceof TileEntityCable)) {
            return null;
        }
        TileEntityCable tileEntityCable = (TileEntityCable)te;
        Vec3 direction = Vec3.func_72443_a((double)(absDirection.field_72450_a - origin.field_72450_a), (double)(absDirection.field_72448_b - origin.field_72448_b), (double)(absDirection.field_72449_c - origin.field_72449_c));
        double maxLength = direction.func_72433_c();
        double halfThickness = (double)tileEntityCable.getCableThickness() / 2.0;
        boolean hit = false;
        Vec3 intersection = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        Direction intersectingDirection = AabbUtil.getIntersection(origin, direction, AxisAlignedBB.func_72330_a((double)((double)x + 0.5 - halfThickness), (double)((double)y + 0.5 - halfThickness), (double)((double)z + 0.5 - halfThickness), (double)((double)x + 0.5 + halfThickness), (double)((double)y + 0.5 + halfThickness), (double)((double)z + 0.5 + halfThickness)), intersection);
        if (intersectingDirection != null && intersection.func_72438_d(origin) <= maxLength) {
            hit = true;
        }
        Direction[] directionArray = directions;
        int n = directions.length;
        int n2 = 0;
        while (n2 < n) {
            Direction dir = directionArray[n2];
            if (hit) break;
            TileEntity target = dir.applyToTileEntity(tileEntityCable);
            if (tileEntityCable.canInteractWith(target)) {
                AxisAlignedBB bbox = null;
                switch (dir) {
                    case XN: {
                        bbox = AxisAlignedBB.func_72330_a((double)x, (double)((double)y + 0.5 - halfThickness), (double)((double)z + 0.5 - halfThickness), (double)((double)x + 0.5), (double)((double)y + 0.5 + halfThickness), (double)((double)z + 0.5 + halfThickness));
                        break;
                    }
                    case XP: {
                        bbox = AxisAlignedBB.func_72330_a((double)((double)x + 0.5), (double)((double)y + 0.5 - halfThickness), (double)((double)z + 0.5 - halfThickness), (double)((double)x + 1.0), (double)((double)y + 0.5 + halfThickness), (double)((double)z + 0.5 + halfThickness));
                        break;
                    }
                    case YN: {
                        bbox = AxisAlignedBB.func_72330_a((double)((double)x + 0.5 - halfThickness), (double)y, (double)((double)z + 0.5 - halfThickness), (double)((double)x + 0.5 + halfThickness), (double)((double)y + 0.5), (double)((double)z + 0.5 + halfThickness));
                        break;
                    }
                    case YP: {
                        bbox = AxisAlignedBB.func_72330_a((double)((double)x + 0.5 - halfThickness), (double)((double)y + 0.5), (double)((double)z + 0.5 - halfThickness), (double)((double)x + 0.5 + halfThickness), (double)((double)y + 1.0), (double)((double)z + 0.5 + halfThickness));
                        break;
                    }
                    case ZN: {
                        bbox = AxisAlignedBB.func_72330_a((double)((double)x + 0.5 - halfThickness), (double)((double)y + 0.5 - halfThickness), (double)z, (double)((double)x + 0.5 + halfThickness), (double)((double)y + 0.5), (double)((double)z + 0.5));
                        break;
                    }
                    case ZP: {
                        bbox = AxisAlignedBB.func_72330_a((double)((double)x + 0.5 - halfThickness), (double)((double)y + 0.5 - halfThickness), (double)((double)z + 0.5), (double)((double)x + 0.5 + halfThickness), (double)((double)y + 0.5 + halfThickness), (double)((double)z + 1.0));
                    }
                }
                intersectingDirection = AabbUtil.getIntersection(origin, direction, bbox, intersection);
                if (intersectingDirection != null && intersection.func_72438_d(origin) <= maxLength) {
                    hit = true;
                }
            }
            ++n2;
        }
        if (hit) {
            return new MovingObjectPosition(x, y, z, intersectingDirection.toSideValue(), intersection);
        }
        return null;
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int x, int y, int z, int meta) {
        double halfThickness = TileEntityCable.getCableThickness(meta);
        return AxisAlignedBB.func_72330_a((double)((double)x + 0.5 - halfThickness), (double)((double)y + 0.5 - halfThickness), (double)((double)z + 0.5 - halfThickness), (double)((double)x + 0.5 + halfThickness), (double)((double)y + 0.5 + halfThickness), (double)((double)z + 0.5 + halfThickness));
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        return this.getCommonBoundingBoxFromPool(world, x, y, z, false);
    }

    public AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        return this.getCommonBoundingBoxFromPool(world, x, y, z, true);
    }

    public AxisAlignedBB getCommonBoundingBoxFromPool(World world, int x, int y, int z, boolean selectionBoundingBox) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (!(te instanceof TileEntityCable)) {
            return this.getCollisionBoundingBoxFromPool(world, x, y, z, 3);
        }
        TileEntityCable cable = (TileEntityCable)te;
        double halfThickness = cable.foamed == 1 && selectionBoundingBox ? 0.5 : (double)cable.getCableThickness() / 2.0;
        double minX = (double)x + 0.5 - halfThickness;
        double minY = (double)y + 0.5 - halfThickness;
        double minZ = (double)z + 0.5 - halfThickness;
        double maxX = (double)x + 0.5 + halfThickness;
        double maxY = (double)y + 0.5 + halfThickness;
        double maxZ = (double)z + 0.5 + halfThickness;
        if (cable.canInteractWith(world.func_147438_o(x - 1, y, z))) {
            minX = x;
        }
        if (cable.canInteractWith(world.func_147438_o(x, y - 1, z))) {
            minY = y;
        }
        if (cable.canInteractWith(world.func_147438_o(x, y, z - 1))) {
            minZ = z;
        }
        if (cable.canInteractWith(world.func_147438_o(x + 1, y, z))) {
            maxX = x + 1;
        }
        if (cable.canInteractWith(world.func_147438_o(x, y + 1, z))) {
            maxY = y + 1;
        }
        if (cable.canInteractWith(world.func_147438_o(x, y, z + 1))) {
            maxZ = z + 1;
        }
        return AxisAlignedBB.func_72330_a((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
    }

    public boolean isBlockNormalCube(World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityCable) {
            TileEntityCable cable = (TileEntityCable)te;
            if (cable.foamed > 0) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer entityPlayer, int side, float a, float b, float c) {
        ItemStack cur = entityPlayer.func_71045_bC();
        if (cur != null && cur.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150354_m)) {
            if (!IC2.platform.isSimulating()) {
                return true;
            }
            TileEntity te = world.func_147438_o(x, y, z);
            if (te instanceof TileEntityCable) {
                TileEntityCable cable = (TileEntityCable)te;
                if (cable.foamed == 1 && cable.changeFoam((byte)2)) {
                    --cur.field_77994_a;
                    if (cur.field_77994_a <= 0) {
                        entityPlayer.field_71071_by.field_70462_a[entityPlayer.field_71071_by.field_70461_c] = null;
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public static int getCableColor(IBlockAccess iblockaccess, int i, int j, int k) {
        TileEntity te = iblockaccess.func_147438_o(i, j, k);
        return te instanceof TileEntityCable ? (int)((TileEntityCable)te).color : 0;
    }

    @Override
    public boolean colorBlock(World world, int i, int j, int k, int color) {
        return ((TileEntityCable)world.func_147438_o(i, j, k)).changeColor(color);
    }

    public boolean canHarvestBlock(EntityPlayer player, int md) {
        return true;
    }

    @Override
    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityCable) {
            TileEntityCable cable = (TileEntityCable)te;
            ret.add(new ItemStack(Ic2Items.insulatedCopperCableItem.func_77973_b(), 1, (int)cable.cableType));
        } else if (metadata != 13) {
            ret.add(new ItemStack(Ic2Items.insulatedCopperCableItem.func_77973_b(), 1, metadata));
        }
        return ret;
    }

    @Override
    public void func_149749_a(World world, int x, int y, int z, Block a, int b) {
        TileEntity te;
        if (world.func_72805_g(x, y, z) == 13 && (te = world.func_147438_o(x, y, z)) instanceof TileEntityCable) {
            TileEntityCable cable = (TileEntityCable)te;
            StackUtil.dropAsEntity(world, x, y, z, new ItemStack(Ic2Items.insulatedCopperCableItem.func_77973_b(), 1, (int)cable.cableType));
        }
        super.func_149749_a(world, x, y, z, a, b);
    }

    public TileEntityBlock createNewTileEntity(World world, int meta) {
        if (meta == 11) {
            return new TileEntityCableDetector((short)meta);
        }
        if (meta == 12) {
            return new TileEntityCableSplitter((short)meta);
        }
        return new TileEntityCable((short)meta);
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return IC2.platform.getRenderId("cable");
    }

    public boolean func_149662_c() {
        return false;
    }

    public void func_149699_a(World world, int i, int j, int k, EntityPlayer entityplayer) {
        if (entityplayer.func_71045_bC() != null && entityplayer.func_71045_bC().func_77973_b() instanceof ItemToolCutter) {
            ItemToolCutter.cutInsulationFrom(entityplayer.func_71045_bC(), world, i, j, k);
        }
    }

    public int func_149709_b(IBlockAccess iblockaccess, int x, int y, int z, int side) {
        TileEntity te = iblockaccess.func_147438_o(x, y, z);
        if (te instanceof TileEntityCableDetector) {
            return ((TileEntityCableDetector)te).getActive() ? 15 : 0;
        }
        return 0;
    }

    @Override
    public void func_149666_a(Item i, CreativeTabs tabs, List itemList) {
    }

    public float func_149712_f(World world, int x, int y, int z) {
        if (world != null && world.func_72805_g(x, y, z) == 13) {
            return 3.0f;
        }
        return 0.2f;
    }

    public float getExplosionResistance(Entity exploder, World world, int x, int y, int z, double src_x, double src_y, double src_z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityCable) {
            TileEntityCable cable = (TileEntityCable)te;
            if (cable.foamed == 2) {
                return 90.0f;
            }
        }
        return 6.0f;
    }

    public boolean canConnectRedstone(IBlockAccess world, int X, int Y, int Z, int direction) {
        int meta = world.func_72805_g(X, Y, Z);
        return meta == 11 || meta == 12;
    }

    @Override
    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        return new ItemStack(Ic2Items.insulatedCopperCableItem.func_77973_b(), 1, world.func_72805_g(x, y, z));
    }
}

