/*
 * Decompiled with CFR 0.152.
 */
package ic2classic.core.block.wiring;

import cpw.mods.fml.common.registry.GameRegistry;
import ic2classic.core.IC2;
import ic2classic.core.Ic2Icons;
import ic2classic.core.Ic2Items;
import ic2classic.core.block.BlockMultiID;
import ic2classic.core.block.TileEntityBlock;
import ic2classic.core.block.wiring.TileEntityElectricBatBox;
import ic2classic.core.block.wiring.TileEntityElectricBlock;
import ic2classic.core.block.wiring.TileEntityElectricMFE;
import ic2classic.core.block.wiring.TileEntityElectricMFSU;
import ic2classic.core.block.wiring.TileEntityTransformerHV;
import ic2classic.core.block.wiring.TileEntityTransformerLV;
import ic2classic.core.block.wiring.TileEntityTransformerMV;
import ic2classic.core.item.block.ItemElectricBlock;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockElectric
extends BlockMultiID {
    public BlockElectric() {
        super(Material.field_151573_f);
        this.func_149711_c(1.5f);
        this.func_149672_a(Block.field_149777_j);
        this.func_149647_a(IC2.tabIC2);
        GameRegistry.registerBlock((Block)this, ItemElectricBlock.class, (String)"blockElectric");
        Ic2Items.batBox = new ItemStack((Block)this, 1, 0);
        Ic2Items.mfeUnit = new ItemStack((Block)this, 1, 1);
        Ic2Items.mfsUnit = new ItemStack((Block)this, 1, 2);
        Ic2Items.lvTransformer = new ItemStack((Block)this, 1, 3);
        Ic2Items.mvTransformer = new ItemStack((Block)this, 1, 4);
        Ic2Items.hvTransformer = new ItemStack((Block)this, 1, 5);
    }

    public String getTextureFile() {
        return "/ic2classic/sprites/block_electric.png";
    }

    @Override
    protected IIcon[] getIconSheet() {
        return Ic2Icons.belec;
    }

    public Item func_149650_a(int meta, Random random, int j) {
        if (meta == 0 || meta == 3) {
            return Item.func_150898_a((Block)this);
        }
        return Ic2Items.machine.func_77973_b();
    }

    public int func_149692_a(int meta) {
        if (meta == 0 || meta == 3) {
            return meta;
        }
        return Ic2Items.machine.func_77960_j();
    }

    public int func_149745_a(Random random) {
        return 1;
    }

    public int func_149709_b(IBlockAccess iblockaccess, int x, int y, int z, int side) {
        TileEntity te = iblockaccess.func_147438_o(x, y, z);
        if (te instanceof TileEntityElectricBlock) {
            TileEntityElectricBlock electricBlock = (TileEntityElectricBlock)te;
            return electricBlock.isEmittingRedstone() ? 15 : 0;
        }
        return 0;
    }

    public boolean isBlockNormalCube(World world, int i, int j, int k) {
        return false;
    }

    public boolean isBlockOpaqueCube(World world, int i, int j, int k) {
        return true;
    }

    public boolean func_149747_d(IBlockAccess world, int i, int j, int k, int l) {
        return true;
    }

    public boolean isBlockSolidOnSide(World world, int x, int y, int z, ForgeDirection side) {
        return true;
    }

    public TileEntityBlock createNewTileEntity(World world, int meta) {
        switch (meta) {
            case 0: {
                return new TileEntityElectricBatBox();
            }
            case 1: {
                return new TileEntityElectricMFE();
            }
            case 2: {
                return new TileEntityElectricMFSU();
            }
            case 3: {
                return new TileEntityTransformerLV();
            }
            case 4: {
                return new TileEntityTransformerMV();
            }
            case 5: {
                return new TileEntityTransformerHV();
            }
        }
        return null;
    }

    @Override
    public void func_149689_a(World world, int i, int j, int k, EntityLivingBase entityliving, ItemStack stack) {
        if (!IC2.platform.isSimulating()) {
            return;
        }
        TileEntityBlock te = (TileEntityBlock)world.func_147438_o(i, j, k);
        if (entityliving == null) {
            te.setFacing((short)1);
        } else {
            int yaw = MathHelper.func_76128_c((double)((double)(entityliving.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
            int pitch = Math.round(entityliving.field_70125_A);
            if (pitch >= 65) {
                te.setFacing((short)1);
            } else if (pitch <= -65) {
                te.setFacing((short)0);
            } else {
                switch (yaw) {
                    case 0: {
                        te.setFacing((short)2);
                        break;
                    }
                    case 1: {
                        te.setFacing((short)5);
                        break;
                    }
                    case 2: {
                        te.setFacing((short)3);
                        break;
                    }
                    case 3: {
                        te.setFacing((short)4);
                    }
                }
            }
        }
    }
}

