/*
 * Decompiled with CFR 0.152.
 */
package ic2classic.core.block.wiring;

import cpw.mods.fml.common.eventhandler.Event;
import ic2classic.api.Direction;
import ic2classic.api.IElectricItem;
import ic2classic.api.IEnergyStorage;
import ic2classic.api.energy.event.EnergyTileLoadEvent;
import ic2classic.api.energy.event.EnergyTileSourceEvent;
import ic2classic.api.energy.event.EnergyTileUnloadEvent;
import ic2classic.api.energy.tile.IEnergySink;
import ic2classic.api.energy.tile.IEnergySource;
import ic2classic.api.network.INetworkClientTileEntityEventListener;
import ic2classic.core.ContainerIC2;
import ic2classic.core.IC2;
import ic2classic.core.IHasGui;
import ic2classic.core.Ic2Items;
import ic2classic.core.block.machine.tileentity.TileEntityMachine;
import ic2classic.core.block.wiring.ContainerElectricBlock;
import ic2classic.core.item.ElectricItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.MinecraftForge;

public abstract class TileEntityElectricBlock
extends TileEntityMachine
implements IEnergySink,
IEnergySource,
IHasGui,
ISidedInventory,
INetworkClientTileEntityEventListener,
IEnergyStorage {
    public int tier;
    public int output;
    public int maxStorage;
    public int energy = 0;
    public byte redstoneMode = 0;
    public static byte redstoneModes = (byte)6;
    public boolean addedToEnergyNet = false;

    public TileEntityElectricBlock(int tierc, int outputc, int maxStoragec) {
        super(2);
        this.tier = tierc;
        this.output = outputc;
        this.maxStorage = maxStoragec;
    }

    public String getNameByTier() {
        switch (this.tier) {
            case 1: {
                return StatCollector.func_74838_a((String)"blockBatBox.name");
            }
            case 2: {
                return StatCollector.func_74838_a((String)"blockMFE.name");
            }
            case 3: {
                return StatCollector.func_74838_a((String)"blockMFSU.name");
            }
        }
        return null;
    }

    public float getChargeLevel() {
        float ret = (float)this.energy / (float)this.maxStorage;
        if (ret > 1.0f) {
            ret = 1.0f;
        }
        return ret;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.setActiveWithoutNotify(nbttagcompound.func_74767_n("active"));
        this.energy = nbttagcompound.func_74762_e("energy");
        if (this.maxStorage > Integer.MAX_VALUE) {
            this.energy *= 10;
        }
        this.redstoneMode = nbttagcompound.func_74771_c("redstoneMode");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        int write = this.energy;
        if (this.maxStorage > Integer.MAX_VALUE) {
            write /= 10;
        }
        nbttagcompound.func_74768_a("energy", write);
        nbttagcompound.func_74757_a("active", this.getActive());
        nbttagcompound.func_74774_a("redstoneMode", this.redstoneMode);
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (IC2.platform.isSimulating()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.addedToEnergyNet = true;
        }
    }

    @Override
    public void onUnloaded() {
        if (IC2.platform.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.addedToEnergyNet = false;
        }
        super.onUnloaded();
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        boolean needsInvUpdate = false;
        if (this.energy > 0 && this.inventory[0] != null && this.inventory[0].func_77973_b() instanceof IElectricItem) {
            int sent = ElectricItem.charge(this.inventory[0], this.energy, this.tier, false, false);
            this.energy -= sent;
            boolean bl = needsInvUpdate = sent > 0;
        }
        if (this.demandsEnergy() > 0 && this.inventory[1] != null) {
            int gain;
            if (this.inventory[1].func_77973_b() instanceof IElectricItem) {
                IElectricItem item = (IElectricItem)this.inventory[1].func_77973_b();
                if (item.canProvideEnergy()) {
                    gain = ElectricItem.discharge(this.inventory[1], this.maxStorage - this.energy, this.tier, false, false);
                    this.energy += gain;
                    needsInvUpdate = gain > 0;
                }
            } else {
                Item id = this.inventory[1].func_77973_b();
                gain = 0;
                if (id == Items.field_151137_ax) {
                    gain = 500;
                }
                if (id == Ic2Items.suBattery) {
                    gain = 1000;
                }
                if (gain > 0 && gain <= this.maxStorage - this.energy) {
                    --this.inventory[1].field_77994_a;
                    if (this.inventory[1].field_77994_a <= 0) {
                        this.inventory[1] = null;
                    }
                    this.energy += gain;
                }
            }
        }
        boolean isFull = false;
        if (this.energy >= this.maxStorage) {
            isFull = true;
        }
        this.setActive(isFull);
        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e));
        if (!(this.energy < this.output || this.redstoneMode == 4 && this.field_145850_b.func_94577_B(this.field_145851_c, this.field_145848_d, this.field_145849_e) != 0 || this.redstoneMode == 5 && this.field_145850_b.func_94577_B(this.field_145851_c, this.field_145848_d, this.field_145849_e) != 0 && this.energy < this.maxStorage)) {
            EnergyTileSourceEvent event = new EnergyTileSourceEvent(this, this.output);
            MinecraftForge.EVENT_BUS.post((Event)event);
            this.energy -= this.output - event.amount;
        }
        if (needsInvUpdate) {
            this.func_70296_d();
        }
    }

    @Override
    public boolean isAddedToEnergyNet() {
        return this.addedToEnergyNet;
    }

    @Override
    public boolean acceptsEnergyFrom(TileEntity emitter, Direction direction) {
        return !this.facingMatchesDirection(direction);
    }

    @Override
    public boolean emitsEnergyTo(TileEntity receiver, Direction direction) {
        return this.facingMatchesDirection(direction);
    }

    public boolean facingMatchesDirection(Direction direction) {
        return direction.toSideValue() == this.getFacing();
    }

    @Override
    public int getMaxEnergyOutput() {
        return this.output;
    }

    @Override
    public int demandsEnergy() {
        return this.maxStorage - this.energy;
    }

    @Override
    public boolean injectEnergy(Direction directionFrom, int amount) {
        if (amount > this.output) {
            IC2.explodeMachineAt(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return true;
        }
        if (this.energy >= this.maxStorage) {
            return false;
        }
        this.energy += amount;
        return true;
    }

    @Override
    public int getMaxSafeInput() {
        return this.output;
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerElectricBlock(entityPlayer, this);
    }

    @Override
    public String getGuiClassName(EntityPlayer entityPlayer) {
        return "block.wiring.GuiElectricBlock";
    }

    @Override
    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    @Override
    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return this.getFacing() != side;
    }

    @Override
    public void setFacing(short facing) {
        if (this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
        }
        this.addedToEnergyNet = false;
        super.setFacing(facing);
        MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
        this.addedToEnergyNet = true;
    }

    public boolean isEmittingRedstone() {
        switch (this.redstoneMode) {
            case 1: {
                return this.energy >= this.maxStorage;
            }
            case 2: {
                return this.energy > this.output && this.energy < this.maxStorage;
            }
            case 3: {
                return this.energy < this.output;
            }
        }
        return false;
    }

    public int[] func_94128_d(int var1) {
        if (var1 == 0) {
            return new int[]{1};
        }
        if (var1 == 1) {
            return new int[1];
        }
        return new int[0];
    }

    @Override
    public void onNetworkEvent(EntityPlayer player, int event) {
        this.redstoneMode = (byte)(this.redstoneMode + 1);
        if (this.redstoneMode >= redstoneModes) {
            this.redstoneMode = 0;
        }
        switch (this.redstoneMode) {
            case 0: {
                IC2.platform.messagePlayer(player, "Redstone Behavior: Nothing");
                break;
            }
            case 1: {
                IC2.platform.messagePlayer(player, "Redstone Behavior: Emit if full");
                break;
            }
            case 2: {
                IC2.platform.messagePlayer(player, "Redstone Behavior: Emit if partially filled");
                break;
            }
            case 3: {
                IC2.platform.messagePlayer(player, "Redstone Behavior: Emit if empty");
                break;
            }
            case 4: {
                IC2.platform.messagePlayer(player, "Redstone Behavior: Do not output energy");
                break;
            }
            case 5: {
                IC2.platform.messagePlayer(player, "Redstone Behavior: Do not output energy unless full");
            }
        }
    }

    @Override
    public int getStored() {
        return this.energy;
    }

    @Override
    public int getCapacity() {
        return this.maxStorage;
    }

    @Override
    public int getOutput() {
        return this.output;
    }

    @Override
    public void setStored(int energy) {
        this.energy = energy;
    }

    @Override
    public int addEnergy(int amount) {
        this.energy += amount;
        return amount;
    }

    @Override
    public boolean isTeleporterCompatible(Direction side) {
        return true;
    }

    @Override
    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return true;
    }

    @Override
    public boolean func_102007_a(int i, ItemStack itemstack, int j) {
        return true;
    }
}

