/*
 * Decompiled with CFR 0.152.
 */
package ic2classic.core.item.tool;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import ic2classic.core.IC2;
import ic2classic.core.IHitSoundOverride;
import ic2classic.core.Ic2Items;
import ic2classic.core.audio.AudioSource;
import ic2classic.core.audio.PositionSpec;
import ic2classic.core.item.ElectricItem;
import ic2classic.core.item.tool.ItemElectricTool;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.EntityInteractEvent;

public class ItemElectricToolChainsaw
extends ItemElectricTool
implements IHitSoundOverride {
    public static boolean wasEquipped = false;
    public static AudioSource audioSource;

    public ItemElectricToolChainsaw(int sprite) {
        super(sprite, Item.ToolMaterial.IRON, 50);
        this.maxCharge = 10000;
        this.transferLimit = 100;
        this.tier = 1;
        this.field_77864_a = 12.0f;
        this.co = 1;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void init() {
        this.mineableBlocks.add(Blocks.field_150344_f);
        this.mineableBlocks.add(Blocks.field_150364_r);
        this.mineableBlocks.add(Blocks.field_150363_s);
        this.mineableBlocks.add(Blocks.field_150486_ae);
        this.mineableBlocks.add(Blocks.field_150362_t);
        this.mineableBlocks.add(Blocks.field_150321_G);
        this.mineableBlocks.add(Block.func_149634_a((Item)Ic2Items.crop.func_77973_b()));
        if (Ic2Items.rubberLeaves != null) {
            this.mineableBlocks.add(Block.func_149634_a((Item)Ic2Items.rubberLeaves.func_77973_b()));
        }
    }

    @Override
    public boolean func_77644_a(ItemStack itemstack, EntityLivingBase entityliving, EntityLivingBase entityliving1) {
        if (ElectricItem.use(itemstack, this.operationEnergyCost, (EntityPlayer)entityliving1) && ElectricItem.use(itemstack, this.operationEnergyCost, (EntityPlayer)entityliving1)) {
            entityliving.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)entityliving1)), 10.0f);
        } else {
            entityliving.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)entityliving1)), 1.0f);
        }
        if (entityliving instanceof EntityCreeper && entityliving.func_110143_aJ() <= 0.0f) {
            IC2.achievements.issueAchievement((EntityPlayer)entityliving1, "killCreeperChainsaw");
        }
        return false;
    }

    @Override
    public boolean canHarvestBlock(Block block) {
        if (block.func_149688_o() == Material.field_151575_d) {
            return true;
        }
        return super.canHarvestBlock(block);
    }

    @SubscribeEvent
    public void onEntityInteract(EntityInteractEvent event) {
        IShearable target;
        Entity entity = event.target;
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        EntityPlayer player = event.entityPlayer;
        ItemStack itemstack = player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c];
        if (itemstack != null && itemstack.func_77973_b() == this && entity instanceof IShearable && ElectricItem.use(itemstack, this.operationEnergyCost * 2, player) && (target = (IShearable)entity).isShearable(itemstack, (IBlockAccess)entity.field_70170_p, (int)entity.field_70165_t, (int)entity.field_70163_u, (int)entity.field_70161_v)) {
            ArrayList drops = target.onSheared(itemstack, (IBlockAccess)entity.field_70170_p, (int)entity.field_70165_t, (int)entity.field_70163_u, (int)entity.field_70161_v, EnchantmentHelper.func_77506_a((int)Enchantment.field_77346_s.field_77352_x, (ItemStack)itemstack));
            for (ItemStack stack : drops) {
                EntityItem ent = entity.func_70099_a(stack, 1.0f);
                ent.field_70181_x += (double)(Item.field_77697_d.nextFloat() * 0.05f);
                ent.field_70159_w += (double)((Item.field_77697_d.nextFloat() - Item.field_77697_d.nextFloat()) * 0.1f);
                ent.field_70179_y += (double)((Item.field_77697_d.nextFloat() - Item.field_77697_d.nextFloat()) * 0.1f);
            }
        }
    }

    public void func_77663_a(ItemStack itemstack, World world, Entity entity, int i, boolean flag) {
        boolean isEquipped;
        boolean bl = isEquipped = flag && entity instanceof EntityLivingBase;
        if (IC2.platform.isRendering()) {
            if (isEquipped && !wasEquipped) {
                if (audioSource == null) {
                    audioSource = IC2.audioManager.createSource(entity, PositionSpec.Hand, "Tools/Chainsaw/ChainsawIdle.ogg", true, false, IC2.audioManager.defaultVolume);
                }
                if (audioSource != null) {
                    audioSource.play();
                }
            } else if (!isEquipped && audioSource != null) {
                audioSource.stop();
                audioSource.remove();
                audioSource = null;
                if (entity instanceof EntityLivingBase) {
                    IC2.audioManager.playOnce(entity, PositionSpec.Hand, "Tools/Chainsaw/ChainsawStop.ogg", true, IC2.audioManager.defaultVolume);
                }
            } else if (audioSource != null) {
                audioSource.updatePosition();
            }
            wasEquipped = isEquipped;
        }
    }

    @Override
    public String getHitSoundForBlock(int x, int y, int z) {
        String[] soundEffects = new String[]{"Tools/Chainsaw/ChainsawUseOne.ogg", "Tools/Chainsaw/ChainsawUseTwo.ogg"};
        return soundEffects[Item.field_77697_d.nextInt(soundEffects.length)];
    }
}

