/*
 * Decompiled with CFR 0.152.
 */
package ic2classic.core.item.tool;

import ic2classic.api.IElectricItem;
import ic2classic.core.IC2;
import ic2classic.core.item.ElectricItem;
import ic2classic.core.item.tool.ItemToolWrench;
import ic2classic.core.util.StackUtil;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class ItemToolWrenchElectric
extends ItemToolWrench
implements IElectricItem {
    public ItemToolWrenchElectric(int index) {
        super(index);
        this.func_77656_e(27);
        this.func_77625_d(1);
    }

    public ItemStack func_77659_a(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        if (IC2.platform.isSimulating() && IC2.keyboard.isModeSwitchKeyDown(entityplayer)) {
            NBTTagCompound nbtData = StackUtil.getOrCreateNbtData(itemstack);
            boolean newValue = !nbtData.func_74767_n("losslessMode");
            nbtData.func_74757_a("losslessMode", newValue);
            if (newValue) {
                IC2.platform.messagePlayer(entityplayer, "Lossless wrench mode enabled");
            } else {
                IC2.platform.messagePlayer(entityplayer, "Lossless wrench mode disabled");
            }
        }
        return itemstack;
    }

    @Override
    public boolean onItemUseFirst(ItemStack itemstack, EntityPlayer entityPlayer, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (IC2.keyboard.isModeSwitchKeyDown(entityPlayer)) {
            return false;
        }
        return super.onItemUseFirst(itemstack, entityPlayer, world, x, y, z, side, hitX, hitY, hitZ);
    }

    @Override
    public boolean canTakeDamage(ItemStack stack, int amount) {
        return ElectricItem.discharge(stack, amount *= 50, Integer.MAX_VALUE, true, true) == amount;
    }

    @Override
    public void damage(ItemStack itemStack, int amount, EntityPlayer player) {
        ElectricItem.use(itemStack, 50 * amount, player);
    }

    @Override
    public boolean canProvideEnergy() {
        return false;
    }

    @Override
    public Item getChargedItemId() {
        return this;
    }

    @Override
    public Item getEmptyItemId() {
        return this;
    }

    @Override
    public int getMaxCharge() {
        return 12000;
    }

    @Override
    public int getTier() {
        return 1;
    }

    @Override
    public int getTransferLimit() {
        return 250;
    }

    public void func_150895_a(Item i, CreativeTabs tabs, List itemList) {
        ItemStack charged = new ItemStack((Item)this, 1);
        ElectricItem.charge(charged, Integer.MAX_VALUE, Integer.MAX_VALUE, true, false);
        itemList.add(charged);
        itemList.add(new ItemStack((Item)this, 1, this.func_77612_l()));
    }

    @Override
    public boolean overrideWrenchSuccessRate(ItemStack itemStack) {
        NBTTagCompound nbtData = StackUtil.getOrCreateNbtData(itemStack);
        return nbtData.func_74767_n("losslessMode");
    }
}

