/*
 * Decompiled with CFR 0.152.
 */
package ic2classic.core;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import ic2classic.api.Direction;
import ic2classic.api.energy.event.EnergyTileLoadEvent;
import ic2classic.api.energy.event.EnergyTileSourceEvent;
import ic2classic.api.energy.event.EnergyTileUnloadEvent;
import ic2classic.api.energy.tile.IEnergyAcceptor;
import ic2classic.api.energy.tile.IEnergyConductor;
import ic2classic.api.energy.tile.IEnergyEmitter;
import ic2classic.api.energy.tile.IEnergySink;
import ic2classic.api.energy.tile.IEnergySource;
import ic2classic.api.energy.tile.IEnergyTile;
import ic2classic.core.IC2;
import ic2classic.core.IC2DamageSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;

public final class EnergyNet {
    public static final double minConductionLoss = 1.0E-4;
    private static final Direction[] directions = Direction.values();
    private static Map<World, EnergyNet> worldToEnergyNetMap = new WeakHashMap<World, EnergyNet>();
    private final World world;
    private final Map<Object, List<EnergyPath>> energySourceToEnergyPathMap = new WeakHashMap<Object, List<EnergyPath>>();
    private final Map<EntityLivingBase, Integer> entityLivingToShockEnergyMap = new WeakHashMap<EntityLivingBase, Integer>();

    public static void initialize() {
        new EventHandler();
    }

    public static EnergyNet getForWorld(World world) {
        if (world == null) {
            IC2.log.warn("EnergyNet.getForWorld: world = null, bad things may happen..");
            return null;
        }
        if (!worldToEnergyNetMap.containsKey(world)) {
            worldToEnergyNetMap.put(world, new EnergyNet(world));
        }
        return worldToEnergyNetMap.get(world);
    }

    public static void onTick(World world) {
        IC2.platform.profilerStartSection("Shocking");
        EnergyNet energyNet = EnergyNet.getForWorld(world);
        for (Map.Entry<EntityLivingBase, Integer> entry : energyNet.entityLivingToShockEnergyMap.entrySet()) {
            EntityLivingBase target = entry.getKey();
            int damage = (entry.getValue() + 63) / 64;
            if (!target.func_70089_S()) continue;
            target.func_70097_a((DamageSource)IC2DamageSource.electricity, (float)damage);
        }
        energyNet.entityLivingToShockEnergyMap.clear();
        IC2.platform.profilerEndSection();
    }

    private EnergyNet(World world) {
        this.world = world;
    }

    public void addTileEntity(TileEntity addedTileEntity) {
        if (!(addedTileEntity instanceof IEnergyTile) || ((IEnergyTile)addedTileEntity).isAddedToEnergyNet()) {
            return;
        }
        if (addedTileEntity instanceof IEnergyAcceptor) {
            List<EnergyPath> reverseEnergyPaths = this.discover(addedTileEntity, true, Integer.MAX_VALUE);
            for (EnergyPath reverseEnergyPath : reverseEnergyPaths) {
                IEnergySource energySource = (IEnergySource)reverseEnergyPath.target;
                if (!this.energySourceToEnergyPathMap.containsKey(energySource) || !((double)energySource.getMaxEnergyOutput() > reverseEnergyPath.loss)) continue;
                this.energySourceToEnergyPathMap.remove(energySource);
            }
        }
        if (addedTileEntity instanceof IEnergySource) {
            // empty if block
        }
    }

    public void removeTileEntity(TileEntity removedTileEntity) {
        if (!(removedTileEntity instanceof IEnergyTile) || !((IEnergyTile)removedTileEntity).isAddedToEnergyNet()) {
            boolean alreadyRemoved = !((IEnergyTile)removedTileEntity).isAddedToEnergyNet();
            IC2.log.warn("removing " + removedTileEntity + " from the EnergyNet failed, already removed: " + alreadyRemoved);
            return;
        }
        if (removedTileEntity instanceof IEnergyAcceptor) {
            List<EnergyPath> reverseEnergyPaths = this.discover(removedTileEntity, true, Integer.MAX_VALUE);
            for (EnergyPath reverseEnergyPath : reverseEnergyPaths) {
                IEnergySource energySource = (IEnergySource)reverseEnergyPath.target;
                if (!this.energySourceToEnergyPathMap.containsKey(energySource) || !((double)energySource.getMaxEnergyOutput() > reverseEnergyPath.loss)) continue;
                if (removedTileEntity instanceof IEnergyConductor) {
                    this.energySourceToEnergyPathMap.remove(energySource);
                    continue;
                }
                Iterator<EnergyPath> it = this.energySourceToEnergyPathMap.get(energySource).iterator();
                while (it.hasNext()) {
                    if (it.next().target != removedTileEntity) continue;
                    it.remove();
                }
            }
        }
        if (removedTileEntity instanceof IEnergySource) {
            this.energySourceToEnergyPathMap.remove(removedTileEntity);
        }
    }

    public int emitEnergyFrom(IEnergySource energySource, int amount) {
        if (!energySource.isAddedToEnergyNet()) {
            IC2.log.warn("EnergyNet.emitEnergyFrom: " + energySource + " is not added to the enet");
            return amount;
        }
        if (!this.energySourceToEnergyPathMap.containsKey(energySource)) {
            this.energySourceToEnergyPathMap.put(energySource, this.discover((TileEntity)energySource, false, energySource.getMaxEnergyOutput()));
        }
        ArrayList<EnergyPath> activeEnergyPaths = new ArrayList<EnergyPath>();
        double totalInvLoss = 0.0;
        for (EnergyPath energyPath : this.energySourceToEnergyPathMap.get(energySource)) {
            assert (energyPath.target instanceof IEnergySink);
            IEnergySink energySink = (IEnergySink)energyPath.target;
            if (energySink.demandsEnergy() <= 0 || !(energyPath.loss < (double)amount)) continue;
            totalInvLoss += 1.0 / energyPath.loss;
            activeEnergyPaths.add(energyPath);
        }
        Collections.shuffle(activeEnergyPaths);
        int i = activeEnergyPaths.size() - amount;
        while (i > 0) {
            EnergyPath removedEnergyPath = (EnergyPath)activeEnergyPaths.remove(activeEnergyPaths.size() - 1);
            totalInvLoss -= 1.0 / removedEnergyPath.loss;
            --i;
        }
        HashMap<EnergyPath, Integer> suppliedEnergyPaths = new HashMap<EnergyPath, Integer>();
        while (!activeEnergyPaths.isEmpty() && amount > 0) {
            int energyConsumed = 0;
            double newTotalInvLoss = 0.0;
            ArrayList<EnergyPath> currentActiveEnergyPaths = activeEnergyPaths;
            activeEnergyPaths = new ArrayList();
            activeEnergyPaths.iterator();
            for (EnergyPath energyPath : currentActiveEnergyPaths) {
                int energyLoss;
                IEnergySink energySink = (IEnergySink)energyPath.target;
                int energyProvided = (int)Math.floor((double)Math.round((double)amount / totalInvLoss / energyPath.loss * 100000.0) / 100000.0);
                if (energyProvided > (energyLoss = (int)Math.floor(energyPath.loss))) {
                    boolean energyAccepted = energySink.injectEnergy(energyPath.targetDirection, energyProvided - energyLoss);
                    if (energyAccepted) {
                        activeEnergyPaths.add(energyPath);
                        newTotalInvLoss += 1.0 / energyPath.loss;
                    } else {
                        IC2.log.warn("API ERROR: " + energySink + " didn't implement demandsEnergy() properly, no energy from injectEnergy accepted although demandsEnergy() returned true.");
                    }
                    energyConsumed += energyProvided;
                    int energyInjected = energyProvided - energyLoss;
                    if (!suppliedEnergyPaths.containsKey(energyPath)) {
                        suppliedEnergyPaths.put(energyPath, energyInjected);
                        continue;
                    }
                    suppliedEnergyPaths.put(energyPath, energyInjected + (Integer)suppliedEnergyPaths.get(energyPath));
                    continue;
                }
                activeEnergyPaths.add(energyPath);
                newTotalInvLoss += 1.0 / energyPath.loss;
            }
            if (energyConsumed == 0 && !activeEnergyPaths.isEmpty()) {
                EnergyPath removedEnergyPath = (EnergyPath)activeEnergyPaths.remove(activeEnergyPaths.size() - 1);
                newTotalInvLoss -= 1.0 / removedEnergyPath.loss;
            }
            totalInvLoss = newTotalInvLoss;
            amount -= energyConsumed;
        }
        for (Map.Entry entry : suppliedEnergyPaths.entrySet()) {
            EnergyPath energyPath = (EnergyPath)entry.getKey();
            int energyInjected = (Integer)entry.getValue();
            energyPath.totalEnergyConducted += (long)energyInjected;
            if (energyInjected > energyPath.minInsulationEnergyAbsorption) {
                List entitiesNearEnergyPath = this.world.func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)(energyPath.minX - 1), (double)(energyPath.minY - 1), (double)(energyPath.minZ - 1), (double)(energyPath.maxX + 2), (double)(energyPath.maxY + 2), (double)(energyPath.maxZ + 2)));
                for (EntityLivingBase entityLiving : entitiesNearEnergyPath) {
                    int maxShockEnergy = 0;
                    for (IEnergyConductor energyConductor : energyPath.conductors) {
                        TileEntity te = (TileEntity)energyConductor;
                        if (!entityLiving.field_70121_D.func_72326_a(AxisAlignedBB.func_72330_a((double)(te.field_145851_c - 1), (double)(te.field_145848_d - 1), (double)(te.field_145849_e - 1), (double)(te.field_145851_c + 2), (double)(te.field_145848_d + 2), (double)(te.field_145849_e + 2)))) continue;
                        int shockEnergy = energyInjected - energyConductor.getInsulationEnergyAbsorption();
                        if (shockEnergy > maxShockEnergy) {
                            maxShockEnergy = shockEnergy;
                        }
                        if (energyConductor.getInsulationEnergyAbsorption() == energyPath.minInsulationEnergyAbsorption) break;
                    }
                    if (this.entityLivingToShockEnergyMap.containsKey(entityLiving)) {
                        this.entityLivingToShockEnergyMap.put(entityLiving, this.entityLivingToShockEnergyMap.get(entityLiving) + maxShockEnergy);
                        continue;
                    }
                    this.entityLivingToShockEnergyMap.put(entityLiving, maxShockEnergy);
                }
                if (energyInjected >= energyPath.minInsulationBreakdownEnergy) {
                    for (IEnergyConductor energyConductor : energyPath.conductors) {
                        if (energyInjected < energyConductor.getInsulationBreakdownEnergy()) continue;
                        energyConductor.removeInsulation();
                        if (energyConductor.getInsulationEnergyAbsorption() >= energyPath.minInsulationEnergyAbsorption) continue;
                        energyPath.minInsulationEnergyAbsorption = energyConductor.getInsulationEnergyAbsorption();
                    }
                }
            }
            if (energyInjected < energyPath.minConductorBreakdownEnergy) continue;
            for (IEnergyConductor energyConductor : energyPath.conductors) {
                if (energyInjected < energyConductor.getConductorBreakdownEnergy()) continue;
                energyConductor.removeConductor();
            }
        }
        return amount;
    }

    @Deprecated
    public long getTotalEnergyConducted(TileEntity tileEntity) {
        long ret = 0L;
        if (tileEntity instanceof IEnergyConductor || tileEntity instanceof IEnergySink) {
            List<EnergyPath> reverseEnergyPaths = this.discover(tileEntity, true, Integer.MAX_VALUE);
            for (EnergyPath reverseEnergyPath : reverseEnergyPaths) {
                IEnergySource energySource = (IEnergySource)reverseEnergyPath.target;
                if (!this.energySourceToEnergyPathMap.containsKey(energySource) || !((double)energySource.getMaxEnergyOutput() > reverseEnergyPath.loss)) continue;
                for (EnergyPath energyPath : this.energySourceToEnergyPathMap.get(energySource)) {
                    if ((!(tileEntity instanceof IEnergySink) || energyPath.target != tileEntity) && (!(tileEntity instanceof IEnergyConductor) || !energyPath.conductors.contains(tileEntity))) continue;
                    ret += energyPath.totalEnergyConducted;
                }
            }
        }
        if (tileEntity instanceof IEnergySource && this.energySourceToEnergyPathMap.containsKey(tileEntity)) {
            for (EnergyPath energyPath : this.energySourceToEnergyPathMap.get(tileEntity)) {
                ret += energyPath.totalEnergyConducted;
            }
        }
        return ret;
    }

    public long getTotalEnergyEmitted(TileEntity tileEntity) {
        long ret = 0L;
        if (tileEntity instanceof IEnergyConductor) {
            List<EnergyPath> reverseEnergyPaths = this.discover(tileEntity, true, Integer.MAX_VALUE);
            for (EnergyPath reverseEnergyPath : reverseEnergyPaths) {
                IEnergySource energySource = (IEnergySource)reverseEnergyPath.target;
                if (!this.energySourceToEnergyPathMap.containsKey(energySource) || !((double)energySource.getMaxEnergyOutput() > reverseEnergyPath.loss)) continue;
                for (EnergyPath energyPath : this.energySourceToEnergyPathMap.get(energySource)) {
                    if (!(tileEntity instanceof IEnergyConductor) || !energyPath.conductors.contains(tileEntity)) continue;
                    ret += energyPath.totalEnergyConducted;
                }
            }
        }
        if (tileEntity instanceof IEnergySource && this.energySourceToEnergyPathMap.containsKey(tileEntity)) {
            for (EnergyPath energyPath : this.energySourceToEnergyPathMap.get(tileEntity)) {
                ret += energyPath.totalEnergyConducted;
            }
        }
        return ret;
    }

    public long getTotalEnergySunken(TileEntity tileEntity) {
        long ret = 0L;
        if (tileEntity instanceof IEnergyConductor || tileEntity instanceof IEnergySink) {
            List<EnergyPath> reverseEnergyPaths = this.discover(tileEntity, true, Integer.MAX_VALUE);
            for (EnergyPath reverseEnergyPath : reverseEnergyPaths) {
                IEnergySource energySource = (IEnergySource)reverseEnergyPath.target;
                if (!this.energySourceToEnergyPathMap.containsKey(energySource) || !((double)energySource.getMaxEnergyOutput() > reverseEnergyPath.loss)) continue;
                for (EnergyPath energyPath : this.energySourceToEnergyPathMap.get(energySource)) {
                    if ((!(tileEntity instanceof IEnergySink) || energyPath.target != tileEntity) && (!(tileEntity instanceof IEnergyConductor) || !energyPath.conductors.contains(tileEntity))) continue;
                    ret += energyPath.totalEnergyConducted;
                }
            }
        }
        return ret;
    }

    private List<EnergyPath> discover(TileEntity emitter, boolean reverse, int lossLimit) {
        HashMap<TileEntity, EnergyBlockLink> reachedTileEntities = new HashMap<TileEntity, EnergyBlockLink>();
        LinkedList<TileEntity> tileEntitiesToCheck = new LinkedList<TileEntity>();
        tileEntitiesToCheck.add(emitter);
        while (!tileEntitiesToCheck.isEmpty()) {
            TileEntity currentTileEntity = (TileEntity)tileEntitiesToCheck.remove();
            if (currentTileEntity.func_145837_r()) continue;
            double currentLoss = 0.0;
            if (currentTileEntity != emitter) {
                currentLoss = ((EnergyBlockLink)reachedTileEntities.get((Object)currentTileEntity)).loss;
            }
            List<EnergyTarget> validReceivers = this.getValidReceivers(currentTileEntity, reverse);
            for (EnergyTarget validReceiver : validReceivers) {
                if (validReceiver.tileEntity == emitter) continue;
                double additionalLoss = 0.0;
                if (validReceiver.tileEntity instanceof IEnergyConductor) {
                    additionalLoss = ((IEnergyConductor)validReceiver.tileEntity).getConductionLoss();
                    if (additionalLoss < 1.0E-4) {
                        additionalLoss = 1.0E-4;
                    }
                    if (currentLoss + additionalLoss >= (double)lossLimit) continue;
                }
                if (reachedTileEntities.containsKey(validReceiver.tileEntity) && !(((EnergyBlockLink)reachedTileEntities.get((Object)validReceiver.tileEntity)).loss > currentLoss + additionalLoss)) continue;
                reachedTileEntities.put(validReceiver.tileEntity, new EnergyBlockLink(validReceiver.direction, currentLoss + additionalLoss));
                if (!(validReceiver.tileEntity instanceof IEnergyConductor)) continue;
                tileEntitiesToCheck.remove(validReceiver.tileEntity);
                tileEntitiesToCheck.add(validReceiver.tileEntity);
            }
        }
        LinkedList<EnergyPath> energyPaths = new LinkedList<EnergyPath>();
        for (Map.Entry entry : reachedTileEntities.entrySet()) {
            TileEntity tileEntity = (TileEntity)entry.getKey();
            if ((reverse || !(tileEntity instanceof IEnergySink)) && (!reverse || !(tileEntity instanceof IEnergySource))) continue;
            EnergyBlockLink energyBlockLink = (EnergyBlockLink)entry.getValue();
            EnergyPath energyPath = new EnergyPath();
            energyPath.loss = energyBlockLink.loss > 0.1 ? energyBlockLink.loss : 0.1;
            energyPath.target = tileEntity;
            energyPath.targetDirection = energyBlockLink.direction;
            if (!reverse && emitter instanceof IEnergySource) {
                while ((tileEntity = energyBlockLink.direction.applyToTileEntity(tileEntity)) != emitter && tileEntity instanceof IEnergyConductor) {
                    IEnergyConductor energyConductor = (IEnergyConductor)tileEntity;
                    if (tileEntity.field_145851_c < energyPath.minX) {
                        energyPath.minX = tileEntity.field_145851_c;
                    }
                    if (tileEntity.field_145848_d < energyPath.minY) {
                        energyPath.minY = tileEntity.field_145848_d;
                    }
                    if (tileEntity.field_145849_e < energyPath.minZ) {
                        energyPath.minZ = tileEntity.field_145849_e;
                    }
                    if (tileEntity.field_145851_c > energyPath.maxX) {
                        energyPath.maxX = tileEntity.field_145851_c;
                    }
                    if (tileEntity.field_145848_d > energyPath.maxY) {
                        energyPath.maxY = tileEntity.field_145848_d;
                    }
                    if (tileEntity.field_145849_e > energyPath.maxZ) {
                        energyPath.maxZ = tileEntity.field_145849_e;
                    }
                    energyPath.conductors.add(energyConductor);
                    if (energyConductor.getInsulationEnergyAbsorption() < energyPath.minInsulationEnergyAbsorption) {
                        energyPath.minInsulationEnergyAbsorption = energyConductor.getInsulationEnergyAbsorption();
                    }
                    if (energyConductor.getInsulationBreakdownEnergy() < energyPath.minInsulationBreakdownEnergy) {
                        energyPath.minInsulationBreakdownEnergy = energyConductor.getInsulationBreakdownEnergy();
                    }
                    if (energyConductor.getConductorBreakdownEnergy() < energyPath.minConductorBreakdownEnergy) {
                        energyPath.minConductorBreakdownEnergy = energyConductor.getConductorBreakdownEnergy();
                    }
                    if ((energyBlockLink = (EnergyBlockLink)reachedTileEntities.get(tileEntity)) != null) continue;
                    IC2.platform.displayError("An energy network pathfinding entry is corrupted.\nThis could happen due to incorrect Minecraft behavior or a bug.\n\n(Technical information: energyBlockLink, tile entities below)\nE: " + emitter + " (" + emitter.field_145851_c + "," + emitter.field_145848_d + "," + emitter.field_145849_e + ")\n" + "C: " + tileEntity + " (" + tileEntity.field_145851_c + "," + tileEntity.field_145848_d + "," + tileEntity.field_145849_e + ")\n" + "R: " + energyPath.target + " (" + energyPath.target.field_145851_c + "," + energyPath.target.field_145848_d + "," + energyPath.target.field_145849_e + ")");
                }
            }
            energyPaths.add(energyPath);
        }
        return energyPaths;
    }

    public List<TileEntity> discoverTargets(TileEntity emitter, boolean reverse, int lossLimit) {
        List<EnergyPath> paths = this.discover(emitter, reverse, lossLimit);
        LinkedList<TileEntity> targets = new LinkedList<TileEntity>();
        for (EnergyPath path : paths) {
            targets.add(path.target);
        }
        return targets;
    }

    private List<EnergyTarget> getValidReceivers(TileEntity emitter, boolean reverse) {
        LinkedList<EnergyTarget> validReceivers = new LinkedList<EnergyTarget>();
        Direction[] directionArray = directions;
        int n = directions.length;
        int n2 = 0;
        while (n2 < n) {
            Direction direction = directionArray[n2];
            TileEntity target = direction.applyToTileEntity(emitter);
            if (target instanceof IEnergyTile && ((IEnergyTile)target).isAddedToEnergyNet()) {
                Direction inverseDirection = direction.getInverse();
                if ((!reverse && emitter instanceof IEnergyEmitter && ((IEnergyEmitter)emitter).emitsEnergyTo(target, direction) || reverse && emitter instanceof IEnergyAcceptor && ((IEnergyAcceptor)emitter).acceptsEnergyFrom(target, direction)) && (!reverse && target instanceof IEnergyAcceptor && ((IEnergyAcceptor)target).acceptsEnergyFrom(emitter, inverseDirection) || reverse && target instanceof IEnergyEmitter && ((IEnergyEmitter)target).emitsEnergyTo(emitter, inverseDirection))) {
                    validReceivers.add(new EnergyTarget(target, inverseDirection));
                }
            }
            ++n2;
        }
        return validReceivers;
    }

    static class EnergyBlockLink {
        Direction direction;
        double loss;

        EnergyBlockLink(Direction direction, double loss) {
            this.direction = direction;
            this.loss = loss;
        }
    }

    static class EnergyPath {
        TileEntity target = null;
        Direction targetDirection;
        Set<IEnergyConductor> conductors = new HashSet<IEnergyConductor>();
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        double loss = 0.0;
        int minInsulationEnergyAbsorption = Integer.MAX_VALUE;
        int minInsulationBreakdownEnergy = Integer.MAX_VALUE;
        int minConductorBreakdownEnergy = Integer.MAX_VALUE;
        long totalEnergyConducted = 0L;

        EnergyPath() {
        }
    }

    static class EnergyTarget {
        TileEntity tileEntity;
        Direction direction;

        EnergyTarget(TileEntity tileEntity, Direction direction) {
            this.tileEntity = tileEntity;
            this.direction = direction;
        }
    }

    public static class EventHandler {
        public EventHandler() {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }

        @SubscribeEvent
        public void onEnergyTileLoad(EnergyTileLoadEvent event) {
            EnergyNet.getForWorld(event.world).addTileEntity((TileEntity)event.energyTile);
        }

        @SubscribeEvent
        public void onEnergyTileUnload(EnergyTileUnloadEvent event) {
            EnergyNet.getForWorld(event.world).removeTileEntity((TileEntity)event.energyTile);
        }

        @SubscribeEvent
        public void onEnergyTileSource(EnergyTileSourceEvent event) {
            event.amount = EnergyNet.getForWorld(event.world).emitEnergyFrom((IEnergySource)event.energyTile, event.amount);
        }
    }
}

