/*
 * Decompiled with CFR 0.152.
 */
package ic2classic.core.audio;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2classic.core.IC2;
import ic2classic.core.audio.AudioManager;
import ic2classic.core.audio.AudioPosition;
import ic2classic.core.audio.AudioSource;
import ic2classic.core.audio.AudioSourceClient;
import ic2classic.core.audio.PositionSpec;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundCategory;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.audio.SoundManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import paulscode.sound.SoundSystem;
import paulscode.sound.SoundSystemConfig;

@SideOnly(value=Side.CLIENT)
public final class AudioManagerClient
extends AudioManager {
    public float fadingDistance = 16.0f;
    private boolean enabled = true;
    private int maxSourceCount = 32;
    private int streamingSourceCount = 4;
    private SoundSystem soundSystem = null;
    private float masterVolume = 0.5f;
    private int nextId = 0;
    private Map<Object, List<AudioSource>> objectToAudioSourceMap = new HashMap<Object, List<AudioSource>>();

    public AudioManagerClient() {
        this.defaultVolume = 1.2f;
    }

    @Override
    public void initialize(Configuration config) {
        if (config != null) {
            Property prop = config.get("general", "soundsEnabled", this.enabled);
            prop.comment = "Enable sounds";
            this.enabled = Boolean.parseBoolean(prop.getString());
            prop = config.get("general", "soundSourceLimit", this.maxSourceCount);
            prop.comment = "Maximum number of audio sources, only change if you know what you're doing";
            this.maxSourceCount = Integer.parseInt(prop.getString());
            config.save();
        }
        if (this.maxSourceCount <= 6) {
            IC2.log.info("Audio source limit too low to enable IC2 sounds.");
            this.enabled = false;
        }
        if (!this.enabled) {
            IC2.log.info("Sounds disabled.");
            return;
        }
        if (this.maxSourceCount < 6) {
            this.enabled = false;
            return;
        }
        IC2.log.info("Using " + this.maxSourceCount + " audio sources.");
        SoundSystemConfig.setNumberStreamingChannels((int)this.streamingSourceCount);
        SoundSystemConfig.setNumberNormalChannels((int)(this.maxSourceCount - this.streamingSourceCount));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onTick() {
        if (!this.enabled || this.soundSystem == null) {
            return;
        }
        IC2.platform.profilerStartSection("UpdateMasterVolume");
        float configSoundVolume = Minecraft.func_71410_x().field_71474_y.func_151438_a(SoundCategory.MASTER);
        if (configSoundVolume != this.masterVolume) {
            this.masterVolume = configSoundVolume;
        }
        IC2.platform.profilerEndStartSection("UpdateSourceVolume");
        EntityPlayer player = IC2.platform.getPlayerInstance();
        if (player == null) {
            ArrayList<Object> audioSourceCarriers = new ArrayList<Object>(this.objectToAudioSourceMap.keySet());
            for (Object e : audioSourceCarriers) {
                this.removeSources(e);
            }
        } else {
            PriorityQueue<AudioSource> validAudioSources = new PriorityQueue<AudioSource>();
            for (List<AudioSource> list : this.objectToAudioSourceMap.values()) {
                for (AudioSource audioSource : list) {
                    audioSource.updateVolume(player);
                    if (!(audioSource.getRealVolume() > 0.0f)) continue;
                    validAudioSources.add(audioSource);
                }
            }
            IC2.platform.profilerEndStartSection("Culling");
            boolean bl = false;
            while (!validAudioSources.isEmpty()) {
                void var4_10;
                if (var4_10 < this.maxSourceCount) {
                    ((AudioSource)validAudioSources.poll()).activate();
                } else {
                    ((AudioSource)validAudioSources.poll()).cull();
                }
                ++var4_10;
            }
        }
        IC2.platform.profilerEndSection();
    }

    @Override
    public AudioSource createSource(Object obj, String initialSoundFile) {
        return this.createSource(obj, PositionSpec.Center, initialSoundFile, false, false, this.defaultVolume);
    }

    @Override
    public AudioSource createSource(Object obj, PositionSpec positionSpec, String initialSoundFile, boolean loop, boolean priorized, float volume) {
        if (!this.enabled) {
            return null;
        }
        if (this.soundSystem == null) {
            this.getSoundSystem();
        }
        if (this.soundSystem == null) {
            return null;
        }
        String sourceName = this.getSourceName(this.nextId);
        ++this.nextId;
        AudioSourceClient audioSource = new AudioSourceClient(this.soundSystem, sourceName, obj, positionSpec, initialSoundFile, loop, priorized, volume);
        if (!this.objectToAudioSourceMap.containsKey(obj)) {
            this.objectToAudioSourceMap.put(obj, new LinkedList());
        }
        this.objectToAudioSourceMap.get(obj).add(audioSource);
        return audioSource;
    }

    @Override
    public void removeSources(Object obj) {
        if (this.soundSystem == null) {
            return;
        }
        if (!this.objectToAudioSourceMap.containsKey(obj)) {
            return;
        }
        for (AudioSource audioSource : this.objectToAudioSourceMap.get(obj)) {
            audioSource.remove();
        }
        this.objectToAudioSourceMap.remove(obj);
    }

    @Override
    public void playOnce(Object obj, String soundFile) {
        this.playOnce(obj, PositionSpec.Center, soundFile, false, this.defaultVolume);
    }

    @Override
    public void playOnce(Object obj, PositionSpec positionSpec, String soundFile, boolean priorized, float volume) {
        if (!this.enabled) {
            return;
        }
        if (this.soundSystem == null) {
            this.getSoundSystem();
        }
        if (this.soundSystem == null) {
            return;
        }
        AudioPosition position = AudioPosition.getFrom(obj, positionSpec);
        if (position == null) {
            return;
        }
        URL url = AudioSource.class.getClassLoader().getResource("ic2classic/sounds/" + soundFile);
        if (url == null) {
            IC2.log.warn("Invalid sound file: " + soundFile);
            return;
        }
        String sourceName = this.soundSystem.quickPlay(priorized, url, soundFile, false, position.x, position.y, position.z, 2, this.fadingDistance * Math.max(volume, 1.0f));
        this.soundSystem.setVolume(sourceName, this.masterVolume * Math.min(volume, 1.0f));
    }

    @Override
    public float getMasterVolume() {
        return this.masterVolume;
    }

    private <T, E> T getField(Class<T> clazz, Class<E> container, E instance) {
        try {
            Field[] fieldArray = container.getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field f = fieldArray[n2];
                if (clazz.isAssignableFrom(f.getType())) {
                    f.setAccessible(true);
                    return (T)f.get(instance);
                }
                ++n2;
            }
            throw new RuntimeException("No field found on " + container.getName() + " with type " + clazz.getName());
        }
        catch (ReflectiveOperationException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void getSoundSystem() {
        this.soundSystem = this.getField(SoundSystem.class, SoundManager.class, this.getField(SoundManager.class, SoundHandler.class, Minecraft.func_71410_x().func_147118_V()));
    }

    private String getSourceName(int id) {
        return "ic2_cls" + id;
    }
}

