/*
 * Decompiled with CFR 0.152.
 */
package ic2classic.core.block.generator.tileentity;

import ic2classic.core.ContainerIC2;
import ic2classic.core.IC2;
import ic2classic.core.Ic2Items;
import ic2classic.core.block.generator.container.ContainerBaseGenerator;
import ic2classic.core.block.generator.tileentity.TileEntityBaseGenerator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidEvent;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityGeoGenerator
extends TileEntityBaseGenerator
implements ISidedInventory,
IFluidHandler {
    public int maxLava = 24000;

    @Override
    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return true;
    }

    @Override
    public boolean func_102007_a(int i, ItemStack itemstack, int j) {
        return true;
    }

    public TileEntityGeoGenerator() {
        super(2, IC2.energyGeneratorGeo, IC2.energyGeneratorGeo);
    }

    @Override
    public int gaugeFuelScaled(int i) {
        if (this.fuel <= 0) {
            return 0;
        }
        return this.fuel * i / this.maxLava;
    }

    @Override
    public boolean gainFuel() {
        if (this.inventory[1] == null || this.maxLava - this.fuel < 1000) {
            return false;
        }
        if (this.inventory[1].func_77973_b() == Items.field_151129_at) {
            this.fuel += 1000;
            this.inventory[1] = new ItemStack(Items.field_151133_ar);
            return true;
        }
        if (this.inventory[1].func_77973_b() == Ic2Items.lavaCell) {
            this.fuel += 1000;
            --this.inventory[1].field_77994_a;
            if (this.inventory[1].field_77994_a <= 0) {
                this.inventory[1] = null;
            }
            return true;
        }
        FluidStack liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)this.inventory[1]);
        if (liquid != null && liquid.getFluid() == FluidRegistry.LAVA) {
            this.fuel += 1000;
            if (this.inventory[1].func_77973_b().hasContainerItem(this.inventory[1])) {
                this.inventory[1] = this.inventory[1].func_77973_b().getContainerItem(this.inventory[1]);
            } else {
                --this.inventory[1].field_77994_a;
                if (this.inventory[1].field_77994_a <= 0) {
                    this.inventory[1] = null;
                }
            }
            return true;
        }
        return false;
    }

    public boolean gainFuelSub(ItemStack stack) {
        return false;
    }

    @Override
    public boolean needsFuel() {
        return this.fuel <= this.maxLava;
    }

    public int distributeLava(int amount) {
        int need = this.maxLava - this.fuel;
        if (need > amount) {
            need = amount;
        }
        this.fuel += need / 2;
        return amount -= need;
    }

    @Override
    public String func_145825_b() {
        if (IC2.platform.isRendering()) {
            return "Geothermal Generator";
        }
        return "Geoth. Generator";
    }

    @Override
    public String getOperationSoundFile() {
        return "Generators/GeothermalLoop.ogg";
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerBaseGenerator(entityPlayer, this);
    }

    @Override
    public String getGuiClassName(EntityPlayer entityPlayer) {
        return "block.generator.gui.GuiGeoGenerator";
    }

    public void onBlockBreak(int a, int b) {
        FluidEvent.fireEvent((FluidEvent)new FluidEvent.FluidSpilledEvent(new FluidStack(FluidRegistry.LAVA, this.fuel), this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e));
    }

    public int[] func_94128_d(int var1) {
        if (var1 > 1) {
            return new int[0];
        }
        return new int[]{var1 == 0 ? 1 : 0};
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (resource.getFluid() != FluidRegistry.LAVA) {
            return 0;
        }
        int toAdd = Math.min(resource.amount, this.maxLava - this.fuel);
        if (doFill) {
            this.fuel += toAdd;
        }
        return toAdd;
    }

    public FluidStack drain(ForgeDirection from, int maxEmpty, boolean doDrain) {
        if (this.fuel == 0) {
            return null;
        }
        int toDrain = Math.min(maxEmpty, this.fuel);
        if (doDrain) {
            this.fuel -= toDrain;
        }
        return new FluidStack(FluidRegistry.LAVA, toDrain);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return fluid == FluidRegistry.LAVA;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return fluid == FluidRegistry.LAVA;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource.getFluid() != FluidRegistry.LAVA) {
            return null;
        }
        return this.drain(from, resource.amount, doDrain);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{new FluidTankInfo(this.fuel == 0 ? null : new FluidStack(FluidRegistry.LAVA, this.fuel), this.maxLava)};
    }
}

