/*
 * Decompiled with CFR 0.152.
 */
package ic2classic.core.item.armor;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2classic.api.IMetalArmor;
import ic2classic.core.IC2;
import ic2classic.core.IC2Potion;
import ic2classic.core.IItemTickListener;
import ic2classic.core.Ic2Items;
import ic2classic.core.item.ElectricItem;
import ic2classic.core.item.ItemTinCan;
import ic2classic.core.item.armor.ItemArmorElectric;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingFallEvent;

public class ItemArmorQuantumSuit
extends ItemArmorElectric
implements IMetalArmor,
IItemTickListener {
    public static Map<EntityPlayer, Integer> speedTickerMap = new HashMap<EntityPlayer, Integer>();
    public static Map<EntityPlayer, Float> jumpChargeMap = new HashMap<EntityPlayer, Float>();
    public static Map<EntityPlayer, Boolean> enableQuantumSpeedOnSprintMap = new HashMap<EntityPlayer, Boolean>();

    public ItemArmorQuantumSuit(int index, int armorrendering, int armorType) {
        super(index, armorrendering, armorType, 1000000, 1000, 3);
        if (armorType == 3) {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        return "ic2classic:quantum";
    }

    @Override
    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        if (source == DamageSource.field_76379_h && this.field_77881_a == 3) {
            int energyPerDamage = this.getEnergyPerDamage();
            int damageLimit = energyPerDamage > 0 ? 25 * ElectricItem.discharge(armor, Integer.MAX_VALUE, Integer.MAX_VALUE, true, true) / energyPerDamage : 0;
            return new ISpecialArmor.ArmorProperties(10, 1.0, damageLimit);
        }
        return super.getProperties(player, armor, source, damage, slot);
    }

    @SubscribeEvent
    public void onEntityLivingFallEvent(LivingFallEvent event) {
        if (IC2.platform.isSimulating() && event.entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entity;
            ItemStack armor = player.field_71071_by.field_70460_b[0];
            if (armor != null && armor.func_77973_b() == this) {
                int fallDamage = (int)event.distance - 3;
                int energyCost = this.getEnergyPerDamage() * fallDamage;
                if (energyCost <= ElectricItem.discharge(armor, Integer.MAX_VALUE, Integer.MAX_VALUE, true, true)) {
                    ElectricItem.discharge(armor, energyCost, Integer.MAX_VALUE, true, false);
                    event.setCanceled(true);
                }
            }
        }
    }

    @Override
    public double getDamageAbsorptionRatio() {
        if (this.field_77881_a == 1) {
            return 1.1;
        }
        return 1.0;
    }

    @Override
    public int getEnergyPerDamage() {
        return 900;
    }

    @Override
    public boolean isMetalArmor(ItemStack itemstack, EntityPlayer player) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.rare;
    }

    @Override
    public boolean onTick(EntityPlayer player, ItemStack itemStack) {
        boolean ret = false;
        switch (this.field_77881_a) {
            case 0: {
                PotionEffect wither;
                PotionEffect radiation;
                PotionEffect poison;
                IC2.platform.profilerStartSection("QuantumHelmet");
                int air = player.func_70086_ai();
                if (ElectricItem.canUse(itemStack, 1000) && air < 100) {
                    player.func_70050_g(air + 200);
                    ElectricItem.use(itemStack, 1000, null);
                    ret = true;
                } else if (air <= 0) {
                    IC2.achievements.issueAchievement(player, "starveWithQHelmet");
                }
                if (ElectricItem.canUse(itemStack, 1000) && player.func_71024_bL().func_75121_c()) {
                    int slot = -1;
                    int i = 0;
                    while (i < player.field_71071_by.field_70462_a.length) {
                        if (player.field_71071_by.field_70462_a[i] != null && player.field_71071_by.field_70462_a[i].func_77973_b() == Ic2Items.filledTinCan) {
                            slot = i;
                            break;
                        }
                        ++i;
                    }
                    if (slot > -1) {
                        ItemStack canStack = player.field_71071_by.field_70462_a[slot];
                        ItemTinCan can = (ItemTinCan)player.field_71071_by.field_70462_a[slot].func_77973_b();
                        player.func_71024_bL().func_75122_a(can.func_150905_g(canStack), can.func_150906_h(canStack));
                        can.onCanEaten(player.field_71071_by.field_70462_a[slot], player.field_70170_p, player);
                        if (--player.field_71071_by.field_70462_a[slot].field_77994_a <= 0) {
                            player.field_71071_by.field_70462_a[slot] = null;
                        }
                        ElectricItem.use(itemStack, 1000, null);
                        ret = true;
                    }
                } else if (player.func_71024_bL().func_75116_a() <= 0) {
                    IC2.achievements.issueAchievement(player, "starveWithQHelmet");
                }
                if ((poison = player.func_70660_b(Potion.field_76436_u)) != null && ElectricItem.canUse(itemStack, 10000 * poison.func_76458_c())) {
                    ElectricItem.use(itemStack, 10000 * poison.func_76458_c(), null);
                    IC2.platform.removePotion((EntityLivingBase)player, Potion.field_76436_u.field_76415_H);
                }
                if ((radiation = player.func_70660_b((Potion)IC2Potion.radiation)) != null && ElectricItem.canUse(itemStack, 20000 * radiation.func_76458_c())) {
                    ElectricItem.use(itemStack, 20000 * radiation.func_76458_c(), null);
                    IC2.platform.removePotion((EntityLivingBase)player, IC2Potion.radiation.field_76415_H);
                }
                if ((wither = player.func_70660_b(Potion.field_82731_v)) != null && ElectricItem.canUse(itemStack, 25000 * wither.func_76458_c())) {
                    ElectricItem.use(itemStack, 25000 * wither.func_76458_c(), null);
                    IC2.platform.removePotion((EntityLivingBase)player, Potion.field_82731_v.field_76415_H);
                }
                IC2.platform.profilerEndSection();
                break;
            }
            case 1: {
                IC2.platform.profilerStartSection("QuantumBodyarmor");
                player.func_70015_d(0);
                IC2.platform.profilerEndSection();
                break;
            }
            case 2: {
                IC2.platform.profilerStartSection("QuantumLeggings");
                boolean enableQuantumSpeedOnSprint = true;
                if (IC2.platform.isRendering()) {
                    enableQuantumSpeedOnSprint = IC2.enableQuantumSpeedOnSprint;
                } else if (enableQuantumSpeedOnSprintMap.containsKey(player)) {
                    enableQuantumSpeedOnSprint = enableQuantumSpeedOnSprintMap.get(player);
                }
                if (ElectricItem.canUse(itemStack, 1000) && (player.field_70122_E && Math.abs(player.field_70159_w) + Math.abs(player.field_70179_y) > 0.1000000014901161 || player.func_70090_H() && (enableQuantumSpeedOnSprint && player.func_70051_ag() || !enableQuantumSpeedOnSprint && IC2.keyboard.isBoostKeyDown(player)))) {
                    int speedTicker;
                    int n = speedTicker = speedTickerMap.containsKey(player) ? speedTickerMap.get(player) : 0;
                    if (++speedTicker >= 10) {
                        speedTicker = 0;
                        ElectricItem.use(itemStack, 1000, null);
                        ret = true;
                    }
                    speedTickerMap.put(player, speedTicker);
                    float speed = 0.22f;
                    if (player.func_70090_H()) {
                        speed = 0.1f;
                    }
                    if (speed > 0.0f) {
                        player.func_70060_a(0.0f, 1.0f, speed);
                    }
                }
                IC2.platform.profilerEndSection();
                break;
            }
            case 3: {
                float jumpCharge;
                IC2.platform.profilerStartSection("QuantumBoots");
                float f = jumpCharge = jumpChargeMap.containsKey(player) ? jumpChargeMap.get(player).floatValue() : 1.0f;
                if (ElectricItem.canUse(itemStack, 1000) && player.field_70122_E && jumpCharge < 1.0f) {
                    jumpCharge = 1.0f;
                    ElectricItem.use(itemStack, 1000, null);
                    ret = true;
                }
                if (player.field_70181_x >= 0.0 && jumpCharge > 0.0f && !player.func_70090_H()) {
                    if (IC2.keyboard.isJumpKeyDown(player) && IC2.keyboard.isBoostKeyDown(player)) {
                        if (jumpCharge == 1.0f) {
                            player.field_70159_w *= 3.5;
                            player.field_70179_y *= 3.5;
                        }
                        player.field_70181_x += (double)(jumpCharge * 0.3f);
                        jumpCharge = (float)((double)jumpCharge * 0.75);
                    } else if (jumpCharge < 1.0f) {
                        jumpCharge = 0.0f;
                    }
                }
                jumpChargeMap.put(player, Float.valueOf(jumpCharge));
                IC2.platform.profilerEndSection();
            }
        }
        return ret;
    }
}

