/*
 * Decompiled with CFR 0.152.
 */
package ic2classic.core.item.tool;

import ic2classic.api.energy.tile.IEnergyConductor;
import ic2classic.api.energy.tile.IEnergySink;
import ic2classic.api.energy.tile.IEnergySource;
import ic2classic.core.EnergyNet;
import ic2classic.core.IC2;
import ic2classic.core.item.ItemIC2;
import ic2classic.core.util.StackUtil;
import java.text.DecimalFormat;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class ItemToolMeter
extends ItemIC2 {
    public ItemToolMeter(int index) {
        super(index);
        this.field_77777_bU = 1;
        this.func_77656_e(0);
    }

    public boolean onItemUseFirst(ItemStack itemstack, EntityPlayer entityplayer, World world, int i, int j, int k, int l, float hitX, float hitY, float hitZ) {
        TileEntity tileEntity = world.func_147438_o(i, j, k);
        if ((tileEntity instanceof IEnergySource || tileEntity instanceof IEnergyConductor || tileEntity instanceof IEnergySink) && IC2.platform.isSimulating()) {
            NBTTagCompound nbtData = StackUtil.getOrCreateNbtData(itemstack);
            long currentTotalEnergyEmitted = EnergyNet.getForWorld(world).getTotalEnergyEmitted(tileEntity);
            long currentTotalEnergySunken = EnergyNet.getForWorld(world).getTotalEnergySunken(tileEntity);
            long currentMeasureTime = world.func_82737_E();
            if (nbtData.func_74762_e("lastMeasuredTileEntityX") != i || nbtData.func_74762_e("lastMeasuredTileEntityY") != j || nbtData.func_74762_e("lastMeasuredTileEntityZ") != k) {
                nbtData.func_74768_a("lastMeasuredTileEntityX", i);
                nbtData.func_74768_a("lastMeasuredTileEntityY", j);
                nbtData.func_74768_a("lastMeasuredTileEntityZ", k);
                IC2.platform.messagePlayer(entityplayer, "Starting new measurement");
            } else {
                long measurePeriod = currentMeasureTime - nbtData.func_74763_f("lastMeasureTime");
                if (measurePeriod < 1L) {
                    measurePeriod = 1L;
                }
                double deltaEmitted = (double)(currentTotalEnergyEmitted - nbtData.func_74763_f("lastTotalEnergyEmitted")) / (double)measurePeriod;
                double deltaSunken = (double)(currentTotalEnergySunken - nbtData.func_74763_f("lastTotalEnergySunken")) / (double)measurePeriod;
                DecimalFormat powerFormat = new DecimalFormat("0.##");
                IC2.platform.messagePlayer(entityplayer, "Measured power [EU/t]: " + powerFormat.format(deltaSunken) + " in " + powerFormat.format(deltaEmitted) + " out " + powerFormat.format(deltaSunken - deltaEmitted) + " gain" + " (avg. over " + measurePeriod + " ticks)");
            }
            nbtData.func_74772_a("lastTotalEnergyEmitted", currentTotalEnergyEmitted);
            nbtData.func_74772_a("lastTotalEnergySunken", currentTotalEnergySunken);
            nbtData.func_74772_a("lastMeasureTime", currentMeasureTime);
            return true;
        }
        return false;
    }
}

